/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.adx.rtb2;

import cn.com.duiba.nezha.alg.common.util.MathUtil;

public class AdxStatBaseDo {
    private Long bid;
    private Long exp;
    private Long click;
    private Long adxConsume;
    private Long advertConsume;
    private Long advertLaunch;
    private Long advertClick;

    public Double getAdxConsume2() {
        return MathUtil.division((Long)this.adxConsume, (Double)1.0E7, (int)3);
    }

    public Double getAdxConsume3() {
        return MathUtil.division((Long)this.adxConsume, (Double)10000.0, (int)3);
    }

    public static boolean isCostConfidence(AdxStatBaseDo adxStatBaseDo) {
        boolean ret = false;
        if (adxStatBaseDo != null && adxStatBaseDo.getAdxConsume() != null && adxStatBaseDo.getAdxConsume2() > 3000.0) {
            ret = true;
        }
        return ret;
    }

    public static boolean isImpConfidence(AdxStatBaseDo adxStatBaseDo) {
        boolean ret = false;
        if (adxStatBaseDo != null && adxStatBaseDo.getExp() != null && adxStatBaseDo.getExp() > 1000L) {
            ret = true;
        }
        return ret;
    }

    public static Double getStatCtr(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if (AdxStatBaseDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division((Long)adxStatBaseDo.getClick(), (Long)adxStatBaseDo.getExp(), (int)3);
        }
        return ret;
    }

    public static Double getStatLaunchPv(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if (AdxStatBaseDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division((Long)adxStatBaseDo.getAdvertLaunch(), (Long)adxStatBaseDo.getClick(), (int)3);
        }
        return ret;
    }

    public static Double getStatArpu(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if (AdxStatBaseDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division((Long)adxStatBaseDo.getAdvertConsume(), (Long)adxStatBaseDo.getAdvertLaunch(), (int)3);
        }
        return ret;
    }

    public static Double getStatCpm(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if (AdxStatBaseDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division((Double)adxStatBaseDo.getAdxConsume3(), (Long)adxStatBaseDo.getExp(), (int)3);
        }
        return ret;
    }

    public static Double getStatClickValue(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if (AdxStatBaseDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division((Long)adxStatBaseDo.getAdvertConsume(), (Long)adxStatBaseDo.getClick(), (int)3);
        }
        return ret;
    }

    public Long getBid() {
        return this.bid;
    }

    public Long getExp() {
        return this.exp;
    }

    public Long getClick() {
        return this.click;
    }

    public Long getAdxConsume() {
        return this.adxConsume;
    }

    public Long getAdvertConsume() {
        return this.advertConsume;
    }

    public Long getAdvertLaunch() {
        return this.advertLaunch;
    }

    public Long getAdvertClick() {
        return this.advertClick;
    }

    public void setBid(Long bid) {
        this.bid = bid;
    }

    public void setExp(Long exp) {
        this.exp = exp;
    }

    public void setClick(Long click) {
        this.click = click;
    }

    public void setAdxConsume(Long adxConsume) {
        this.adxConsume = adxConsume;
    }

    public void setAdvertConsume(Long advertConsume) {
        this.advertConsume = advertConsume;
    }

    public void setAdvertLaunch(Long advertLaunch) {
        this.advertLaunch = advertLaunch;
    }

    public void setAdvertClick(Long advertClick) {
        this.advertClick = advertClick;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdxStatBaseDo)) {
            return false;
        }
        AdxStatBaseDo other = (AdxStatBaseDo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$bid = this.getBid();
        Long other$bid = other.getBid();
        if (this$bid == null ? other$bid != null : !((Object)this$bid).equals(other$bid)) {
            return false;
        }
        Long this$exp = this.getExp();
        Long other$exp = other.getExp();
        if (this$exp == null ? other$exp != null : !((Object)this$exp).equals(other$exp)) {
            return false;
        }
        Long this$click = this.getClick();
        Long other$click = other.getClick();
        if (this$click == null ? other$click != null : !((Object)this$click).equals(other$click)) {
            return false;
        }
        Long this$adxConsume = this.getAdxConsume();
        Long other$adxConsume = other.getAdxConsume();
        if (this$adxConsume == null ? other$adxConsume != null : !((Object)this$adxConsume).equals(other$adxConsume)) {
            return false;
        }
        Long this$advertConsume = this.getAdvertConsume();
        Long other$advertConsume = other.getAdvertConsume();
        if (this$advertConsume == null ? other$advertConsume != null : !((Object)this$advertConsume).equals(other$advertConsume)) {
            return false;
        }
        Long this$advertLaunch = this.getAdvertLaunch();
        Long other$advertLaunch = other.getAdvertLaunch();
        if (this$advertLaunch == null ? other$advertLaunch != null : !((Object)this$advertLaunch).equals(other$advertLaunch)) {
            return false;
        }
        Long this$advertClick = this.getAdvertClick();
        Long other$advertClick = other.getAdvertClick();
        return !(this$advertClick == null ? other$advertClick != null : !((Object)this$advertClick).equals(other$advertClick));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdxStatBaseDo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $bid = this.getBid();
        result = result * 59 + ($bid == null ? 43 : ((Object)$bid).hashCode());
        Long $exp = this.getExp();
        result = result * 59 + ($exp == null ? 43 : ((Object)$exp).hashCode());
        Long $click = this.getClick();
        result = result * 59 + ($click == null ? 43 : ((Object)$click).hashCode());
        Long $adxConsume = this.getAdxConsume();
        result = result * 59 + ($adxConsume == null ? 43 : ((Object)$adxConsume).hashCode());
        Long $advertConsume = this.getAdvertConsume();
        result = result * 59 + ($advertConsume == null ? 43 : ((Object)$advertConsume).hashCode());
        Long $advertLaunch = this.getAdvertLaunch();
        result = result * 59 + ($advertLaunch == null ? 43 : ((Object)$advertLaunch).hashCode());
        Long $advertClick = this.getAdvertClick();
        result = result * 59 + ($advertClick == null ? 43 : ((Object)$advertClick).hashCode());
        return result;
    }

    public String toString() {
        return "AdxStatBaseDo(bid=" + this.getBid() + ", exp=" + this.getExp() + ", click=" + this.getClick() + ", adxConsume=" + this.getAdxConsume() + ", advertConsume=" + this.getAdvertConsume() + ", advertLaunch=" + this.getAdvertLaunch() + ", advertClick=" + this.getAdvertClick() + ")";
    }
}

