package cn.com.duiba.nezha.alg.alg.cpcautobidding;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import static cn.com.duiba.nezha.alg.alg.base.MathBase.getConfidenceWeight;

public class CpcNegTagFilter {


    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(CpcAutoBidding.class);

    static double[] costWeightBucket = {0, 5000, 10000, 20000, 50000,100000};
    static double[] costWeight = {0.0, 0.1, 0.2, 0.4, 0.6, 1.0};
    /**
     * 放弃概率生成接口，每两分钟调用一次
     *
     * @param cpcFilterInfo
     * @param lastGiveupFactor
     * @param cpcNegTagParams
     * @return
     */
    public static FilterResult cpcNegTagFilter(CpcFilterInfo cpcFilterInfo,
                                               Double lastGiveupFactor,
                                               CpcNegTagParams cpcNegTagParams) {

        FilterResult ret = new FilterResult();
        if (AssertUtil.isEmpty(cpcFilterInfo)) {
            return ret;
        }

        if (Math.random()<0.001) {
            logger.info("params cpcNegTagParams:{}", cpcNegTagParams);
        }

        //  计算消耗情况

        try {
            ret = costRatio(cpcFilterInfo);

        } catch (Exception e) {
            logger.warn("costRatio happend error,cpcFilterInfo={}", JSON.toJSONString(cpcFilterInfo), e);
        }


        //  放弃的概率更新
        if (lastGiveupFactor != null) {
            ret.setGiveupFactor(lastGiveupFactor);
        }

        updateFactor(ret,cpcNegTagParams);

        if (Math.random()<0.001) {
            logger.info("cpcNegTagFilter{}, GiveupFactor:{}", cpcFilterInfo.getOrientId(), ret.getGiveupFactor());
        }
        return ret;
    }




    public static FilterResult costRatio (CpcFilterInfo cpcFilterInfo){
        FilterResult ret = new FilterResult();

        Double costRatio = 1.0;
        //配置消耗
        Double orientCost = (double) cpcFilterInfo.costDay;
        Double orientCostLastDay = (double) cpcFilterInfo.costLastDay;
        Double orientCostHour = (double) cpcFilterInfo.costHour;
        Double orientCostLastHour = (double) cpcFilterInfo.costLastHour;

        //配置媒体消耗
        Double orientAppCost = (double) cpcFilterInfo.appCostDay;
        Double orientAppCostLastDay = (double) cpcFilterInfo.appCostLastDay;
        Double orientAppCostHour = (double) cpcFilterInfo.appCostHour;
        Double orientAppCostLastHour = (double) cpcFilterInfo.appCostLastHour;

        Double costConfWeight = getConfidenceWeight(orientCost, costWeightBucket, costWeight, 0.5);
        Double costDayRatio = orientCostLastDay != 0.0 ? orientCost/orientCostLastDay : (costConfWeight + 1.25);
        Double costHourRatio = orientCostLastHour != 0.0 ? orientCostHour/orientCostLastHour : 1.0;


        Double appCostConfWeight = getConfidenceWeight(orientAppCost, costWeightBucket, costWeight, 0.5);
        Double appCostDayRatio = orientAppCostLastDay != 0.0 ? orientAppCost/orientAppCostLastDay : (appCostConfWeight + 1.25);
        Double appCostHourRatio = orientAppCostLastHour != 0.0 ? orientAppCostHour/orientAppCostLastHour : 1.0;

        if (orientAppCost > 20000) {
            costRatio = 0.3 * costConfWeight * costDayRatio + 0.7 * appCostConfWeight * appCostDayRatio;
        } else {
            costRatio = costConfWeight * costDayRatio;
        }
        costRatio = Math.min(Math.max(0.1,costRatio),2);
        ret.setCostRatio(costRatio);

        return ret;
    }

    public static void  updateFactor(FilterResult filterResult,
                                     CpcNegTagParams cpcNegTagParams){
        Double ret = 0.5;

        Double totalLearnRate = cpcNegTagParams.totalLearnRate;//0.7

        Double giveUpLowerLimit = cpcNegTagParams.giveUpLowerLimit;//0.1;
        Double giveUpUpperLimit = cpcNegTagParams.giveUpUpperLimit;//0.8;
        Double ratioLimit = cpcNegTagParams.ratioLimit;


        if (filterResult == null) {
            return;
        }

        Double costRatio = filterResult.getCostRatio();

        Double giveUpFactor = filterResult.getGiveupFactor();
        if (giveUpFactor == null) {
            giveUpFactor = 0.6;
        }

        if (costRatio >= ratioLimit){

            ret = giveUpFactor * costRatio;
            ret = MathBase.noiseSmoother(ret, 0.6, giveUpUpperLimit);
        }

        if (costRatio < ratioLimit){

            ret = giveUpFactor * costRatio;
            ret = MathBase.noiseSmoother(ret, giveUpLowerLimit, 0.6);
        }

        ret = DataUtil.formatDouble(ret, 3);

        filterResult.setGiveupFactor(ret);


    }

    /**
     * 是否放弃的接口，每次竞价进行调用
     * @param filterResultMap
     * @param <T>
     * @return
     */

    public static <T> Map<T, Boolean> giveUpControl(Map<T, FilterResult> filterResultMap) {

        Map<T, Boolean> ret = new HashMap<>();
        if (AssertUtil.isAnyEmpty(filterResultMap)) {
            return ret;
        }
        for (Map.Entry<T, FilterResult> entry : filterResultMap.entrySet()) {
            T key = entry.getKey();
            FilterResult filterResult = entry.getValue();
            Double giveupFactor = filterResult.getGiveupFactor();
            Random r = new Random();
            Double x = r.nextDouble();
            Boolean giveUp = false;
            if (giveupFactor != null && x <= giveupFactor) {
                giveUp = true;
            }
            if (giveUp != null) {
                ret.put(key, giveUp);
            }
        }
        return ret;
    }

}