package cn.com.duiba.nezha.alg.alg.advertexploitbak;

import lombok.AllArgsConstructor;
import com.google.common.primitives.Longs;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class CandidateDto {

    /**
     * 广告ID
     */
    private Long advertId ;

    /**
     * 配置ID
     */
    private Long orientationId;

    /**
     * 分数
     */
    private Double score;


    public String getKey() {
        return this.advertId + "_" + this.orientationId;
    }
    //搞个方法传字符串既set好广告id也set好配置id
    public void setAdPkOnce(String adPk) {
        String[] adpkList=adPk.split("_");
        this.advertId= Longs.tryParse(adpkList[0]);
        this.orientationId=Longs.tryParse(adpkList[1]);
    }
}
