package cn.com.duiba.nezha.alg.alg.advertexploitbak;

import lombok.AllArgsConstructor;
import lombok.Data;

import java.util.Map;

@Data
@AllArgsConstructor
public class ExploitResult {

    /**
     * 利用配置列表
     */
    private Map<String, ResultDto> exploitMap;

    /**
     * 成本权重
     */
    private Double costWeight;

    /**
     * CPM权重
     */
    private Double cpmWeight;

    /**
     * 通道最大召回数量（成本因素）
     */
    private Map<MatcherEnum, MatcherWeightInfo> costMaxNumMap;

    /**
     * 通道最大召回数量（CPM因素）
     */
    private Map<MatcherEnum, MatcherWeightInfo> cpmMaxNumMap;

    /**
     * 通道实际召回数量
     */
    private Map<MatcherEnum, MatcherWeightInfo> matchNumMap;

}
