package cn.com.duiba.nezha.alg.alg.recall.data;

import cn.com.duiba.nezha.alg.alg.recall.enums.RecallerEnum;
import com.google.common.primitives.Longs;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

//召回接口最终输出的是这个东西的列表
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RecallResultDto {

    /**
     * 广告ID
     */
    private Long advertId ;

    /**
     * 配置ID
     */
    private Long orientationId;

    /**
     * 分数
     */
    private Map<Integer,Double> scoreMap;


    public String getKey() {
        return this.advertId + "_" + this.orientationId;
    }
    //搞个方法传字符串既set好广告id也set好配置id
    public void setAdPkOnce(String adPk) {
        String[] adpkList=adPk.split("_");
        this.advertId= Longs.tryParse(adpkList[0]);
        this.orientationId=Longs.tryParse(adpkList[1]);
    }
}
