package cn.com.duiba.nezha.alg.alg.vo.adx.directly2;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class ExploreFactor {

    /**
     * 资源位维度探索概率
     */
    Map<Long, AdxExpFactorDo> resFactor = new HashMap<>();

    Map<Long, AdxExpStatDo> ideaStatDo = new HashMap<>();


    public static AdxExpFactorDo getEFactor(ExploreFactor exploreFactor, Long resId) {
        AdxExpFactorDo ret = new AdxExpFactorDo();
        if(AssertUtil.isAnyEmpty(exploreFactor, resId)) {
            return ret;
        }
        if(exploreFactor != null && exploreFactor.getResFactor() != null) {
            ret = exploreFactor.getResFactor().getOrDefault(resId, ret);
        }

        return ret;
    }
    public static AdxExpStatDo getIdeaStat(ExploreFactor exploreFactor, Long ideaId) {
        AdxExpStatDo ret = new AdxExpStatDo();
        if(AssertUtil.isAnyEmpty(exploreFactor, ideaId)) {
            return ret;
        }
        if(exploreFactor.getIdeaStatDo() != null) {
            ret = exploreFactor.getIdeaStatDo().getOrDefault(ideaId, ret);
        }
        return ret;
    }

    public static Double getEFactor(ExploreFactor exploreFactor, Long resId, String appId) {

        Double ret = null;

        AdxExpFactorDo adxExpFactorDo = ExploreFactor.getEFactor(exploreFactor, resId);
        ret = adxExpFactorDo.getResFactor();

        if(AdxExpFactorDo.getAppFactor(adxExpFactorDo, appId) != null) {
            ret = AdxExpFactorDo.getAppFactor(adxExpFactorDo, appId);
        }

        return ret;
    }

    public static Double getIdeaStat(ExploreFactor exploreFactor, Long ideaId, String appId) {
        Double ret = null;


        AdxExpStatDo adxExpStatDo = ExploreFactor.getIdeaStat(exploreFactor, ideaId);
        ret = adxExpStatDo.getIdeaEcpm();

        if(AdxExpStatDo.getAppEcpm(adxExpStatDo, appId) != null) {
            ret = AdxExpStatDo.getAppEcpm(adxExpStatDo, appId);
        }

        return ret;
    }

    public void putResFactor(Long resId, AdxExpFactorDo adxExpFactorDo) {
        if(AssertUtil.isAllNotEmpty(resId, adxExpFactorDo)) {
            resFactor.put(resId, adxExpFactorDo);
        }

    }

    public void putIdeaStatDo(Long ideaId, AdxExpStatDo adxExpStatDo) {
        if(AssertUtil.isAllNotEmpty(ideaId, adxExpStatDo)) {
            ideaStatDo.put(ideaId, adxExpStatDo);
        }

    }





}
