package cn.com.duiba.nezha.alg.alg.vo.adx.rtb2;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class AdxFactorReqDo {

    /**
     * 创意统计数据
     * <创意ID,统计数据>
     */
    private Map<Long, AdxStatDo> ideaStatDos = new HashMap<>();

    /**
     * 资源位统计数据
     */
    private Map<Long, AdxStatDo> resStatDos = new HashMap<>();

    /**
     * 维稳对象
     */
    private AdxFactorDo adxFactorDo;

    /**
     * 创意设置数据
     * <在投资源位ID,<在投创意ID,创意设置数据>>
     */
    private Map<Long, Map<Long, AdxIdeaDo>> resIdeaDoMap;



    public AdxStatDo getStatDo(Long id, int type) {
        AdxStatDo ret = null;
        Map<Long, AdxStatDo> statDoMap = type == 0 ? ideaStatDos : resStatDos;

        if(id != null) {
            ret = statDoMap.get(id);
        }
        return ret;
    }


}
