/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.kaihu;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;

public class KaiHuConvertFilterAlg {
    public static int getFilterResult(Long advertId, Integer aFee, Integer convertType, Integer chargeType, Integer subType, Integer appTargetFee, Double roi) {
        int ret = 0;
        if (roi == null) {
            roi = 1.25;
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{aFee, convertType, chargeType, subType, appTargetFee})) {
            if (chargeType == 1) {
                return 1;
            }
            if (aFee > 1 && appTargetFee > 1 && convertType == subType) {
                double p = (double)aFee.intValue() / (0.01 + (double)appTargetFee.intValue() * roi);
                ret = KaiHuConvertFilterAlg.getRepeatTimes(p);
            }
        }
        if (ret > 3) {
            ret = 3;
        }
        return ret;
    }

    public static int getRepeatTimes(double p) {
        int ret = 0;
        int p1 = (int)Math.floor(p);
        ret += p1;
        double p2 = p - (double)p1;
        if (Math.random() < p2) {
            ++ret;
        }
        return ret;
    }

    public static void main(String[] args) {
        HashMap<Integer, Integer> retMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < 10000; ++i) {
            int ret = KaiHuConvertFilterAlg.getFilterResult(1L, 3000, 0, 2, 0, 2000, null);
            retMap.put(ret, 1 + retMap.getOrDefault(ret, 0));
        }
        System.out.println(JSON.toJSONString(retMap));
    }
}

