package cn.com.duiba.nezha.alg.alg.title;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.plugins.ResPlugInStatModel;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInStatDo;
import cn.com.duiba.nezha.alg.alg.vo.title.ActTitleRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.title.ActTitleStatDo;
import cn.com.duiba.nezha.alg.alg.vo.title.RecallActTitleDo;
import cn.com.duiba.nezha.alg.alg.vo.title.RecallActTitleInfoDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.parse.ActFeatureParse;
import cn.com.duiba.nezha.alg.feature.parse.ActTitleFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.ActFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.ActTitleFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActTitleDQNRcmder {

    private static final Logger logger = LoggerFactory.getLogger(ActTitleDQNRcmder.class);

    private static long ADX_MULTIPLIER = 10000000;

    private static int MAP_DF_SIZE = 8;


    /**
     * pcpm权重分配1 top1>0
     */
    static double[] pCpmBucket = {0.5, 0.8, 0.90, 0.95, 0.99, 1};
    static double[] pCpmWeight = {0.1, 1, 2, 2, 5, 100};

    /**
     * 特征解析
     *
     * @param
     * @return
     */
    public static Map<String, String> featureParse(ActTitleFeatureDo actFeatureDo) {
        //1 静态特征解析
        Map<String, String> staticFeatureMap = ActTitleFeatureParse.generateFeatureMapStatic(actFeatureDo);
        Map<String, String> dynamicFeatureMap = ActTitleFeatureParse.generateFeatureMapDynamic(actFeatureDo, actFeatureDo);
        dynamicFeatureMap.putAll(staticFeatureMap);
        return dynamicFeatureMap;
    }


    public static ActTitleRcmdDo rcmd2(CODER coderModel,
                                       LocalTFModel ltfModel,
                                       RecallActTitleDo recallActTitleDo,
                                       List<ActTitleStatDo> actTitleStatDoList,
                                       List<ActTitleStatDo> actSubTitleStatDoList,
                                       List<ActTitleStatDo> actSlotTitleStatDoList,
                                       List<ActTitleStatDo> actSlotSubTitleStatDoList,
                                       ActTitleFeatureDo actTitleFeatureDo,
                                       boolean hasSubTitle) throws Exception {
        ActTitleRcmdDo ret = null;


        if (valid(recallActTitleDo, actTitleFeatureDo)) {

            Map<String, Map<String, String>> featureMap = new HashMap<>();


            //0 推荐列表 ActTitleRcmdDo
            List<ActTitleRcmdDo> actTitleRcmdDoList = new ArrayList<>();

            //1 静态特征解析
            Map<String, String> staticFeatureMap = ActTitleFeatureParse.generateFeatureMapStatic(actTitleFeatureDo);

            //2 主标题统计数据转Map
            Map<Long, ActTitleStatDo> actSlotTitleStatDoMap = new HashMap<>();

            if (AssertUtil.isNotEmpty(actSlotTitleStatDoList)) {
                for (ActTitleStatDo actTitleStatDo : actSlotTitleStatDoList) {

                    if (actTitleStatDo != null) {
                        actSlotTitleStatDoMap.put(actTitleStatDo.getTitleId(), actTitleStatDo);
                    }
                }
            }

            //3 副标题统计数据转Map
            Map<Long, ActTitleStatDo> actSlotSubTitleStatDoMap = new HashMap<>();

            if (AssertUtil.isNotEmpty(actSlotSubTitleStatDoList)) {
                for (ActTitleStatDo actTitleStatDo : actSlotSubTitleStatDoList) {

                    if (actTitleStatDo != null) {
                        actSlotSubTitleStatDoMap.put(actTitleStatDo.getTitleId(), actTitleStatDo);
                    }
                }
            }


            //2 封装1 统计ROI、RPM
            for (RecallActTitleInfoDo recallActTitleInfoDo : recallActTitleDo.getRecallActTitleInfoDo()) {

                recallActTitleInfoDo.setKey();

                String key = recallActTitleInfoDo.getKey();
                Long activityTitleId = recallActTitleInfoDo.getActivityTitleId();
                Long activitySubTitleId = recallActTitleInfoDo.getActivitySubTitleId();

                ActTitleRcmdDo actTitleRcmdDo = new ActTitleRcmdDo();
                actTitleRcmdDo.setKey(key);

                actTitleRcmdDo.setActivityTitleId(activityTitleId);
                actTitleRcmdDo.setActivitySubTitleId(activitySubTitleId);

                // 封装 海选数据
                actTitleRcmdDo.setScore1(recallActTitleInfoDo.getScore1());
                actTitleRcmdDo.setRank1(recallActTitleInfoDo.getRank1());

                actTitleRcmdDo.setScore2(recallActTitleInfoDo.getScore2());
                actTitleRcmdDo.setRank2(recallActTitleInfoDo.getRank2());

                actTitleRcmdDo.setScore3(recallActTitleInfoDo.getScore3());
                actTitleRcmdDo.setRank3(recallActTitleInfoDo.getRank3());

                actTitleRcmdDo.setHasType(recallActTitleInfoDo.getHasType());

                // 封装主标题统计数据

                ActTitleStatDo actTitleStatDo = actSlotTitleStatDoMap.get(activityTitleId);

                actTitleRcmdDo.setsRpm(ActTitleStatModel.getRpm(actTitleStatDo));
                actTitleRcmdDo.setJpv(ActTitleStatModel.getJpv(actTitleStatDo));
                actTitleRcmdDo.setCpv(ActTitleStatModel.getCpv(actTitleStatDo));
                actTitleRcmdDo.setApv(ActTitleStatModel.getApv(actTitleStatDo));

                // 封装副标题统计数据

                ActTitleStatDo actTitleSubStatDo = actSlotTitleStatDoMap.get(activitySubTitleId);

                actTitleRcmdDo.setSubSRpm(ActTitleStatModel.getRpm(actTitleSubStatDo));
                actTitleRcmdDo.setSubJpv(ActTitleStatModel.getJpv(actTitleSubStatDo));
                actTitleRcmdDo.setSubCpv(ActTitleStatModel.getCpv(actTitleSubStatDo));
                actTitleRcmdDo.setSubApv(ActTitleStatModel.getApv(actTitleSubStatDo));

                actTitleRcmdDoList.add(actTitleRcmdDo);


                // 解析动态特征
                ActTitleFeatureDo dynamicDo = new ActTitleFeatureDo();

                dynamicDo.setActivityTitleId(recallActTitleInfoDo.getActivityTitleId()); //主标题ID.请求

                dynamicDo.setActivitySubTitleId(recallActTitleInfoDo.getActivitySubTitleId()); //副标题ID.请求

                dynamicDo.setActivityTitleTagId(recallActTitleInfoDo.getActivityTitleTagId()); //主标题标签ID.请求

                dynamicDo.setActivitySubTitleTagId(recallActTitleInfoDo.getActivitySubTitleTagId()); //副标题标签ID.请求

                dynamicDo.setActivityTitleName(recallActTitleInfoDo.getActivityTitleName()); //主标题名称.请求

                dynamicDo.setActivitySubTitleName(recallActTitleInfoDo.getActivitySubTitleName()); //副标题名称.请求


                Map<String, String> dynamicFeatureMap = ActTitleFeatureParse.generateFeatureMapDynamic(dynamicDo, actTitleFeatureDo);
                dynamicFeatureMap.putAll(staticFeatureMap);

                // 封装特征
                featureMap.put(key, dynamicFeatureMap);

            }

            //3 模型预估RPM
            Map<String, Double> pRpmMap = new HashMap<>();

            if (validModel(coderModel, ltfModel)) {
                pRpmMap = coderModel.predictWithLocalTF(featureMap, ltfModel);
            }
//            System.out.println(JSON.toJSONString(pRpmMap));


            //4 封装2 预估RPM 最排序分计算
            for (ActTitleRcmdDo actTitleRcmdDo : actTitleRcmdDoList) {

                String key = actTitleRcmdDo.getKey();

                Double pRpm = pRpmMap.get(key);

                actTitleRcmdDo.setpRpm(pRpm);

                // 融合RPM
                Double mergeRpm = getMergeRpm(actTitleRcmdDo);

                actTitleRcmdDo.setMergeRpm(mergeRpm);

                actTitleRcmdDo.setFeatureMap(featureMap.get(key));

            }

            //5 推荐 最终排序分、 流量分配
            ret = rcmd(actTitleRcmdDoList);

        }

        return ret;
    }


    /**
     * @param rcmdList
     * @return
     */
    public static ActTitleRcmdDo rcmd(List<ActTitleRcmdDo> rcmdList) {


        ActTitleRcmdDo ret = null;


        if (AssertUtil.isEmpty(rcmdList)) {
            return ret;

        }
        long size = rcmdList.size();

        //1 获取最优RPM
        Double bestRpm = null;//最优
        String bestRpmKey = null;
        Double baseRpm = null;//不开启


        if (size == 1) {
            return rcmdList.get(0);
        }


        for (int i = 0; i < size; i++) {

            ActTitleRcmdDo plugDo = rcmdList.get(i);

            Double rpm = plugDo.getMergeRpm();
            if (rpm != null) {
                if (bestRpm == null || bestRpm < rpm) {
                    bestRpm = rpm;
                    bestRpmKey = plugDo.getKey();
                }
            }
        }


        //2 概率分配
        Map<ActTitleRcmdDo, Double> weightMap = new HashMap<>(MAP_DF_SIZE);

        Double weightSum = 0.0;

        for (int i = 0; i < size; i++) {

            ActTitleRcmdDo rcmdDo = rcmdList.get(i);


            Double rpm = rcmdDo.getMergeRpm();

            Double weight = getRpmWeight(rpm, bestRpm);


//            if (rcmdDo.getsRpm() == null || rcmdDo.getSubSRpm() == null) {
//                weight = MathBase.noiseSmoother(weight, 0.1, 10.0);
//            }
//
//            if (rcmdDo.getHasType() != null && !rcmdDo.getHasType()) {
//                if (rcmdDo.getIsNew() != null && rcmdDo.getIsNew().equals(1)) {
//                    weight = MathBase.noiseSmoother(weight, 0.1, 10.0);
//                }
//                if (rcmdDo.getSubIsNew() != null && rcmdDo.getSubIsNew().equals(1)) {
//                    weight = MathBase.noiseSmoother(weight, 0.1, 10.0);
//                }
//
//            }


            if (weight == null) {
                weight = 1.0;
            }

            weightSum += weight;
            weightMap.put(rcmdDo, weight);

        }


        for (Map.Entry<ActTitleRcmdDo, Double> entry : weightMap.entrySet()) {
            ActTitleRcmdDo rcmdDo = entry.getKey();
            Double weight = entry.getValue();

            // 权重调节
            if (bestRpmKey != null && bestRpmKey.equals(rcmdDo.getKey()) && weight < weightSum * 0.8) {

                Double weightOther = weightSum - weight;
                weight = weightOther * 0.8 / (1 - 0.8);
                weightSum = weightOther + weight;

                weightMap.put(rcmdDo,weight);
//              weight = MathBase.noiseSmoother(weight, weightSum * 0.85, weightSum * 0.90);
            }

        }


//        System.out.println("weightMap=" + JSON.toJSONString(weightMap));

        //3 挑选
        ret = Roulette.doubleMap(weightMap);

        //4 返回
        return ret;
    }


    /**
     * @param actTitleRcmdDo
     * @return
     */
    private static Double getMergeRpm(ActTitleRcmdDo actTitleRcmdDo) {

        Double ret = null;

        if (actTitleRcmdDo != null) {
//            Double actSRpm = actTitleRcmdDo.getsRpm();
//            Double actSubSRpm = actTitleRcmdDo.getSubSRpm();

            Double actSRpm = actTitleRcmdDo.getCpv();
            Double actSubSRpm = actTitleRcmdDo.getSubCpv();

            Double pRpm = actTitleRcmdDo.getpRpm();

            if (pRpm == null) {
                return ret;
            }

            ret = pRpm;

            if (actSRpm == null) {
                actSRpm = pRpm;
            }
            if (actSubSRpm == null) {
                actSubSRpm = actSRpm;
            }

            ret = 0.9 * pRpm + 0.05 * actSRpm + 0.05 * actSubSRpm;


        }

        return ret;
    }

    /**
     * @param rpm
     * @param bestRpm
     * @return
     */
    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;

        if (rpm != null && bestRpm != null) {

            Double ratio = DataUtil.division(rpm, bestRpm, 3);
            if (bestRpm >= 0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }

        }

        return ret;
    }


    /**
     * 推荐列表合法性校验
     *
     * @param recallActTitleDo
     * @param actFeatureDo
     * @return
     */
    private static Boolean valid(RecallActTitleDo recallActTitleDo,
                                 ActTitleFeatureDo actFeatureDo) {
        Boolean ret = true;

        if (AssertUtil.isAnyEmpty(recallActTitleDo, actFeatureDo)) {
            logger.error("ActTitleDQNRcmder.rcmd() input valid ,params plugList or adxFeatureDo is null");
            ret = false;
        }
        if (recallActTitleDo != null && AssertUtil.isEmpty(recallActTitleDo.getActivitySubTitleIdList())) {
            logger.error("ActTitleDQNRcmder.rcmd() input valid ,params plugList or adxFeatureDo is null");
            ret = false;
        }


        return ret;
    }


    /**
     * 模型合法性校验
     *
     * @param coderModel
     * @param ltfModel
     * @return
     */
    private static Boolean validModel(
            CODER coderModel,
            LocalTFModel ltfModel) {
        Boolean ret = true;

        if (ltfModel == null || coderModel == null) {
            logger.error("ActTitleDQNRcmder.rcmd() input valid ,params ltfModel is null or coder is null");
            ret = false;
        }

        return ret;
    }

}
