package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import lombok.Data;

@Data
public class AdxBidReq {

    /**
     * 分流标志: 0：原逻辑；1：实验组；2：对照组
     */
    private Integer groupTag;

    /**
     * 推广组ID
     */
    private Long groupId;

    /**
     * 资源位ID
     */
    private Long resId;

    /**
     * 创意计划ID
     */
    private Long ideaId;

    /**
     * 创意素材ID
     */
    private Long ideaUnitId;

    /**
     * app ID
     */
    private String appId;

    /**
     * 出价方式：1-roi出价、2-cpc出价
     */
    private Integer bidMode;

    /**
     * 创意设置的目标roi（百分比）
     */
    private Double roi;

    /**
     * 创意设置的目标cpc（元/单次点击）
     */
    private Double cpc;

    /**
     * 直投cpc（分/单次点击）
     */
    private Double directCpc;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 统计ctr
     */
    private Double statCtr;

    /**
     * 统计每pv发券
     */
    private Double statLaunchPv;

    /**
     * 预估每pv发券
     */
    private Double preLaunchPv;

    /**
     * 预估arpu
     */
    private Double preArpu;

    /**
     * 统计arpu
     */
    private Double statArpu;

    /**
     * 统计ecpm
     */
    private Double statEcpm;

    /**
     * 入口cpm
     */
    private Double cpm;

    /**
     * 维稳参数对象
     */
    private AdxFactorBaseDo adxFactorBaseDo;

    /**
     * 出价类型：0-人工、1-算法、2-直投
     */
    private Integer priceType;

    /**
     * pmpType类型：0-RTB，1-PD，2-PDB
     */
    private Integer pmpType;

    /**
     * 排期单价格(当pmpType=1/2时，有值)
     */
    private Long pmpPrice;

    private Double price;

    private boolean isConfidence;

    /**
     * slot ID：联盟广告位id
     */
    private String slotId;

    /**
     * 探价因子对象
     */
    private AdxExploreDo adxExploreDo;

    /**
     * 投放状态：1=正常投放，2=广告位探量投放，3=计划冷启动探价
     */
    private Integer exploreType;

    /**
     * 出价因子
     */
    private Double factor;

    /**
     * 底价/分
     */
    private Double basePrice;

    /**
     * 算法判断--计划创意来源池：true-冷启动池，false-优选池
     */
    private Boolean isNew;


}
