package cn.com.duiba.nezha.alg.api.facade.recall;

import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.enums.RecallEnums.RecallChannelType;
import org.apache.commons.collections.MapUtils;
import org.junit.Test;

import java.util.HashMap;
import java.util.Map;

public class MergeRecallChannelFacadeImpl implements MergeRecallChannelFacade {

    @Override
    public Map<String, Map<RecallChannelType, Double>> merge(Map<RecallChannelType, Map<String, RecallChannelResult>> param) {
        Map<String, Map<RecallChannelType, Double>> res = new HashMap<>();

        if (MapUtils.isEmpty(param)) {
            return res;
        }

        for (Map.Entry<RecallChannelType, Map<String, RecallChannelResult>> paramEntry: param.entrySet()) {
            RecallChannelType curChannel = paramEntry.getKey();
            Map<String, RecallChannelResult> curRecallRes = paramEntry.getValue();
            for (Map.Entry<String, RecallChannelResult> entry: curRecallRes.entrySet()) {
                String curKey = entry.getKey();
                Double score = entry.getValue().getScore();
                Map<RecallChannelType, Double> scoreMap = res.get(curKey);
                if (scoreMap == null) {
                    Map<RecallChannelType, Double> curRes = new HashMap<>();
                    curRes.put(curChannel, score);
                    res.put(curKey, curRes);
                } else {
                    scoreMap.put(curChannel, score);
                }
            }
        }

       return res;
    }

    @Test
    public void test1() {
        Map<RecallChannelType, Map<String, RecallChannelResult>> param = new HashMap<>();

        RecallChannelType channel1 = RecallChannelType.Heat;
        RecallChannelType channel2 = RecallChannelType.IndustryGeneral;
        RecallChannelType channel9 = RecallChannelType.Random;

        // 热度
        RecallChannelResult rcr1 = new RecallChannelResult();
        Map<String, RecallChannelResult> heatRecallRes = new HashMap<>();
        rcr1.setIndex("cvr0");
        rcr1.setAdvertId(123L);
        rcr1.setPackageId(999L);
        rcr1.setScore(0.90);
        heatRecallRes.put(rcr1.buildKey(), rcr1);

        RecallChannelResult rcr2 = new RecallChannelResult();
        rcr2.setIndex("weighted0");
        rcr2.setAdvertId(456L);
        rcr2.setPackageId(888L);
        rcr2.setScore(0.60);
        heatRecallRes.put(rcr2.buildKey(), rcr2);
        param.put(channel1, heatRecallRes);

        // 广告行业泛化
        RecallChannelResult rcr3 = new RecallChannelResult();
        Map<String, RecallChannelResult> geneRecallRes = new HashMap<>();
        rcr3.setIndex("cvr0");
        rcr3.setAdvertId(123L);
        rcr3.setPackageId(999L);
        rcr3.setScore(0.70);
        geneRecallRes.put(rcr3.buildKey(), rcr3);

        RecallChannelResult rcr4 = new RecallChannelResult();
        rcr4.setIndex("weighted0");
        rcr4.setAdvertId(456L);
        rcr4.setPackageId(888L);
        rcr4.setScore(0.80);
        geneRecallRes.put(rcr4.buildKey(), rcr4);
        param.put(channel2, geneRecallRes);

        // 随机
        Map<String, RecallChannelResult> randomRecallRes = new HashMap<>();
        RecallChannelResult rcr5 = new RecallChannelResult();
        rcr5.setIndex("cvr0");
        rcr5.setAdvertId(123L);
        rcr5.setPackageId(999L);
        rcr5.setScore(0.44);
        randomRecallRes.put(rcr5.buildKey(), rcr5);
        param.put(channel9, randomRecallRes);

        MergeRecallChannelFacadeImpl curMerge = new MergeRecallChannelFacadeImpl();
        Map<String, Map<RecallChannelType, Double>> k = curMerge.merge(param);
        System.out.println("res: " + k);
    }

}
