package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.rtbbid2.AdxConstant;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.*;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class AdxBid {

    private static final Logger logger = LoggerFactory.getLogger(AdxBid.class);

    public static AdxBidRet bid(AdxBidReq adxBidReq) {

        AdxBidRet ret = new AdxBidRet();

        try{
            if(!valid(adxBidReq) || (adxBidReq.getPriceType() != null && adxBidReq.getPriceType() == 2)) {
                printBidReq(adxBidReq);
            }

            //流量参数
            Integer bidMode = adxBidReq.getBidMode();
            int priceType = Optional.ofNullable(adxBidReq.getPriceType()).orElse(1);
            Integer pmpType = adxBidReq.getPmpType();

            //维稳参数对象
            AdxFactorBaseDo factorBaseDo = Optional.ofNullable(adxBidReq.getAdxFactorBaseDo()).orElse(new AdxFactorBaseDo());    //不同的分组ID对应不同的维稳参数对象
            double factor = factorBaseDo.getFactor();
            Double cpm = factorBaseDo.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(AdxConstant.DEFAULT_CPM);

            //创意参数
            Double preCtr = adxBidReq.getPreCtr();
            Double statCtr = Optional.ofNullable(adxBidReq.getStatCtr()).orElse(factorBaseDo.getStatCtr());
            Double ctr = MathUtil.mean(preCtr, statCtr, 0.9);
            ctr = Optional.ofNullable(ctr).orElse(AdxConstant.DEFAULT_CTR);

            Double preLaunchPv = adxBidReq.getPreLaunchPv();
            Double statLaunchPv = Optional.ofNullable(adxBidReq.getStatLaunchPv()).orElse(factorBaseDo.getLaunchPv());;
            Double launchPv = MathUtil.mean(preLaunchPv, statLaunchPv, 0.7);
            launchPv = Optional.ofNullable(launchPv).orElse(AdxConstant.DEFAULT_LAUNCHPV);

            Double preArpu = adxBidReq.getPreArpu();
            Double arpuRectifyFactor = Optional.ofNullable(adxBidReq.getArpuRectifyFactor()).orElse(1.0);
            Double preArpu2 = preArpu == null ? null : (preArpu * arpuRectifyFactor);
            Double arpu = Optional.ofNullable(adxBidReq.getStatArpu()).orElse(factorBaseDo.getArpu());
            Double mixArpu = MathUtil.mean(preArpu2, arpu, 0.7);
            mixArpu = Optional.ofNullable(mixArpu).orElse(AdxConstant.DEFAULT_ARPU);
            arpu = Optional.ofNullable(arpu).orElse(AdxConstant.DEFAULT_ARPU);


            Double cpc = priceType == 1 ? adxBidReq.getCpc() : adxBidReq.getDirectCpc();
            Double roi = MathUtil.division(adxBidReq.getRoi(), 100L, 3);

            Integer expTag = adxBidReq.getAdxExploreDo().getExpTag();
            boolean expSwitch = adxBidReq.getAdxExploreDo().isExpSwitch();
            if (expTag == null) {
                expTag = 99;
            }

            // 如果是探价流量，则根据比例随机选择探价分桶，实验桶的比例固定为全局流量的2%
            if (expTag >= 2 && !expSwitch) {
                getPriceExploreFactor(adxBidReq, ret);
            }

            Double price;
            Integer groupTag = adxBidReq.getGroupTag();
            if (groupTag == null) { groupTag = 0;}
            //pmpType类型：0-RTB，1-PD，2-PDB
            if (pmpType != null && pmpType == 2) {
                price = adxBidReq.getPrice();

            } else if(priceType == 1) {    //互动出价
                price = bidMode == 1 ?
                        getRoiPrice(ctr, factor, launchPv, arpu, mixArpu, roi, expTag, ret.getPriceFactor(), expSwitch, groupTag) :
                        getCpcPrice(ctr, cpc, factor, expTag, ret.getPriceFactor(), expSwitch);
            }else if (priceType == 2) {
                price = getDirectPrice(ctr, cpc, factor, roi, expTag, ret.getPriceFactor(), expSwitch);  //直投出价
            }else {
                price = adxBidReq.getPrice();
            }

            if (expTag >= 1 && Math.random() <= 0.005) {
                logger.info("priceExploreExpTag{} ,level{}, price{}, appId{}, slotId{}, priceType{}, bidMode{}", expTag, ret.getLevel(), price, adxBidReq.getAppId(), adxBidReq.getSlotId(), priceType, bidMode);
            }


            price = Math.min(price, 50 * cpm);
            Double rankScore = getRankScore(price, adxBidReq.getStatEcpm(), adxBidReq.isConfidence());


            ret.setAdxAlgoPrice(Math.round(price));
            ret.setArpu(arpu);
            ret.setMixArpu(mixArpu);
            ret.setPreArpu(preArpu);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setFactor(factor);
            ret.setIdeaId(adxBidReq.getIdeaId());
            ret.setIdeaUnitId(adxBidReq.getIdeaUnitId());
            ret.setRankScore(rankScore);
        }catch (Exception e) {
            logger.error("AdxBid.bid error", e);
        }
        return ret;
    }


    public static AdxBidRet getBid(AdxBidReq adxBidReq) {

        AdxBidRet ret = new AdxBidRet();

        try {

            if (!valid(adxBidReq) || (adxBidReq.getPriceType() != null && adxBidReq.getPriceType() == 2)) {
                printBidReq(adxBidReq);
            }

            //流量参数
            Integer bidMode = adxBidReq.getBidMode();
            int priceType = Optional.ofNullable(adxBidReq.getPriceType()).orElse(1);
            Integer pmpType = adxBidReq.getPmpType();
            Integer groupTag = adxBidReq.getGroupTag();

            //维稳参数对象
            double factor = adxBidReq.getFactor();

            //入口ctr
            Double preCtr = adxBidReq.getPreCtr();
            Double statCtr = adxBidReq.getStatCtr();
            Double ctr = MathUtil.mean(preCtr, statCtr, 0.9);
            ctr = Optional.ofNullable(ctr).orElse(AdxConstant.DEFAULT_CTR);
            //每pv发券
            Double preLaunchPv = adxBidReq.getPreLaunchPv();
            Double statLaunchPv = adxBidReq.getStatLaunchPv();
            Double launchPv = MathUtil.mean(preLaunchPv, statLaunchPv, 0.7);
            launchPv = Optional.ofNullable(launchPv).orElse(AdxConstant.DEFAULT_LAUNCHPV);
            //券arpu
            Double preArpu = adxBidReq.getPreArpu();
            Double arpuRectifyFactor = Optional.ofNullable(adxBidReq.getArpuRectifyFactor()).orElse(1.0);
            Double preArpu2 = preArpu == null ? null : (preArpu * arpuRectifyFactor);
            Double statArpu = adxBidReq.getStatArpu();
            Double arpu = statArpu;
            if (groupTag == null) { groupTag = 0;}
            if (groupTag == 1) { arpu = MathUtil.mean(preArpu2, statArpu, 0.7); }
            arpu = Optional.ofNullable(arpu).orElse(AdxConstant.DEFAULT_ARPU);
            //计划cpc，roi
            Double cpc = priceType == 1 ? adxBidReq.getCpc() : adxBidReq.getDirectCpc();
            Double roi = MathUtil.division(adxBidReq.getRoi(), 100L, 3);

            //出价（pmpType类型：0-RTB，1-PD，2-PDB）
            Double price;
            if (pmpType != null && pmpType == 2) {
                price = adxBidReq.getPrice();
            } else if (priceType == 1) {    //互动出价
                price = bidMode == 1 ?
                        getRoiPrice(ctr, launchPv, arpu, roi, factor) :
                        getCpcPrice(ctr, cpc, factor);
            } else if (priceType == 2) {
                price = getDirectPrice(ctr, cpc, roi, factor);  //直投出价
            } else {
                price = adxBidReq.getPrice();
            }


            Double cpm = adxBidReq.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(AdxConstant.DEFAULT_CPM);
            price = Math.min(price, 50 * cpm);
            Double rankScore = getRankScore2(price, adxBidReq.getStatEcpm(), adxBidReq.isConfidence());

            ret.setAdxAlgoPrice(Math.round(price));
            ret.setRankScore(rankScore);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setMixArpu(arpu);
            ret.setArpu(statArpu);
            ret.setPreArpu(preArpu);
            ret.setFactor(factor);

            ret.setExploreType(adxBidReq.getExploreType());
            ret.setBasePrice(adxBidReq.getBasePrice());
            ret.setIdeaId(adxBidReq.getIdeaId());
            ret.setIdeaUnitId(adxBidReq.getIdeaUnitId());
            ret.setIsNew(adxBidReq.getIsNew());
            ret.setIsColdStart(adxBidReq.getIsColdStart());

        } catch (Exception e) {
            logger.error("AdxBid.bid error", e);
        }
        return ret;
    }

    public static List<AdxBidReq> buildAdxBidReq(AdIdeaDo adIdeaDo, AdxFactorBaseDo factorBaseDo, AdxAppReqDo adxAppReqDo) {

        List<AdxBidReq> adxBidReqs = new ArrayList<>();
        List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos();

        for(IdeaUnitDo ideaUnitDo : ideaUnitDos) {
            AdxBidReq adxBidReq = new AdxBidReq();
            adxBidReq.setAdxFactorBaseDo(factorBaseDo);
            BeanUtils.copy(adxAppReqDo, adxBidReq);
            BeanUtils.copy(adIdeaDo, adxBidReq);
            BeanUtils.copy(ideaUnitDo, adxBidReq);
            adxBidReq.setArpuRectifyFactor(adxAppReqDo.getArpuRectifyFactor());

            //pmpType类型：0-RTB，1-PD，2-PDB
            if(adxAppReqDo != null && adxAppReqDo.getPmpType() != null) {
                adxBidReq.setPmpType(adxAppReqDo.getPmpType());
                if(adxAppReqDo.getPmpType() != 0) {
                    adxBidReq.setPrice(DataUtil.toDouble(adxAppReqDo.getPmpPrice()));
                }
            }

            if(ideaUnitDo.getAdxStatsDo() != null) {
                AdxStatsDo adxStatsDo = ideaUnitDo.getAdxStatsDo();
                AdxIndexStatDo adxIndexStatDo = adxStatsDo.getLast1DayStat();
                adxBidReq.setStatCtr(AdxIndexStatDo.getStatCtr(adxIndexStatDo));
                adxBidReq.setStatLaunchPv(AdxIndexStatDo.getStatLaunchPv(adxIndexStatDo));
                adxBidReq.setStatArpu(AdxIndexStatDo.getStatArpu(adxIndexStatDo));
                adxBidReq.setStatEcpm(AdxIndexStatDo.getStatEcpm(adxIndexStatDo));
                adxBidReq.setConfidence(AdxIndexStatDo.isCostConfidence(adxIndexStatDo));
            }


            adxBidReqs.add(adxBidReq);
        }

        return adxBidReqs;

    }



    public static List<AdxBidReq> buildAdxBidReq(AdIdeaDo adIdeaDo, AdxFactorDo adxFactorDo, AdxAppReqDo adxAppReqDo) {

        List<AdxBidReq> adxBidReqs = new ArrayList<>();
        List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos();

        AdxBidReq tmpBidReq = new AdxBidReq();
        getFactorDo(tmpBidReq, adIdeaDo, adxFactorDo, adxAppReqDo);

        for (IdeaUnitDo ideaUnitDo : ideaUnitDos) {
            AdxBidReq adxBidReq = new AdxBidReq();
            BeanUtils.copy(tmpBidReq, adxBidReq);
            adxBidReq.setIdeaUnitId(ideaUnitDo.getIdeaUnitId());
            adxBidReq.setIsNew(ideaUnitDo.getIsNew());

            adxBidReq.setPreCtr(ideaUnitDo.getPreCtr());
            adxBidReq.setPreLaunchPv(ideaUnitDo.getPreLaunchPv());
            adxBidReq.setPreArpu(ideaUnitDo.getPreArpu());

            //pmpType类型：0-RTB，1-PD，2-PDB
            if(adxAppReqDo != null && adxAppReqDo.getPmpType() != null) {
                adxBidReq.setPmpType(adxAppReqDo.getPmpType());
                if(adxAppReqDo.getPmpType() != 0) {
                    adxBidReq.setPrice(DataUtil.toDouble(adxAppReqDo.getPmpPrice()));
                }
            }

            if (ideaUnitDo.getAdxStatsDo() != null) {
                AdxStatsDo ideaUnitStatsDo = ideaUnitDo.getAdxStatsDo();
                AdxIndexStatDo indexStatDo = ideaUnitStatsDo.getLast1DayStat();
                adxBidReq.setStatCtr(AdxRcmdBase.getStatCtr(indexStatDo, tmpBidReq.getStatCtr()));
                adxBidReq.setStatLaunchPv(AdxRcmdBase.getStatPvLaunch(indexStatDo, tmpBidReq.getStatLaunchPv()));
                adxBidReq.setStatArpu(AdxRcmdBase.getStatArpu(indexStatDo, tmpBidReq.getStatArpu()));
                adxBidReq.setStatEcpm(AdxRcmdBase.getStatEcpm(indexStatDo, tmpBidReq.getStatEcpm()));
                adxBidReq.setConfidence(AdxRcmdBase.isConfident(indexStatDo));
            }

            adxBidReqs.add(adxBidReq);
        }

        return adxBidReqs;
    }


    public static void getFactorDo(AdxBidReq ret, AdIdeaDo adIdeaDo, AdxFactorDo adxFactorDo, AdxAppReqDo adxAppReqDo) {

        double factor = 1.0;
        Integer exploreType = 1;//投放状态：1=正常投放，2=广告位探量投放，3=计划冷启动探价

        AdxFactorBaseDo adFactorBaseDo = Optional.ofNullable(adxFactorDo.getAdFactorBaseDo()).orElse(new AdxFactorBaseDo());
        AdxFactorBaseDo tradeFactorBaseDo = Optional.ofNullable(adxFactorDo.getTradeFactorBaseDo()).orElse(new AdxFactorBaseDo());
        AdxFactorBaseDo appFactorBaseDo = Optional.ofNullable(adxFactorDo.getAppFactorBaseDo()).orElse(new AdxFactorBaseDo());

        factor = adFactorBaseDo.getFactor();
        if (appFactorBaseDo.conf) {
            factor = appFactorBaseDo.getFactor();
        } else if (tradeFactorBaseDo.conf) {
            factor = tradeFactorBaseDo.getFactor();
        }

        SlotFactorDo slotFactorDo = Optional.ofNullable(adxFactorDo.getSlotFactorDo()).orElse(new SlotFactorDo());
        boolean isSlotExplore = slotFactorDo.isExplore();
        double flowRatio = slotFactorDo.getFlowRatio();
        double slotFactor = slotFactorDo.getFactor();

        Boolean isColdStart = adIdeaDo.getIsColdStart();
        ColdStartFactorDo coldStartFactorDo = Optional.ofNullable(adxFactorDo.getColdStartFactorDo()).orElse(new ColdStartFactorDo());
        boolean isAdColdExplore = coldStartFactorDo.isExplore();
        double adColdFactor = coldStartFactorDo.getFactor();

        double random = Math.random();
        if (isSlotExplore && random < flowRatio) {
            factor = Math.max(slotFactor, factor);
            exploreType = 2;

        } else if (isColdStart != null && isColdStart && isAdColdExplore) {
            factor = Math.max(adColdFactor, factor);
            exploreType = 3;
        }


        //获取统计指标
        ret.setStatCtr(adFactorBaseDo.getStatCtr());
        ret.setStatLaunchPv(adFactorBaseDo.getLaunchPv());
        ret.setStatArpu(adFactorBaseDo.getArpu());
        ret.setStatEcpm(adFactorBaseDo.getStatEcpm());
        ret.setCpm(adFactorBaseDo.getCpm());
        if (appFactorBaseDo.dataConf) {
            ret.setStatCtr(appFactorBaseDo.getStatCtr());
            ret.setStatLaunchPv(appFactorBaseDo.getLaunchPv());
            ret.setStatArpu(appFactorBaseDo.getArpu());
            ret.setStatEcpm(appFactorBaseDo.getStatEcpm());
            ret.setCpm(appFactorBaseDo.getCpm());
        } else if (tradeFactorBaseDo.dataConf) {
            ret.setStatCtr(tradeFactorBaseDo.getStatCtr());
            ret.setStatLaunchPv(tradeFactorBaseDo.getLaunchPv());
            ret.setStatArpu(tradeFactorBaseDo.getArpu());
            ret.setStatEcpm(tradeFactorBaseDo.getStatEcpm());
            ret.setCpm(tradeFactorBaseDo.getCpm());
        }

        ret.setFactor(factor);
        ret.setExploreType(exploreType);
        ret.setIsColdStart(isColdStart);

        ret.setIdeaId(adIdeaDo.getIdeaId());
        ret.setBidMode(adIdeaDo.getBidMode());
        ret.setRoi(adIdeaDo.getRoi());
        ret.setCpc(adIdeaDo.getCpc());
        ret.setDirectCpc(adIdeaDo.getDirectCpc());
        ret.setPriceType(adIdeaDo.getPriceType());

        ret.setAppId(adxAppReqDo.getAppId());
        ret.setSlotId(adxAppReqDo.getSlotId());
        ret.setPmpType(adxAppReqDo.getPmpType());
        ret.setPmpPrice(adxAppReqDo.getPmpPrice());
        ret.setBasePrice(adxAppReqDo.getBasePrice());
        ret.setGroupTag(adxAppReqDo.getGroupTag());
        ret.setArpuRectifyFactor(adxAppReqDo.getArpuRectifyFactor());

    }



    public static void getPriceExploreFactor(AdxBidReq adxBidReq, AdxBidRet ret) {
        Integer expTag = adxBidReq.getAdxExploreDo().getExpTag();
        Double exploreFlowRate = adxBidReq.getAdxExploreDo().getExploreFlowRate();
        if (exploreFlowRate == null) {
            SamplerLog.info("priceExploreExpTag{} ,exploreFlowRate is null", adxBidReq.getAdxExploreDo().getExpTag());
            exploreFlowRate = 0.1;
        }
        double expRate = 0.02 / exploreFlowRate; // 实验桶流量比例
        double baseRate = Math.max(1.0 - 5 * expRate, 0.0); // 基准桶流量比例
        double rand = adxBidReq.getAdxExploreDo().getRandomFactor();
        double priceFactor;
        Map<String, Double> rateMap = new LinkedHashMap<>();

        if (expTag == 2) {
            // 利润优先的探价策略，根据比例随机选择探价分桶，实验桶的比例固定为全局流量的2%
            int start = priceExploreLevelEnum.profitLevelStart.getIndex();
            int end = priceExploreLevelEnum.profitLevelEnd.getIndex();
            for (int i=start; i <= end; i++) {
                rateMap.put(i+"", start == i ? baseRate : expRate);
            }
            String level = doubleMap(rateMap, rand);
            assert level != null;
            double defaultValue = level.equals(start+"") ? 2.0 : 2.0 + (Integer.parseInt(level)-(end+start+1)/2.0) * 0.5;
            priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault(level, defaultValue);
            ret.setPriceFactor(priceFactor);
            ret.setLevel(level);
        }
        else {
            // 消耗优先的探价策略，根据比例随机选择探价分桶，实验桶的比例固定为全局流量的2%
            int start = priceExploreLevelEnum.consumeLevelStart.getIndex();
            int end = priceExploreLevelEnum.consumeLevelEnd.getIndex();
            for (int i=start; i <= end; i++) {
                rateMap.put(i+"", start == i ? baseRate : expRate);
            }
            String level = doubleMap(rateMap, rand);
            assert level != null;
            double defaultValue = level.equals(start+"") ? 2.0 : 2.0 + (Integer.parseInt(level)-(end+start+1)/2.0) * 0.5;
            priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault(level, defaultValue);
            ret.setPriceFactor(priceFactor);
            ret.setLevel(level);

        }
        if (Math.random() < 0.01) {
            logger.info("priceExploreExpTag{} ,level{}, priceFactor{}, exploreFlowRate{}, appId{}, slotId{}, factorExploreMap{}, rand{}",
                    adxBidReq.getAdxExploreDo().getExpTag(), ret.getLevel(), priceFactor, exploreFlowRate, adxBidReq.getAppId(),
                    adxBidReq.getSlotId(), adxBidReq.getAdxExploreDo().getFactorExploreMap(), rand);
        }
    }

    public static String doubleMap(Map<String, Double> map, double rand) {

        // 参数检验
        if (AssertUtil.isEmpty(map)) {
            logger.warn("priceExploreExp mapSample param is invalid, params invalid");
            return null;
        }

        double w = 0.0;
        try {
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                w += entry.getValue();
                if (rand <= w) {
                    return entry.getKey();
                }
            }
        } catch (Exception e) {
            logger.error("priceExploreExp mapSample happened error: ", e);

        }
        return null;
    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag >= 2 && !expSwitch) {
            return ctr * cpc * exploreFactor * 1000 * 100;
        }
        else {
            return ctr * cpc * factor * 1000 * 100;
        }
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, double factor, Double roi, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag >= 2 && !expSwitch) {
            return DataUtil.division(ctr * algoCpcPrice * exploreFactor * 1000, roi, 3);
        }
        else {
            return DataUtil.division(ctr * algoCpcPrice * factor * 1000, roi, 3);
        }
    }

    public static Double getRoiPrice(Double ctr, double factor, Double launchPv, Double arpu, Double mixArpu, Double roi, Integer expTag, double exploreFactor, boolean expSwitch, Integer groupTag) {
        if (expTag >= 2 && !expSwitch) {
            if (groupTag == 1){
                return ctr * launchPv * mixArpu * exploreFactor / roi * 1000;
            } else {
                return ctr * launchPv * arpu * exploreFactor / roi * 1000;
            }
        }
        else {
            if (groupTag == 1){
                return ctr * launchPv * mixArpu * factor / roi * 1000;
            } else {
                return ctr * launchPv * arpu * factor / roi * 1000;
            }
        }
    }

    public static Double getRoiPrice(Double ctr,  Double launchPv, Double arpu, Double roi, double factor) {
        return ctr * launchPv * arpu * factor * 1000 / roi;
    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor) {
        return ctr * cpc * factor * 1000 * 100;
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, Double roi, double factor) {
        return ctr * algoCpcPrice * factor * 1000 / roi;
    }

    public static boolean valid(AdxBidReq adxBidReq) {
        boolean ret = true;

        if(AssertUtil.isAnyEmpty(adxBidReq, adxBidReq.getPreCtr(), adxBidReq.getPriceType())) {
            return false;
        }
        if(adxBidReq.getPriceType() == 1) {
            if (adxBidReq.getBidMode() == null) {
                return false;
            }else if(adxBidReq.getBidMode() == 1) {
                ret = adxBidReq.getRoi() != null && adxBidReq.getPreLaunchPv() != null;
            }else {
                ret = adxBidReq.getCpc() == null ? false : true;
            }
        }else if(adxBidReq.getPriceType() == 2) {
            ret = adxBidReq.getDirectCpc() != null && adxBidReq.getRoi() != null;
        }

        return ret;

    }

    public static void printBidReq(AdxBidReq adxBidReq) {

        if(Math.random() < 0.1) {
            logger.info("bidRequestDo2 is not valid, groupId:{}, resourceId:{}, ideaId:{}, appId:{}, priceType:{}, bidMode:{}, preCtr:{}, roi:{}, preLaunchPv:{}, cpc:{}, directCpc:{}",
                     adxBidReq.getGroupId(), adxBidReq.getResId(), adxBidReq.getIdeaId(), adxBidReq.getAppId(), adxBidReq.getPriceType(), adxBidReq.getBidMode(), adxBidReq.getPreCtr(), adxBidReq.getRoi()
                    , adxBidReq.getPreLaunchPv(), adxBidReq.getCpc(), adxBidReq.getDirectCpc());
        }

    }

    public static Double getRankScore(Double price, Double statEcpm, boolean isConfidence){
        Double rankScore;
        rankScore = (!isConfidence  ? price * (1 + 2 * Math.random()) : price);
        rankScore = MathUtil.mean(rankScore, statEcpm, 0.7);
        return rankScore;
    }

    public static Double getRankScore2(Double price, Double statEcpm, boolean isConfidence){
        Double rankScore;
        rankScore = (!isConfidence ? price * (1 + 1 * Math.random()) : price);
        rankScore = MathUtil.mean(rankScore, statEcpm, 0.7);
        return rankScore;
    }

}
