package cn.com.duiba.nezha.alg.alg.recall;


import cn.com.duiba.nezha.alg.alg.recall.data.AdInputDto;
import cn.com.duiba.nezha.alg.alg.recall.enums.RecallerEnum;
import cn.com.duiba.nezha.alg.alg.recall.filter.VectorFilter;
import cn.com.duiba.nezha.alg.alg.recall.params.FilterParam;
import lombok.extern.slf4j.Slf4j;

import java.util.*;

//这个类用来给各个召回器分配召回池
//要到处try保证别一个池子没分配好直接全gg了
@Slf4j
public class RecallerPool {
    public static Map<RecallerEnum,List<AdInputDto>> allocation(List<AdInputDto> allAdInput, FilterParam filterParam) {
        Map<RecallerEnum,List<AdInputDto>> recallPoolMap=new HashMap<RecallerEnum,List<AdInputDto>>();

        List<AdInputDto> vectorRecallPool=new ArrayList<>();
        try {
            vectorRecallPool = VectorFilter.filter(allAdInput, filterParam);
        } catch (Exception e) {
            log.error("allocation",e);
        }
        recallPoolMap.put(RecallerEnum.DSSM,vectorRecallPool);
        return recallPoolMap;
    }

    public static void main(String[] args) {
        String pkStr="73672_178993,71121_173168,65521_176061,68810_178437,49829_178811,73041_177565,"+
                "67320_177930,67320_178039,68837_178357,62556_177938,67320_179069,72917_177183,73524_0,72764_177427,68810_177405," +
                "68810_178808,67320_178976,72260_178946,73639_0,73526_0,73363_0,72917_177492,68810_173191,68810_175292,72093_177812";
        List<String> strList= Arrays.asList(pkStr.split(","));
        List<AdInputDto> adInputDtos=new ArrayList<>();
        for (String s : strList) {
            AdInputDto ad=new AdInputDto();
            ad.setAdPkOnce(s);
            ad.setReleaseTarget(Math.random()>0.5?1:3);
            adInputDtos.add(ad);
        }
        FilterParam f=new FilterParam();
        Map<RecallerEnum,List<AdInputDto>> result=allocation(adInputDtos,f);
        System.out.println(result);
    }
}
