package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class AdxExploreDo {
    /**
     * 探价因子表({分组：小数})
     * 初始化：{"1": 1.5, "2": 1.0, "3": 1.5, "4": 2.0, "5": 2.5, "6": 3.0}
     */
    private Map<String, Double> factorExploreMap = new HashMap<>();

    /**
     * 探价策略流量比例，初始化：0.1
     */
    private Double exploreFlowRate;

    /**
     * AB实验分流字段，只针对命中探价白名单的媒体
     * 原逻辑：0，对照组：1，实验组：2
     */
    private Integer expTag;

    /**
     * 空跑开关，默认为false，当为true时，实验组与对照组逻辑一致
     */
    private boolean expSwitch = false;

    /**
     * 针对每条adx请求生成的随机数
     */
    private double randomFactor;
}
