package cn.com.duiba.nezha.alg.api.facade.recall.channel;

import cn.com.duiba.nezha.alg.api.dto.recall.*;
import cn.com.duiba.nezha.alg.api.enums.RecallEnums.RecallChannelType;
import cn.com.duiba.nezha.alg.api.facade.recall.AbstractRecallChanelFacade;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * 协同过滤召回
 * @author lijicong
 * @since 2021-09-07
 */
public class CollabFilterRecallChannelFacadeImpl extends AbstractRecallChanelFacade<CollabFilterAdvertDTO, CollabFilterRequest>
        implements CollabFilterRecallChannelFacade {

    static Logger logger = LoggerFactory.getLogger(CollabFilterRecallChannelFacadeImpl.class);

    private static class Constance {
        private static final String prefix = "NZ_A12";
    }

    @Override
    public RecallChannelType getType() {
        return RecallChannelType.collFilter;
    }

    /**
     * 生成协同过滤召回的结果
     * @param collabFilterAdvertDTOMap 哪吒配置列表
     * @param collabFilterRequest redis中的根据统计模型生成的数据
     * @return 协同过滤召回的结果
     */
    @Override
    public Map<String, RecallChannelResult> execute(Map<String, CollabFilterAdvertDTO> collabFilterAdvertDTOMap,
                                                    CollabFilterRequest collabFilterRequest) {

        Map<String, RecallChannelResult> res = new HashMap<>();

        if (AssertUtil.isAnyEmpty(collabFilterAdvertDTOMap, collabFilterRequest)) {
            return res;
        }

        // todo 具体召回逻辑补充在该处
        return res;
    }


}
