package cn.com.duiba.nezha.alg.api.facade;

import cn.com.duiba.nezha.alg.api.dto.base.BaseAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.base.BaseRequestDTO;
import cn.com.duiba.nezha.alg.api.dto.base.BaseResult;
import cn.com.duiba.nezha.alg.common.util.TypeKit;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author lijicong
 * @since 2021-08-18
 */
@Slf4j
public abstract class AbstractTemplateFacade<Advert extends BaseAdvertDTO, Request extends BaseRequestDTO, Result extends BaseResult> //
        implements TemplateFacade<Advert, Request, Result> {

    /**
     * 实例化泛型真实类型Result
     * @return
     */
    protected Result newResult() {
        return TypeKit.newActualInstance(getClass(), 2);
    }

    protected Result newResult(Advert advert) {
        Result result = TypeKit.newActualInstance(getClass(), 2);
        result.setAdvertId(advert.getAdvertId());
        result.setPackageId(advert.getPackageId());
        return result;
    }

    @Override
    public List<Result> execute(List<Advert> adverts, Request request) {
        if (CollectionUtils.isEmpty(adverts)) {
            return Collections.emptyList();
        }
        return adverts.stream().map(advert -> doExecute(advert, request)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Map<String, Result> execute(Map<String, Advert> adverts, Request request) {
        if (MapUtils.isEmpty(adverts)) {
            return Collections.emptyMap();
        }
        return adverts.values().stream().map(advert -> {
            Result result = doExecute(advert, request);
            if (result != null) {
                if (result.getAdvertId() == null) {
                    result.setAdvertId(advert.getAdvertId());
                }
                if (result.getPackageId() == null) {
                    result.setPackageId(advert.getPackageId());
                }
            }
            return result;
        }).filter(Objects::nonNull).collect(Collectors.toMap(BaseResult::buildKey, e -> e, (o, n) -> n));
    }

    @Override
    public Result execute(Advert advert, Request request) {
        try {
            return doExecute(advert, request);
        } catch (Exception e) {
            log.warn("模板接口方法异常 advert={}, request={}", JSON.toJSONString(advert), JSON.toJSONString(request), e);
        }
        return null;
    }

    protected Result doExecute(Advert advert, Request request) {
        return null;
    }

    protected Map<String, Result> transformAdverts(Map<String, Advert> adverts) {
        if (MapUtils.isEmpty(adverts)) {
            return Collections.emptyMap();
        }
        return adverts.values().stream().filter(Objects::nonNull).map(advert -> {
            Result result = newResult();
            result.setAdvertId(advert.getAdvertId());
            result.setPackageId(advert.getPackageId());
            return result;
        }).collect(Collectors.toMap(BaseResult::buildKey, e -> e, (o, n) -> n));
    }
}
