/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlFactors;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepBidControl {
    private static final Logger log = LoggerFactory.getLogger(DeepBidControl.class);

    public static DeepControlFactors calculateNormal(Long deepFee, Long aFee, Double preDcvr, Double confWeight, Double preMergeWeight, Double statFactor) {
        DeepControlFactors retDto = new DeepControlFactors();
        Double ret = statFactor;
        Double preFactor = 1.18 * (double)deepFee.longValue() * preDcvr / (double)aFee.longValue();
        if (preDcvr < 1.0E-8) {
            preMergeWeight = 0.0;
        }
        preFactor = MathUtil.stdwithBoundary((double)preFactor, (double)0.1, (double)1.8);
        Double conFactor = confWeight * preMergeWeight * preFactor + (1.0 - confWeight * preMergeWeight) * statFactor;
        Double goodFactor = preMergeWeight > 0.1 ? 1.08 : 1.0;
        ret = preFactor < 1.0 ? statFactor : (preFactor > 1.6 ? Double.valueOf(Math.max(goodFactor * conFactor, statFactor)) : Double.valueOf(Math.max(conFactor, statFactor)));
        ret = MathUtil.formatDouble((double)MathUtil.stdwithBoundary((double)ret, (double)0.5, (double)1.8), (int)5);
        preFactor = MathUtil.formatDouble((double)preFactor, (int)5);
        retDto.setDeepFactor(ret);
        retDto.setPreDeepFactor(preFactor);
        retDto.setStatDeepFactor(statFactor);
        return retDto;
    }

    public static DeepControlFactors calculateHighCost(Long deepFee, Long aFee, Double preDcvr, Double confWeight, Double preMergeWeight, Double statFactor) {
        DeepControlFactors retDto = new DeepControlFactors();
        Double ret = statFactor;
        Double preFactor = 1.18 * (double)deepFee.longValue() * preDcvr / (double)aFee.longValue();
        if (preDcvr < 1.0E-8) {
            preMergeWeight = 0.0;
        }
        preFactor = MathUtil.stdwithBoundary((double)preFactor, (double)0.1, (double)1.8);
        Double conFactor = confWeight * preMergeWeight * preFactor + (1.0 - confWeight * preMergeWeight) * statFactor;
        Double goodFactor = preMergeWeight > 0.1 ? 1.08 : 1.0;
        ret = preFactor < 0.8 ? conFactor : (preFactor < 1.0 ? statFactor : (preFactor > 1.6 ? Double.valueOf(Math.max(goodFactor * conFactor, statFactor)) : Double.valueOf(Math.max(conFactor, statFactor))));
        ret = MathUtil.formatDouble((double)MathUtil.stdwithBoundary((double)ret, (double)0.5, (double)1.8), (int)5);
        preFactor = MathUtil.formatDouble((double)preFactor, (int)5);
        retDto.setDeepFactor(ret);
        retDto.setPreDeepFactor(preFactor);
        retDto.setStatDeepFactor(statFactor);
        log.info("Get double fee factor with high cost method." + retDto.toString());
        return retDto;
    }

    public static DeepControlFactors calculateFeedback(Long deepFee, Long aFee, Double preDcvr, Double confWeight, Double preMergeWeight, Double statFactor, Double preDiscountUpperBound, Double extraRiseLowerBound) {
        DeepControlFactors retDto = new DeepControlFactors();
        Double ret = statFactor;
        Double preFactor = 1.18 * (double)deepFee.longValue() * preDcvr / (double)aFee.longValue();
        if (preDcvr < 1.0E-8) {
            preMergeWeight = 0.0;
        }
        preFactor = MathUtil.stdwithBoundary((double)preFactor, (double)0.1, (double)1.8);
        Double conFactor = confWeight * preMergeWeight * preFactor + (1.0 - confWeight * preMergeWeight) * statFactor;
        Double goodFactor = preMergeWeight > 0.1 ? 1.08 : 1.0;
        ret = preFactor < preDiscountUpperBound ? conFactor : (preFactor < 1.0 ? statFactor : (preFactor < extraRiseLowerBound ? Double.valueOf(Math.max(conFactor, statFactor)) : Double.valueOf(Math.max(goodFactor * conFactor, statFactor))));
        ret = MathUtil.formatDouble((double)MathUtil.stdwithBoundary((double)ret, (double)0.5, (double)1.8), (int)5);
        preFactor = MathUtil.formatDouble((double)preFactor, (int)5);
        retDto.setDeepFactor(ret);
        retDto.setPreDeepFactor(preFactor);
        retDto.setStatDeepFactor(statFactor);
        if (Math.random() < 1.0E-4) {
            log.info("Get double fee factor with feedback method." + retDto.toString());
        }
        return retDto;
    }
}

