package cn.com.duiba.nezha.alg.alg.vo.kaihu;

import lombok.Data;

@Data
public class RoiControlParams {

    /**
     * 开户媒体roi控制参数
     */
    private Boolean cConf; //维稳置信

    private Double rFactor = 1.0; //roi调节因子

    private String updateTime; //更新时间

    private Boolean afeeConf; //afee调节置信

    private Double afeeFactor = 1.0; //afee调节因子


    /**
     * 获取roi调节因子
     *
     * @param params
     * @return
     */
    public static Double getRoiFactor(RoiControlParams params) {

        Double ret = null;

        if (params != null) {

            if (params.getCConf() != null && params.getCConf()) {
                if(params.getRFactor() == null){
                    params.setRFactor(1.0);
                }
                ret = params.getRFactor();
            }
        }

        return ret;
    }

    /**
     * 获取afee调节因子
     *
     * @param params
     * @return
     */
    public static Double getAfeeFactor(RoiControlParams params) {

        Double ret = null;

        if (params != null) {

            if (params.getAfeeConf() != null && params.getAfeeConf()) {
                if(params.getAfeeFactor() == null){
                    params.setAfeeFactor(1.0);
                }
                ret = params.getAfeeFactor();
            }
        }

        return ret;
    }

}
