/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rta;

import cn.com.duiba.nezha.alg.alg.vo.adx.rta.AccountIdDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rta.RtaBidRet;
import cn.com.duiba.nezha.alg.api.model.E2ELocalTFModel;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.RtaFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.RtaFeatureDo;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtaAlgoService {
    private static final Logger logger = LoggerFactory.getLogger(RtaAlgoService.class);

    public static Map<Long, Map<String, String>> getFeatureMap(RtaFeatureDo rtaFeatureDo, List<Long> accountList) {
        HashMap<Long, Map<String, String>> featureMap = new HashMap<Long, Map<String, String>>();
        Map staticFeatureMap = RtaFeatureParse.generateFeatureMapStatic((RtaFeatureDo)rtaFeatureDo);
        Long accountId = 1L;
        featureMap.put(accountId, staticFeatureMap);
        return featureMap;
    }

    public static Map<Long, Double> predict(Map<Long, Map<String, String>> featureMap, E2ELocalTFModel model, List<Long> accountList) {
        HashMap<Long, Double> ret = new HashMap<Long, Double>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{featureMap, model})) {
            logger.warn("RtaAlgoService.predict params is not valid featureMap:{}", (Object)JSON.toJSONString(featureMap));
            return ret;
        }
        Map result = model.predict(featureMap);
        Double score = result.getOrDefault(1L, 1.0);
        for (long account : accountList) {
            ret.put(account, score);
        }
        if (Math.random() <= 0.01) {
            logger.info("RtaAlgoService.predict score{}", (Object)JSON.toJSONString((Object)result));
        }
        if (Math.random() <= 1.0E-4) {
            logger.info("RtaAlgoService.predict featureMap{}", (Object)JSON.toJSONString(featureMap));
        }
        return ret;
    }

    public static List<RtaBidRet> bidding(List<AccountIdDo> accountIdDos, Integer groupTag) {
        List<RtaBidRet> rtaBidRets = new ArrayList<RtaBidRet>();
        try {
            rtaBidRets = accountIdDos.stream().map(accountIdDo -> {
                Long accountId = accountIdDo.getAccountId();
                Double factor = accountIdDo.getFactor();
                Double rtaScore = accountIdDo.getRtaScore();
                RtaBidRet ret = new RtaBidRet();
                ret.setAccountId(accountId);
                ret.setFactor(factor);
                ret.setRtaScore(rtaScore);
                Double bidRatio = Math.min(1.0 * rtaScore, 5.0);
                ret.setBidRatio(bidRatio);
                return ret;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("RtaAlgoService.bidding error", (Throwable)e);
        }
        return rtaBidRets;
    }
}

