/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlFactors;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepBidControl {
    private static final Logger log = LoggerFactory.getLogger(DeepBidControl.class);
    static Double targetCost = 1.0;

    public static DeepControlFactors calculateNormal(Long deepFee, Long aFee, Double preDcvr, Double confWeight, Double preMergeWeight, Double statFactor, Double preMergeDiffU, Double preMergeDiffL) {
        DeepControlFactors retDto = new DeepControlFactors();
        Double ret = statFactor;
        Double preFactor = targetCost * (double)deepFee.longValue() * preDcvr / (double)aFee.longValue();
        if (preDcvr < 1.0E-8) {
            preMergeWeight = 0.0;
        }
        preFactor = MathUtil.stdwithBoundary((double)preFactor, (double)0.1, (double)1.8);
        Double conFactor = confWeight * preMergeWeight * preFactor + (1.0 - confWeight * preMergeWeight) * statFactor;
        ret = MathUtil.formatDouble((double)MathUtil.stdwithBoundary((double)conFactor, (double)(preMergeDiffL * statFactor), (double)(preMergeDiffU * statFactor)), (int)5);
        preFactor = MathUtil.formatDouble((double)preFactor, (int)5);
        retDto.setDeepFactor(ret);
        retDto.setPreDeepFactor(preFactor);
        retDto.setStatDeepFactor(statFactor);
        return retDto;
    }

    public static DeepControlFactors getDeepFactor(OcpxControlParams costParams, DeepControlParams params, AdBidParamsDo adBidParamsDo) {
        Integer appLimitReleaseMark = adBidParamsDo.getAppLimitReleaseMark();
        Long deepFee = adBidParamsDo.getDeepFee();
        Long aFee = adBidParamsDo.getAFee();
        Long appAFee = adBidParamsDo.getAppAFee();
        Long usefulAfee = aFee;
        if (appAFee != null && appAFee > 0L) {
            usefulAfee = appAFee;
        }
        Double preDcvr = adBidParamsDo.getPreDcvr();
        DeepControlFactors retDto = new DeepControlFactors();
        Double ret = null;
        if (params == null || params.getDeepFactor() == null) {
            return retDto;
        }
        ret = params.getDeepFactor();
        Double statFactor = params.getDeepFactor();
        if (appLimitReleaseMark != null && appLimitReleaseMark.equals(1) && params.getLimitDeepFactor() != null) {
            ret = params.getLimitDeepFactor();
            statFactor = params.getLimitDeepFactor();
        }
        retDto.setDeepFactor(ret);
        retDto.setStatDeepFactor(statFactor);
        Long controlType = params.getControlType();
        Double confWeight = params.getConfWeight();
        Double preMergeWeight = params.getPreMergeWeight();
        Double preMergeDiffU = params.getPreMergeDiffU();
        Double preMergeDiffL = params.getPreMergeDiffL();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{confWeight, controlType, preDcvr, deepFee, usefulAfee, preMergeWeight, preMergeDiffU, preMergeDiffL, statFactor})) {
            retDto = DeepBidControl.calculateNormal(deepFee, usefulAfee, preDcvr, confWeight, preMergeWeight, statFactor, preMergeDiffU, preMergeDiffL);
        }
        return retDto;
    }

    public static Boolean dcvrConstrain(DeepControlParams params, AdBidParamsDo adBidParamsDo) {
        Boolean result = false;
        return result;
    }

    public static void main(String[] args) {
        Boolean a = null;
        System.out.println(a == true);
    }
}

