/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rta;

import cn.com.duiba.nezha.alg.alg.vo.adx.rta.AccountIdDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rta.RtaBidRet;
import cn.com.duiba.nezha.alg.alg.vo.adx.rta.RtaRoiControlModel;
import cn.com.duiba.nezha.alg.alg.vo.adx.rta.RtaRoiControlParams;
import cn.com.duiba.nezha.alg.api.model.E2ELocalTFModel;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.parse.RtaFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.RtaFeatureDo;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtaAlgoService {
    private static final Logger logger = LoggerFactory.getLogger(RtaAlgoService.class);

    public static Map<Long, Map<String, String>> getFeatureMap(RtaFeatureDo rtaFeatureDo, List<Long> accountList) {
        HashMap<Long, Map<String, String>> featureMap = new HashMap<Long, Map<String, String>>();
        Map staticFeatureMap = RtaFeatureParse.generateFeatureMapStatic((RtaFeatureDo)rtaFeatureDo);
        Long accountId = 1L;
        featureMap.put(accountId, staticFeatureMap);
        return featureMap;
    }

    public static Map<Long, Double> predict(Map<Long, Map<String, String>> featureMap, E2ELocalTFModel model, List<Long> accountList) {
        HashMap<Long, Double> ret = new HashMap<Long, Double>();
        if (model.getBundle() == null || featureMap == null) {
            logger.error("RtaAlgoService.predict model or featureMap is null");
            return ret;
        }
        Map result = model.predict(featureMap);
        Double score = result.getOrDefault(1L, 1.0);
        for (long account : accountList) {
            ret.put(account, score);
        }
        if (Math.random() <= 0.01) {
            logger.info("RtaAlgoService.predict score{}", (Object)JSON.toJSONString((Object)result));
        }
        if (Math.random() <= 1.0E-4) {
            logger.info("RtaAlgoService.predict featureMap{}", (Object)JSON.toJSONString(featureMap));
        }
        return ret;
    }

    public static List<RtaBidRet> bidding(List<AccountIdDo> accountIdDos, Integer groupTag, RtaRoiControlModel roiControlModel) {
        List<RtaBidRet> rtaBidRets = new ArrayList<RtaBidRet>();
        try {
            rtaBidRets = accountIdDos.stream().map(accountIdDo -> {
                Long accountId = accountIdDo.getAccountId();
                Double factor = RtaAlgoService.getRoiFactor(accountId, roiControlModel);
                Double rtaScore = accountIdDo.getRtaScore();
                RtaBidRet ret = new RtaBidRet();
                ret.setAccountId(accountId);
                ret.setFactor(factor);
                ret.setRtaScore(rtaScore);
                Double bidRatio = MathUtil.stdwithBoundary((double)(1.0 * rtaScore), (double)0.5, (double)5.0);
                ret.setBidRatio(bidRatio);
                return ret;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("RtaAlgoService.bidding error", (Throwable)e);
        }
        return rtaBidRets;
    }

    public static Double getRoiFactor(Long accountId, RtaRoiControlModel roiControlModel) {
        Double factor = 1.0;
        RtaRoiControlParams roiControlParams = (roiControlModel = Optional.ofNullable(roiControlModel).orElse(new RtaRoiControlModel())).getRoiControlParams(accountId);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{roiControlParams, roiControlParams.getCConf()}) && roiControlParams.getCConf().booleanValue()) {
            factor = roiControlParams.getRFactor();
        }
        return factor;
    }
}

