package cn.com.duiba.nezha.alg.alg.advert.v2;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdFeeDo;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdExploreModel;
import cn.com.duiba.nezha.alg.alg.vo.ee.AppGroupDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import java.util.*;


@Slf4j
public class BidReCostStrategy {


    /**
     * 计费调节
     *
     * @param controlResultMap 出价返回对象
     * @return
     */
    public static void reCost(Map<String, AdBidResultDo> controlResultMap) {


        List<AdBidResultDo> adBidResultDoList = new ArrayList<>();

        for (Map.Entry<String, AdBidResultDo> entry : controlResultMap.entrySet()) {

            //排序分/ecpm更新
            scoreUpdate(entry.getValue());

            adBidResultDoList.add(entry.getValue());
        }

        Collections.sort(adBidResultDoList);


        int size = controlResultMap.size();


        for (int i = 0; i < size - 1; i++) {

            AdBidResultDo leftDo = adBidResultDoList.get(i);

            AdBidResultDo rightDo = adBidResultDoList.get(i + 1);

            reCost(leftDo, rightDo);
        }

        reCost(adBidResultDoList.get(size - 1), null);
    }


    /**
     * 出价调节
     *
     * @param top1 排序靠前
     * @param top2 排序靠后
     * @return
     */
    public static void reCost(AdBidResultDo top1, AdBidResultDo top2) {


        /**
         * 参数校验
         */
        // 非空处理
        if (AssertUtil.isEmpty(top1)) {
            return;
        }

        // ocpc广告生效
        if (top1.getChargeType() != 2) {
            return;
        }

        // 有调节参数
        AdBidParamsDo top1Params = top1.getAdBidParamsDo();
        if (AssertUtil.isEmpty(top1Params)) {
            return;
        }
        Boolean isCostProject = top1Params.getSecondPriceProject();
        Double costFactor = top1Params.getCFactor();

        //未开启计费保护 或者 无计费因子
        if (isCostProject == null || !isCostProject || costFactor == null) {

            top1Params.setCostFee(top1.getFee());
            return;
        }


        /**
         * 计费率计算
         */


        // 原出价
        long top1Fee = top1.getFee();

        long top2Fee = top2 != null ? top2.getFee() : 0;

        // ecpm
        Double top1Ecpm = top1.getEcpm();
        Double top2Ecpm = top2 != null ? top2.getEcpm() : top1.getEcpm();


        //突破二价的比例,仅1个广告竞价时，最低计费=ecmp1*0.5;多个广告竞价时，默认最低计费=ecpm2
        double secondRatio = top2 != null ? 1.0 : 0.5;


        //获取参数中的扣费率
        Double extraCFactor = top1Params.getExtraCFactor();
        Integer extraCSwitch = top1Params.getExtraCSwitch();
        if (top2 != null && extraCSwitch != null && extraCSwitch == 1 && extraCFactor != null) {
            secondRatio = extraCFactor;

            if (Math.random() < 0.001) {
                log.info("extraCFactor " + extraCFactor.toString() + " extraCSwitch" + extraCSwitch.toString() +
                        " advertId " + top1.getAdvertId() + " pkId " + top1.getPackageId());
            }
        }

        // 最低计费率
        double minCostFactor = (top2Ecpm * secondRatio) / top1Ecpm;


        // 实际计费率
        costFactor = Math.max(costFactor, minCostFactor);


        /**
         * 计费调节
         */
        long costFee = Math.round(top1.getFee() * costFactor);
        long feeNew = costFactor > 1.0 ? Math.max(top1Fee, costFee) : Math.min(top1Fee, costFee);


        /**
         * 信息更新
         */
        top1.setFee(feeNew);

        top1Params.setFee(feeNew);
        top1Params.setCostFee(feeNew);

        System.out.println("ad="+top1.getAdvertId()+",top1Fee=" + top1Fee + ",top2Fee=" + top2Fee + ",feeNew=" + feeNew);
    }


    /**
     * 一键继承
     *
     * @param adBidResultDo
     */
    public static void scoreUpdate(AdBidResultDo adBidResultDo) {
        Double score = adBidResultDo.getCtr() * adBidResultDo.getFee();
        adBidResultDo.setScore(score);
        adBidResultDo.setEcpm(score);


    }

}
