package cn.com.duiba.nezha.alg.alg.title;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.title.ActTitleRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.title.ActTitleStatDo;
import cn.com.duiba.nezha.alg.alg.vo.title.RecallActTitleDo;
import cn.com.duiba.nezha.alg.alg.vo.title.RecallActTitleInfoDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.ActTitleFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.ActTitleFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActTitlePrizeDQNRcmder {

    private static final Logger logger = LoggerFactory.getLogger(ActTitlePrizeDQNRcmder.class);

    private static long ADX_MULTIPLIER = 10000000;

    private static int MAP_DF_SIZE = 8;


    /**
     * pcpm权重分配1 top1>0
     */
    static double[] pCpmBucket = {0.5, 0.8, 0.90, 0.95, 0.98, 1};
    static double[] pCpmWeight = {0.1, 1, 2, 5, 10, 100};


    public static ActTitleRcmdDo rcmd2(CODER coderModel,
                                       LocalTFModel ltfModel,
                                       ActTitleRcmdDo actTitleRcmdDo,
                                       List<Long> subTitlePrizeList) throws Exception {
        ActTitleRcmdDo ret = null;


        if (valid(actTitleRcmdDo, subTitlePrizeList)) {

            Map<Long, Map<String, String>> featureMap = new HashMap<>();


            //0 推荐列表 ActTitleRcmdDo
            List<ActTitleRcmdDo> actTitleRcmdDoList = new ArrayList<>();

            //1 静态特征解析
            Map<String, String> staticFeatureMap = actTitleRcmdDo.getFeatureMap();


            //2 封装1 统计ROI、RPM
            for (Long subTitlePrizeId : subTitlePrizeList) {


                // 解析动态特征

                Map<String, String> dynamicFeatureMap = ActTitleFeatureParse.generateFeatureMapPrizeId(subTitlePrizeId);
                dynamicFeatureMap.putAll(staticFeatureMap);

                // 封装特征
                featureMap.put(subTitlePrizeId, dynamicFeatureMap);

            }

            //3 模型预估RPM
            Map<Long, Double> pRpmMap = new HashMap<>();

            if (validModel(coderModel, ltfModel)) {
                pRpmMap = coderModel.predictWithLocalTF(featureMap, ltfModel);
            }



            //4 封装2 预估RPM 推荐奖品
            Long bestPrizeId = rcmdPrizeId(pRpmMap);
            //5 推荐 最终排序分、 流量分配

            actTitleRcmdDo.setActivitySubTitlePrizeId(bestPrizeId);
            actTitleRcmdDo.setpPrizeRpm(pRpmMap.get(bestPrizeId));
//            actTitleRcmdDo.setFeatureMap(null);
            ret=actTitleRcmdDo;
        }

        return ret;
    }


    /**
     * 奖品推荐
     *
     * @param pRpmMap
     * @return
     */
    public static Long rcmdPrizeId(Map<Long, Double> pRpmMap) {


        Long ret = null;


        if (AssertUtil.isEmpty(pRpmMap)) {
            return ret;

        }

        long size = pRpmMap.size();

        //1 获取最优RPM
        Double bestRpm = null;//最优
        Long bestRpmKey = null;


        for (Map.Entry<Long, Double> entry : pRpmMap.entrySet()) {
            Long key = entry.getKey();
            Double rpm = entry.getValue();
            if (rpm != null) {
                if (bestRpm == null || bestRpm < rpm) {
                    bestRpm = rpm;
                    bestRpmKey = key;
                }
            }
        }


        //2 概率分配
        Map<Long, Double> weightMap = new HashMap<>(MAP_DF_SIZE);

        Double weightSum = 0.0;

        for (Map.Entry<Long, Double> entry : pRpmMap.entrySet()) {


            Long key = entry.getKey();
            Double rpm = entry.getValue();

            Double weight = getRpmWeight(rpm, bestRpm);

            if(rpm==null || weight==null){
                weight=1.0;
            }

            weightSum += weight;
            weightMap.put(key, weight);
        }


        for (Map.Entry<Long, Double> entry : weightMap.entrySet()) {
            Long key = entry.getKey();
            Double weight = entry.getValue();

            // 权重调节
            if (bestRpmKey != null && bestRpmKey.equals(key) && weight < weightSum * 0.8) {

                Double weightOther = weightSum - weight;
                weight = weightOther * 0.8 / (1 - 0.8);
                weightSum = weightOther + weight;

                weightMap.put(key,weight);



//              weight = MathBase.noiseSmoother(weight, weightSum * 0.85, weightSum * 0.90);
            }

        }


//        System.out.println("weightMap=" + JSON.toJSONString(weightMap));

        //3 挑选
        ret = Roulette.doubleMap(weightMap);

        //4 返回
        return ret;
    }


    /**
     * @param actTitleRcmdDo
     * @return
     */
    private static Double getMergeRpm(ActTitleRcmdDo actTitleRcmdDo) {

        Double ret = null;

        if (actTitleRcmdDo != null) {
//            Double actSRpm = actTitleRcmdDo.getsRpm();
//            Double actSubSRpm = actTitleRcmdDo.getSubSRpm();

            Double actSRpm = actTitleRcmdDo.getCpv();
            Double actSubSRpm = actTitleRcmdDo.getSubCpv();

            Double pRpm = actTitleRcmdDo.getpRpm();

            if (pRpm == null) {
                return ret;
            }

            ret = pRpm;

            if (actSRpm == null) {
                actSRpm = pRpm;
            }
            if (actSubSRpm == null) {
                actSubSRpm = actSRpm;
            }

            ret = 0.5 * pRpm + 0.3 * actSRpm + 0.2 * actSubSRpm;


        }

        return ret;
    }

    /**
     * @param rpm
     * @param bestRpm
     * @return
     */
    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;

        if (rpm != null && bestRpm != null) {

            Double ratio = DataUtil.division(rpm, bestRpm, 3);
            if (bestRpm >= 0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }

        }

        return ret;
    }


    /**
     * @param actTitleRcmdDo
     * @param subTitlePriceList
     * @return
     */
    private static Boolean valid(ActTitleRcmdDo actTitleRcmdDo,
                                 List<Long> subTitlePriceList) {
        Boolean ret = true;

        if (AssertUtil.isAnyEmpty(actTitleRcmdDo, subTitlePriceList)) {
            logger.error("ActTitlePrizeDQNRcmder.rcmd() input valid ,params actTitleRcmdDo, subTitlePriceListo is null");
            ret = false;
        }
        if (AssertUtil.isEmpty(actTitleRcmdDo.getFeatureMap())) {
            logger.error("ActTitlePrizeDQNRcmder.rcmd() input valid ,params featureMap  is null");
            ret = false;
        }


        return ret;
    }


    /**
     * 模型合法性校验
     *
     * @param coderModel
     * @param ltfModel
     * @return
     */
    private static Boolean validModel(
            CODER coderModel,
            LocalTFModel ltfModel) {
        Boolean ret = true;

        if (ltfModel == null || coderModel == null) {
            logger.error("ActTitlePrizeDQNRcmder.rcmd() input valid ,params ltfModel is null or coder is null");
            ret = false;
        }

        return ret;
    }

}
