package cn.com.duiba.nezha.alg.alg.vo.advertsupport;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class SupportParams {

    private List<Double> supportRatioBucket =  new ArrayList<>();
    private List<Double> supportRatioWeight = new ArrayList<>();

    private List<Double> rankRatioBucket =  new ArrayList<>();
    private List<Double> rankRatioWeight = new ArrayList<>();

    private Double costRatio = 1.25;

    private Long convs = 50L;
    private Long conv = 25L;
    private Double cons = 1.0;

    /**
     * 数据置信最小维度的点击数据的阈值
     */
    private Long minDimClickThresh = 3000L;

    /**
     * 使用修正后统计CVR的曝光阈值
     */
    private Long exposeThresh = 2000L;  //当统计CVR经修正投放的曝光量大于阈值后关闭CVR高倍系数提权

    /**
     * CVR异常判断系数
     */
    private Double cvrDisRatio = 0.1D;

    /**
     * 指数函数形状调整超参
     */
    private double hyperParam = 1.0;

}
