package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.rtbbid2.AdxConstant;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.*;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class AdxBid {

    private static final Logger logger = LoggerFactory.getLogger(AdxBid.class);

    public static AdxBidRet bid(AdxBidReq adxBidReq) {

        AdxBidRet ret = new AdxBidRet();

        try{
            if(!valid(adxBidReq) || (adxBidReq.getPriceType() != null && adxBidReq.getPriceType() == 2)) {
                printBidReq(adxBidReq);
            }

            //流量参数
            Integer bidMode = adxBidReq.getBidMode();
            int priceType = Optional.ofNullable(adxBidReq.getPriceType()).orElse(1);

            //维稳参数对象
            AdxFactorBaseDo factorBaseDo = Optional.ofNullable(adxBidReq.getAdxFactorBaseDo()).orElse(new AdxFactorBaseDo());    //不同的分组ID对应不同的维稳参数对象
            double factor = factorBaseDo.getFactor();
            Double cpm = factorBaseDo.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(AdxConstant.DEFAULT_CPM);

            //创意参数
            Double preCtr = adxBidReq.getPreCtr();
            Double statCtr = Optional.ofNullable(adxBidReq.getStatCtr()).orElse(factorBaseDo.getStatCtr());
            Double ctr = MathUtil.mean(preCtr, statCtr, 0.9);
            ctr = Optional.ofNullable(ctr).orElse(AdxConstant.DEFAULT_CTR);

            Double preLaunchPv = adxBidReq.getPreLaunchPv();
            Double statLaunchPv = Optional.ofNullable(adxBidReq.getStatLaunchPv()).orElse(factorBaseDo.getLaunchPv());;
            Double launchPv = MathUtil.mean(preLaunchPv, statLaunchPv, 0.7);
            launchPv = Optional.ofNullable(launchPv).orElse(AdxConstant.DEFAULT_LAUNCHPV);

            Double arpu = factorBaseDo.getArpu();
            arpu = Optional.ofNullable(arpu).orElse(AdxConstant.DEFAULT_ARPU);


            Double cpc = priceType == 1 ? adxBidReq.getCpc() : adxBidReq.getDirectCpc();
            Double roi = MathUtil.division(adxBidReq.getRoi(), 100L, 3);

            Integer expTag = adxBidReq.getAdxExploreDo().getExpTag();
            boolean expSwitch = adxBidReq.getAdxExploreDo().isExpSwitch();
            if (expTag == null) {
                expTag = 99;
            }

            // 如果是探价流量，则根据比例随机选择探价分桶，实验桶的比例固定为全局流量的2%
            if (expTag >= 2 && !expSwitch) {
                getPriceExploreFactor(adxBidReq, ret);
            }

            Double price;
            if(priceType == 1) {    //互动出价
                price = bidMode == 1 ?
                        getRoiPrice(ctr, factor, launchPv, arpu, roi, expTag, ret.getPriceFactor(), expSwitch) :
                        getCpcPrice(ctr, cpc, factor, expTag, ret.getPriceFactor(), expSwitch);
            }else if (priceType == 2) {
                price = getDirectPrice(ctr, cpc, factor, roi, expTag, ret.getPriceFactor(), expSwitch);  //直投出价
            }else {
                price = adxBidReq.getPrice();
            }

            if (expTag >= 1 && Math.random() <= 0.005) {
                logger.info("priceExploreExpTag{} ,level{}, price{}, appId{}, slotId{}, priceType{}, bidMode{}", expTag, ret.getLevel(), price, adxBidReq.getAppId(), adxBidReq.getSlotId(), priceType, bidMode);
            }


            price = Math.min(price, 50 * cpm);
            Double rankScore = getRankScore(price, adxBidReq.getStatEcpm(), adxBidReq.isConfidence());


            ret.setAdxAlgoPrice(Math.round(price));
            ret.setArpu(arpu);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setFactor(factor);
            ret.setIdeaId(adxBidReq.getIdeaId());
            ret.setIdeaUnitId(adxBidReq.getIdeaUnitId());
            ret.setRankScore(rankScore);
        }catch (Exception e) {
            logger.error("AdxBid.bid error", e);
        }
        return ret;
    }

    public static List<AdxBidReq> buildAdxBidReq(AdIdeaDo adIdeaDo, AdxFactorBaseDo factorBaseDo, AdxAppReqDo adxAppReqDo) {

        List<AdxBidReq> adxBidReqs = new ArrayList<>();
        List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos();

        for(IdeaUnitDo ideaUnitDo : ideaUnitDos) {
            AdxBidReq adxBidReq = new AdxBidReq();
            adxBidReq.setAdxFactorBaseDo(factorBaseDo);
            BeanUtils.copy(adxAppReqDo, adxBidReq);
            BeanUtils.copy(adIdeaDo, adxBidReq);
            BeanUtils.copy(ideaUnitDo, adxBidReq);

            if(ideaUnitDo.getAdxStatsDo() != null) {
                AdxStatsDo adxStatsDo = ideaUnitDo.getAdxStatsDo();
                AdxIndexStatDo adxIndexStatDo = adxStatsDo.getLast1DayStat();
                adxBidReq.setStatCtr(AdxIndexStatDo.getStatCtr(adxIndexStatDo));
                adxBidReq.setStatLaunchPv(AdxIndexStatDo.getStatLaunchPv(adxIndexStatDo));
                adxBidReq.setStatEcpm(AdxIndexStatDo.getStatEcpm(adxIndexStatDo));
                adxBidReq.setConfidence(AdxIndexStatDo.isCostConfidence(adxIndexStatDo));
            }


            adxBidReqs.add(adxBidReq);
        }

        return adxBidReqs;

    }

    public static void getPriceExploreFactor(AdxBidReq adxBidReq, AdxBidRet ret) {
        Integer expTag = adxBidReq.getAdxExploreDo().getExpTag();
        Double exploreFlowRate = adxBidReq.getAdxExploreDo().getExploreFlowRate();
        if (exploreFlowRate == null) {
            SamplerLog.info("priceExploreExpTag{} ,exploreFlowRate is null", adxBidReq.getAdxExploreDo().getExpTag());
            exploreFlowRate = 0.1;
        }
        double expRate = 0.02 / exploreFlowRate; // 实验桶流量比例
        double baseRate = Math.max(1.0 - 5 * expRate, 0.0); // 基准桶流量比例
        double rand = adxBidReq.getAdxExploreDo().getRandomFactor();
        double priceFactor;
        Map<String, Double> rateMap = new LinkedHashMap<>();

        if (expTag == 2) {
            // 利润优先的探价策略，根据比例随机选择探价分桶，实验桶的比例固定为全局流量的2%
            int start = priceExploreLevelEnum.profitLevelStart.getIndex();
            int end = priceExploreLevelEnum.profitLevelEnd.getIndex();
            for (int i=start; i <= end; i++) {
                rateMap.put(i+"", start == i ? baseRate : expRate);
            }
            String level = doubleMap(rateMap, rand);
            assert level != null;
            double defaultValue = level.equals(start+"") ? 2.0 : 2.0 + (Integer.parseInt(level)-(end+start+1)/2.0) * 0.5;
            priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault(level, defaultValue);
            ret.setPriceFactor(priceFactor);
            ret.setLevel(level);
        }
        else {
            // 消耗优先的探价策略，根据比例随机选择探价分桶，实验桶的比例固定为全局流量的2%
            int start = priceExploreLevelEnum.consumeLevelStart.getIndex();
            int end = priceExploreLevelEnum.consumeLevelEnd.getIndex();
            for (int i=start; i <= end; i++) {
                rateMap.put(i+"", start == i ? baseRate : expRate);
            }
            String level = doubleMap(rateMap, rand);
            assert level != null;
            double defaultValue = level.equals(start+"") ? 2.0 : 2.0 + (Integer.parseInt(level)-(end+start+1)/2.0) * 0.5;
            priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault(level, defaultValue);
            ret.setPriceFactor(priceFactor);
            ret.setLevel(level);

        }
        if (Math.random() < 0.01) {
            logger.info("priceExploreExpTag{} ,level{}, priceFactor{}, exploreFlowRate{}, appId{}, slotId{}, factorExploreMap{}, rand{}",
                    adxBidReq.getAdxExploreDo().getExpTag(), ret.getLevel(), priceFactor, exploreFlowRate, adxBidReq.getAppId(),
                    adxBidReq.getSlotId(), adxBidReq.getAdxExploreDo().getFactorExploreMap(), rand);
        }
    }

    public static String doubleMap(Map<String, Double> map, double rand) {

        // 参数检验
        if (AssertUtil.isEmpty(map)) {
            logger.warn("priceExploreExp mapSample param is invalid, params invalid");
            return null;
        }

        double w = 0.0;
        try {
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                w += entry.getValue();
                if (rand <= w) {
                    return entry.getKey();
                }
            }
        } catch (Exception e) {
            logger.error("priceExploreExp mapSample happened error: ", e);

        }
        return null;
    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag >= 2 && !expSwitch) {
            return ctr * cpc * exploreFactor * 1000 * 100;
        }
        else {
            return ctr * cpc * factor * 1000 * 100;
        }
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, double factor, Double roi, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag >= 2 && !expSwitch) {
            return DataUtil.division(ctr * algoCpcPrice * exploreFactor * 1000, roi, 3);
        }
        else {
            return DataUtil.division(ctr * algoCpcPrice * factor * 1000, roi, 3);
        }
    }

    public static Double getRoiPrice(Double ctr, double factor, Double launchPv, Double arpu, Double roi, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag >= 2 && !expSwitch) {
            return ctr * launchPv * arpu * exploreFactor / roi * 1000;
        }
        else {
            return ctr * launchPv * arpu * factor / roi * 1000;
        }
    }

    public static boolean valid(AdxBidReq adxBidReq) {
        boolean ret = true;

        if(AssertUtil.isAnyEmpty(adxBidReq, adxBidReq.getPreCtr(), adxBidReq.getPriceType())) {
            return false;
        }
        if(adxBidReq.getPriceType() == 1) {
            if (adxBidReq.getBidMode() == null) {
                return false;
            }else if(adxBidReq.getBidMode() == 1) {
                ret = adxBidReq.getRoi() != null && adxBidReq.getPreLaunchPv() != null;
            }else {
                ret = adxBidReq.getCpc() == null ? false : true;
            }
        }else if(adxBidReq.getPriceType() == 2) {
            ret = adxBidReq.getDirectCpc() != null && adxBidReq.getRoi() != null;
        }

        return ret;

    }

    public static void printBidReq(AdxBidReq adxBidReq) {

        if(Math.random() < 0.1) {
            logger.info("bidRequestDo2 is not valid, groupId:{}, resourceId:{}, ideaId:{}, appId:{}, priceType:{}, bidMode:{}, preCtr:{}, roi:{}, preLaunchPv:{}, cpc:{}, directCpc:{}",
                     adxBidReq.getGroupId(), adxBidReq.getResId(), adxBidReq.getIdeaId(), adxBidReq.getAppId(), adxBidReq.getPriceType(), adxBidReq.getBidMode(), adxBidReq.getPreCtr(), adxBidReq.getRoi()
                    , adxBidReq.getPreLaunchPv(), adxBidReq.getCpc(), adxBidReq.getDirectCpc());
        }

    }

    public static Double getRankScore(Double price, Double statEcpm, boolean isConfidence){
        Double rankScore;
        rankScore = (!isConfidence  ? price * (1 + 2 * Math.random()) : price);
        rankScore = MathUtil.mean(rankScore, statEcpm, 0.7);
        return rankScore;
    }
}
