package cn.com.duiba.nezha.alg.alg.vo.adx;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@Data
public class AdxDo implements Serializable{

    /**
     * 推广组ID
     */
    private Long groupId;

    /**
     * 资源位ID
     */
    private Long resourceId;

    /**
     * 创意ID
     */
    private Long ideaId;

    /**
     * 最低ROI(小数，如1.50)
     */
    private Double minRoi;

    /**
     * 模型CTR预估值
     */
    private Double preCtr ;

    /**
     * 统计CTR
     */
    private Double statCtr;

    /**
     * 统计点击价值(分/单次点击)
     */
    private Double statClickValue;

    /**
     * 预估点击价值(预发券，分/单次点击)
     * 注：算法set
     */
    private Double predClickValue;

    /**
     * 创意点击价值-预估(TF模型预估)
     */
    private Double tfPreClickValue;

    /**
     * 创意点击价值-预估(TF模型预估)-纠偏
     * 注：算法set
     */
    private Double recTfPreClickValue;

    /**
     * 统计CTR-资源维度
     */
    private Double statCtrResource;

    /**
     * 统计点击价值-资源维度(分/单次点击)
     */
    private Double statClickValueResource;

    /**
     * abtest分流标记（1：对比组；2：测试组）
     */
    Integer filterIndex;

    /**
     * 创意分filterIndex维度 统计数据--近1h（key：1对比组，2测试组1.0，3测试组2.0）
     */
    private Map<Integer, AdxIndexStatDo> filterIndexHourStats;

    /**
     * 创意分filterIndex维度 统计数据--当天（key：1对比组，2测试组1.0，3测试组2.0）
     */
    private Map<Integer, AdxIndexStatDo> filterIndexDayStats;

    /**
     * 创意统计数据
     */
    private AdxStatsDo ideaStats;

    /**
     * 目标cpc(分/单次点击)
     */
    private Double targetCpc;

    /**
     * 算法出价模式(1-按roi出价, 2-按cpc出价)
     */
    private Integer algoBidMode;

    /**
     * 预发券开关：0=关，1=开
     */
    private Integer preLaunchSwitch;

    /**
     * 百度appId分媒体调价实验-分组id
     */
    private Integer groupTag;

    /**
     * 创意+百度appId 统计ctr
     */
    private Double ideaAppStatCtr;

    /**
     * 创意+百度appId 统计点击价值
     */
    private Double ideaAppStatCva;

    /**
     * 资源位+百度appId 统计ctr
     */
    private Double resoAppStatCtr;

    /**
     * 资源位+百度appId 统计点击价值
     */
    private Double resoAppStatCva;

    /**
     * 策略分组+创意+百度appId 统计数据
     */
    private AdxStatsDo ideaAppStats;

    /**
     * 用户当日竞价次数
     */
    private Integer imeiBidCnt;

    /**
     * 竞价次数阈值，只有当用户竞价次数小于该值时，算法才会加价抢量
     */
    private Integer bidCntThreshold;

    /**
     * 用户竞价次数策略实验-分组Id
     */
    private Integer bidCntGroupId;

    /**
     * 是否是app端流量
     * True : app端流量
     * False: web端流量
     */
    private Boolean isApp;

}
