package cn.com.duiba.nezha.alg.alg.adsupport;

import cn.com.duiba.nezha.alg.alg.vo.advertsupport.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;

import java.util.*;

import static cn.com.duiba.nezha.alg.alg.adsupport.AdvertSupportV1.division;
import static cn.com.duiba.nezha.alg.alg.adsupport.AdvertSupportV1.getConfidenceWeight;

public class AdvertRemain {


    public static double getFactor(AdvertRemainInfo adRemainInfo,
                                   RemainParams params) {
        Double factor = 1.0;
        if (AssertUtil.isAnyEmpty(adRemainInfo)) {
            return factor;
        }
        double costRatio = params.getCostRatio();
        double uplimit = params.getUplimit();
        double ratio1 = params.getRatio1();
        double ratio2 = params.getRatio2();
        double ratio3 = params.getRatio3();
        double alpha0 = params.getAlpha();

        if(adRemainInfo.getTodayData().getConv().getOrDefault(adRemainInfo.getConvType(),0L) >= adRemainInfo.getConvCnt()
                || (adRemainInfo.getTodayData().getOcpcConsume() >= 20000 && division(adRemainInfo.getTodayData().getOcpcConsume(),adRemainInfo.getTodayData().getCost()) > costRatio)){
            return factor;
        }
        List<Double> rankRatioBucket = params.getRankRatioBucket();
        List<Double>  rankRatioWeight = params.getRankRatioWeight();
        List<Double> cvrRatioBucket = params.getCvrRatioBucket();
        List<Double>  cvrRatioWeight = params.getCvrRatioWeight();

        Double[] rankRatioBucket1 = rankRatioBucket.toArray(new Double[rankRatioBucket.size()]);
        Double[] rankRatioWeight1 = rankRatioWeight.toArray(new Double[rankRatioWeight.size()]);
        Double[] cvrRatioBucket1 = cvrRatioBucket.toArray(new Double[cvrRatioBucket.size()]);
        Double[] cvrRatioWeight1 = cvrRatioWeight.toArray(new Double[cvrRatioWeight.size()]);


        double convRatio1 = adRemainInfo.getConvAvg7day().getOrDefault(adRemainInfo.getConvType(),0L) >= 5 ?
                division(adRemainInfo.getTodayData().getConv().getOrDefault(adRemainInfo.getConvType(),0L),adRemainInfo.getConvAvg7day().getOrDefault(adRemainInfo.getConvType(),0L)) : 1.0;
        double consumeRatio = adRemainInfo.getConsumeAvg7day() >= 5000 ?
                division(adRemainInfo.getTodayData().getConsume(),adRemainInfo.getConsumeAvg7day()) : 1.0;
        double convRatio2 = division(adRemainInfo.getTodayData().getConv().getOrDefault(adRemainInfo.getConvType(),0L),adRemainInfo.getConvCnt());

        Calendar calendar = Calendar.getInstance();
        Integer hour = calendar.get(calendar.HOUR_OF_DAY);

        if(convRatio1 < ratio1 || consumeRatio < ratio2 ||
                (hour >= 8 && convRatio2 < ratio3 * division(calendar.get(calendar.HOUR_OF_DAY),24))){
            double alpha = 1.0;
            Long conv1dayLastHour = adRemainInfo.getTodayData().getConv().getOrDefault(adRemainInfo.getConvType(),0L)
                    - adRemainInfo.getConvHour().getOrDefault(adRemainInfo.getConvType(),0L)
                    - adRemainInfo.getConvNow().getOrDefault(adRemainInfo.getConvType(),0L);
            if(division(adRemainInfo.getTodayData().getConv().getOrDefault(adRemainInfo.getConvType(),0L),adRemainInfo.getConvAvg7day().getOrDefault(adRemainInfo.getConvType(),0L)) >
                    division(conv1dayLastHour,adRemainInfo.getConvAvg7dayLastHour().getOrDefault(adRemainInfo.getConvType(),0L))){
                alpha = alpha0;
                factor = adRemainInfo.getLastFactor() * alpha;
                factor = Math.max(factor,1.05);

            }else{
                double rankRatio = division(adRemainInfo.getRankScore(),adRemainInfo.getRankScore1());
                double rankFactor = getConfidenceWeight(rankRatio,rankRatioBucket1,rankRatioWeight1,1.0);
                double cvrRatio = division(adRemainInfo.getPreCvr(),adRemainInfo.getAppAdPrecvr7day());
                double cvrFactor = getConfidenceWeight(cvrRatio,cvrRatioBucket1,cvrRatioWeight1,1.0);
                alpha = 0.5 * rankFactor + 0.5 * cvrFactor;

                double limit = Math.max(division(adRemainInfo.getAppAdCpc7day(),adRemainInfo.getFee()),1.0);
                factor = adRemainInfo.getLastFactor() * alpha;
                factor = Math.max(Math.min(factor,1.2 * limit),1.1);

            }
        }
        return Math.min(Math.max(factor,1.0),uplimit);
    }


    public static void main(String[] args) {

        AdvertRemainInfo info = new AdvertRemainInfo();
        SupportData advert3Day = new SupportData();
        advert3Day.setClick(10L);
        Map convs = new HashMap();
        convs.put(1,10L);
        convs.put(3,10L);
        advert3Day.setConv(convs);
        advert3Day.setExposure(100L);
        advert3Day.setConsume(100L);
        advert3Day.setOcpcConsume(100L);
        advert3Day.setCost(100.0);
        advert3Day.setCostBias(1.0);
        info.setTodayData(advert3Day);


        //过去7日累积到同时段广告的转化数
        Map convAvg7day = new HashMap();
        convAvg7day.put(1,20L);
        convAvg7day.put(3,20L);
        info.setConvAvg7day(convAvg7day);
        info.setConsumeAvg7day(1000L);

        Map convAvg7dayLast = new HashMap();
        convAvg7day.put(1,10L);
        convAvg7day.put(3,10L);
        info.setConvAvg7dayLastHour(convAvg7day);
        info.setCpc1day(20.0);
        info.setCpcAvg7day(21.0);


        //广告当前时段的消耗
        info.setConsumeHour(100L);
        //广告上个时段的消耗
        info.setConsumeLastHour(100L);
        //广告当前这不到一个小时的消耗
        info.setConsumeNow(100L);

        Map convHour = new HashMap();
        convHour.put(1,0L);
        convHour.put(3,0L);

        //广告当前这不到一个小时的转化
        info.setConvNow(convHour);
        //广告当前时段的转化
        info.setConvHour(convHour);
        //广告上个时段的转化
        info.setConvLastHour(convHour);
        //广告过去7天的平均出价
        info.setAdCpc7day(25.0);

        //媒体+广告过去7天的平均出价
        info.setAppAdCpc7day(25.0);
        //媒体+广告过去7天的平均预估cvr
        info.setAppAdPrecvr7day(0.01);

        info.setConvCnt(250L);
        info.setConvType(3);
        info.setLastFactor(1.05);//上次的提价因子
        info.setRankScore1(18.0);//排名第一名的rankScore
        info.setRankScore(15.0);//该广告的rankScore
        info.setPreCvr(0.08);
        info.setPreType(1);
        info.setFee(20L);

        List<Double> supportRatioBucket =  new ArrayList<>();

        supportRatioBucket.add(0.8);
        supportRatioBucket.add(0.9);
        supportRatioBucket.add(1.0);
        supportRatioBucket.add(1.2);

        RemainParams params = new RemainParams();
        List<Double>  supportRatioWeight = new ArrayList<>();
        supportRatioWeight.add(0.9);
        supportRatioWeight.add(1.0);
        supportRatioWeight.add(1.1);
        supportRatioWeight.add(1.2);


        List<Double> rankRatioBucket =  new ArrayList<>();
        rankRatioBucket.add(0.7);
        rankRatioBucket.add(0.8);
        rankRatioBucket.add(0.9);

        List<Double>  rankRatioWeight = new ArrayList<>();

        rankRatioWeight.add(0.9);
        rankRatioWeight.add(1.0);
        rankRatioWeight.add(1.2);

        params.setCvrRatioBucket(supportRatioBucket);
        params.setCvrRatioWeight(supportRatioWeight);
        params.setRankRatioBucket(rankRatioBucket);
        params.setRankRatioWeight(rankRatioWeight);

        double f = getFactor(info,params);
        System.out.println(f);


    }
}
