package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.rtbbid2.AdxConstant;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.*;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class AdxBid {

    private static final Logger logger = LoggerFactory.getLogger(AdxBid.class);

    /**
     * AdxRecommend出价（互动）
     *
     * @param adxBidReq
     * @return
     */
    public static AdxBidRet bid(AdxBidReq adxBidReq) {

        AdxBidRet ret = new AdxBidRet();

        try {
            if (!valid(adxBidReq)) {
                printBidReq(adxBidReq);
            }

            //流量参数
            Integer bidMode = adxBidReq.getBidMode();
            int priceType = Optional.ofNullable(adxBidReq.getPriceType()).orElse(1);
            Integer pmpType = adxBidReq.getPmpType();

            Double pmpPrice = DataUtil.toDouble(adxBidReq.getPmpPrice());

            //维稳参数对象
            AdxFactorBaseDo factorBaseDo = Optional.ofNullable(adxBidReq.getAdxFactorBaseDo()).orElse(new AdxFactorBaseDo());    //不同的分组ID对应不同的维稳参数对象
            double factor = factorBaseDo.getFactor();
            Double cpm = factorBaseDo.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(AdxConstant.DEFAULT_CPM);

            //创意参数
            Double preCtr = adxBidReq.getPreCtr();
            Double statCtr = Optional.ofNullable(adxBidReq.getStatCtr()).orElse(factorBaseDo.getStatCtr());
            Double ctr = MathUtil.mean(preCtr, statCtr, 0.9);
            ctr = Optional.ofNullable(ctr).orElse(AdxConstant.DEFAULT_CTR);

            Double preLaunchPv = adxBidReq.getPreLaunchPv();
            Double statLaunchPv = Optional.ofNullable(adxBidReq.getStatLaunchPv()).orElse(factorBaseDo.getLaunchPv());
            Double launchPv = MathUtil.mean(preLaunchPv, statLaunchPv, 0.7);
            launchPv = Optional.ofNullable(launchPv).orElse(AdxConstant.DEFAULT_LAUNCHPV);

            Double preArpu = adxBidReq.getPreArpu();
            Double arpuRectifyFactor = Optional.ofNullable(adxBidReq.getArpuRectifyFactor()).orElse(1.0);
            Double preArpu2 = preArpu == null ? null : (preArpu * arpuRectifyFactor);
            Double arpu = Optional.ofNullable(adxBidReq.getStatArpu()).orElse(factorBaseDo.getArpu());
            Double mixArpu = MathUtil.mean(preArpu2, arpu, 0.7);
            mixArpu = Optional.ofNullable(mixArpu).orElse(AdxConstant.DEFAULT_ARPU);
            arpu = Optional.ofNullable(arpu).orElse(AdxConstant.DEFAULT_ARPU);


            Double cpc = priceType == 1 ? adxBidReq.getCpc() : adxBidReq.getDirectCpc();
            Double roi = MathUtil.division(adxBidReq.getRoi(), 100L, 3);

            Integer expTag = adxBidReq.getAdxExploreDo().getExpTag();
            boolean expSwitch = adxBidReq.getAdxExploreDo().isExpSwitch();
            if (expTag == null) {
                expTag = 99;
            }

            ret.setArpu(arpu);
            ret.setMixArpu(mixArpu);
            ret.setPreArpu(preArpu);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setFactor(factor);

            Integer isGiveUp = 0;
            Double price = AdxBid.getPrice(adxBidReq, ret, cpc, roi);

            // pd流量算法决策
            if (pmpType != null && pmpType == 1) {
                isGiveUp = getPdDecision(price, pmpPrice, adxBidReq.isConfidence());
            }

            if (expTag >= 1 && Math.random() <= 0.005) {
                logger.info("priceExploreExpTag{} ,level{}, price{}, appId{}, slotId{}, priceType{}, bidMode{}", expTag, ret.getLevel(), price, adxBidReq.getAppId(), adxBidReq.getSlotId(), priceType, bidMode);
            }

            //计算rankScore
            price = price == null ? null : Math.min(price, 50 * cpm);
            Double rankScore = getRankScore(price, adxBidReq.getStatEcpm(), adxBidReq.isConfidence());

            //PD/PDB流量价格处理(pmpType类型：0-RTB，1-PD，2-PDB)
            if (pmpType != null && pmpType != 0) {
                price = pmpPrice;
            }

            ret.setAdxAlgoPrice(Math.round(price));
            ret.setIdeaId(adxBidReq.getIdeaId());
            ret.setIdeaUnitId(adxBidReq.getIdeaUnitId());
            ret.setRankScore(rankScore);
            ret.setIsGiveUp(isGiveUp);


        } catch (Exception e) {
            logger.error("AdxBid.bid error", e);
        }
        return ret;
    }

    /**
     * AdxRcmd出价
     *
     * @param adxBidReq
     * @return
     */
    public static AdxBidRet getBid(AdxBidReq adxBidReq) {

        AdxBidRet ret = new AdxBidRet();

        if (!validReq(adxBidReq)) {
            printBidReq(adxBidReq);
            return ret;
        }

        try {

            if (!valid(adxBidReq)) {
                printBidReq(adxBidReq);
            }

            //流量参数
            int priceType = Optional.ofNullable(adxBidReq.getPriceType()).orElse(1);
            Integer pmpType = adxBidReq.getPmpType();

            Double pmpPrice = DataUtil.toDouble(adxBidReq.getPmpPrice());
            Integer groupTag = adxBidReq.getGroupTag();

            //维稳参数对象
            double factor = adxBidReq.getFactor();

            //入口ctr
            Double preCtr = adxBidReq.getPreCtr();
            Double statCtr = adxBidReq.getStatCtr();
            Double ctr = getMerge(preCtr, statCtr, 0.9, 0.0,3.0, AdxConstant.DEFAULT_CTR);

            //每pv发券
            Double preLaunchPv = adxBidReq.getPreLaunchPv();
            Double statLaunchPv = adxBidReq.getStatLaunchPv();
            Double launchPv = getMerge(preLaunchPv, statLaunchPv, 0.5, 0.8,1.6, AdxConstant.DEFAULT_LAUNCHPV);

            //券arpu
            Double preArpu = adxBidReq.getPreArpu();
            Double arpuRectifyFactor = Optional.ofNullable(adxBidReq.getArpuRectifyFactor()).orElse(1.0);
            Double preArpu2 = preArpu == null ? null : (preArpu * arpuRectifyFactor);
            Double statArpu = adxBidReq.getStatArpu();
            Double arpu = getMerge(preArpu, statArpu, 0.5, 0.8,1.6, AdxConstant.DEFAULT_ARPU);

            //每pv点券
            Double preClickPv = adxBidReq.getPreClickPv();
            Double statClickPv = adxBidReq.getStatClickPv();
            Double clickPv = getMerge(preClickPv, statClickPv, 0.5, 0.8,1.6, AdxConstant.DEFAULT_CLICKPV);

            //券cpc
            Double preAdCpc = adxBidReq.getPreAdCpc();
            Double statAdCpc = adxBidReq.getStatAdCpc();
            Double adCpc = getMerge(preAdCpc, statAdCpc, 0.5, 0.8,1.6, AdxConstant.DEFAULT_ADCPC);


            // 每pv发券 * 券arpu = 每pv点券 * 券cpc
            //groupTag=1，launchPv+arpu，模型50%+统计50%；
            //groupTag=2/null，launchPv+arpu，统计
            //groupTag=3，clickPv+adcpc，模型50%+统计50%
            //groupTag=4，clickPv+adcpc，统计
            Double launchOrClickPv, arpuOrAdCpc;
            if (groupTag == null || groupTag <= 2) {
                if (groupTag == null || groupTag == 2) {
                    launchPv = Optional.ofNullable(statLaunchPv).orElse(AdxConstant.DEFAULT_LAUNCHPV);
                    arpu = Optional.ofNullable(statArpu).orElse(AdxConstant.DEFAULT_ARPU);
                }
                launchOrClickPv = launchPv;
                arpuOrAdCpc = arpu;

            } else {
                if (groupTag == 4) {
                    clickPv = Optional.ofNullable(statClickPv).orElse(AdxConstant.DEFAULT_CLICKPV);
                    adCpc = Optional.ofNullable(statAdCpc).orElse(AdxConstant.DEFAULT_ADCPC);;
                }
                launchOrClickPv = clickPv;
                arpuOrAdCpc = adCpc;
            }


            //计划cpc，roi
            Double cpc = priceType == 1 ? adxBidReq.getCpc() : adxBidReq.getDirectCpc();
            Double roi = MathUtil.division(adxBidReq.getRoi(), 100L, 3);

            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setMixArpu(arpu);
            ret.setArpu(statArpu);
            ret.setPreArpu(preArpu);
            ret.setFactor(factor);
            ret.setPreClickPv(preClickPv);
            ret.setStatClickPv(statClickPv);
            ret.setMergeClickPv(clickPv);
            ret.setPreAdCpc(preAdCpc);
            ret.setStatAdCpc(statAdCpc);
            ret.setMergeAdCpc(adCpc);
            ret.setLaunchOrClickPv(launchOrClickPv);
            ret.setArpuOrAdCpc(arpuOrAdCpc);


            Integer isGiveUp = 0;
            Double price = AdxBid.getPrice(adxBidReq, ret, cpc, roi);

            //计算rankScore
            Double cpm = adxBidReq.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(AdxConstant.DEFAULT_CPM);
            price = price == null ? null : Math.min(price, 50 * cpm);
            Double rankScore = getMixRankScore(price, adxBidReq.getStatEcpm(), adxBidReq.isConfidence());

            //PD/PDB流量价格处理(pmpType类型：0-RTB，1-PD，2-PDB)
            if (pmpType != null && pmpType != 0) {
                price = pmpPrice;
            }

            //cpc计费模式排序采用的是ecpm，出价需转回点击维度
            if (Objects.equals(pmpType, 0) && Objects.equals(adxBidReq.getBillType(), 0)) {
                if (Objects.equals(adxBidReq.getPriceType(), 0)){
                    price = adxBidReq.getPrice();
                }else if (Objects.equals(adxBidReq.getPriceType(), 1)) {
                    if (Objects.equals(adxBidReq.getAdxLaunchType(), 1)) {
                        price = (adxBidReq.getCpa() * adxBidReq.getPreCvr() + adxBidReq.getArpc()) * factor / roi;
                    } else if (Objects.equals(adxBidReq.getAdxLaunchType(), 0)) {
                        price = launchOrClickPv * arpuOrAdCpc * factor / roi;
                    }
                } else if (Objects.equals(adxBidReq.getPriceType(), 2)) {
                    price = cpc * factor / roi;
                } else if (Objects.equals(adxBidReq.getPriceType(), 3)) {
                    price = adxBidReq.getPrice();
                }
            }

            // 首发券广告
            if (adxBidReq.getAdxLaunchType() != null && adxBidReq.getAdxLaunchType() == 1) {
                ret.setPreCvr(adxBidReq.getPreCvr());
                ret.setFlcAdvertId(adxBidReq.getFlcAdvertId());
            }

            ret.setAdxAlgoPrice(Math.round(price));
            ret.setRankScore(rankScore);
            ret.setIsGiveUp(isGiveUp);

            ret.setExploreType(adxBidReq.getExploreType());
            ret.setBasePrice(adxBidReq.getBasePrice());
            ret.setIdeaId(adxBidReq.getIdeaId());
            ret.setIdeaUnitId(adxBidReq.getIdeaUnitId());
            ret.setIsNew(adxBidReq.getIsNew());
            ret.setIsColdStart(adxBidReq.getIsColdStart());


        } catch (Exception e) {
            logger.error("AdxBid.getBid error", e);
        }
        return ret;
    }

    /**
     * @param adxBidReq
     * @param adxBidRet
     * @param cpc
     * @param roi
     * @return
     */
    public static Double getPrice(AdxBidReq adxBidReq, AdxBidRet adxBidRet, Double cpc, Double roi) {
        //出价
        // pmpType类型：0-RTB，1-PD，2-PDB）
        //  priceType类型：0-互动人工，1-互动算法，2-直投算法，3-直投人工 )
        Integer pmpType = adxBidReq.getPmpType();
        Integer billType = adxBidReq.getBillType();
        Integer priceType = adxBidReq.getPriceType();
        Integer adxLaunchType = adxBidReq.getAdxLaunchType();

        Double factor = adxBidRet.getFactor();
        Double launchPv = adxBidRet.getLaunchPv();
        Double ctr = adxBidRet.getCtr();
        Double arpu = adxBidRet.getMixArpu();
        Double preCvr = adxBidReq.getPreCvr();

        Double launchOrClickPv = adxBidRet.getLaunchOrClickPv();
        Double arpuOrAdCpc = adxBidRet.getArpuOrAdCpc();

        if (pmpType != null && pmpType == 0) {
            //pmpType为RTB
            if (billType == 0) {
                //计价方式CPC
                switch (priceType) {
                    case 0:
                        return adxBidReq.getPrice() * ctr;
                    case 1:
                        if (Objects.equals(adxLaunchType, 1)) {
                            return (adxBidReq.getCpa() * preCvr * ctr + adxBidReq.getArpm()) * factor * 1000 / roi;
                        } else if (Objects.equals(adxLaunchType, 0)) {
                            return getRoiPrice(ctr, launchOrClickPv, arpuOrAdCpc, roi, factor);
                        }else{
                            break;
                        }
                    case 2:
                        return getDirectPrice(ctr, cpc, roi, factor);
                    case 3:
                        //直投人工（固价）
                        return adxBidReq.getPrice() * ctr * 1000;
                    default:
                }
            } else if (billType == 1) {
                //CPM计价方式
                switch (priceType) {
                    case 0:
                    case 3:
                        return adxBidReq.getPrice();
                    case 1:
                        if (adxLaunchType != null && adxLaunchType == 1) {
                            return (adxBidReq.getCpa() * preCvr * ctr + adxBidReq.getArpm()) * factor * 1000 / roi;
                        } else {
                            return adxBidReq.getBidMode() == 1 ? getRoiPrice(ctr, launchOrClickPv, arpuOrAdCpc, roi, factor) : getCpcPrice(ctr, cpc, factor);
                        }
                    case 2:
                        return getDirectPrice(ctr, cpc, roi, factor);
                    default:
                }
            }
        } else if (pmpType != null && pmpType == 1) {
            //pmpType为PD
            switch (priceType) {
                case 0:
                    return adxBidReq.getPrice();
                case 1:
                    return adxBidReq.getBidMode() == 1 ? getRoiPrice(ctr, launchOrClickPv, arpuOrAdCpc, roi, factor) : getCpcPrice(ctr, cpc, factor);
                default:
            }
        } else if (pmpType != null && pmpType == 2) {
            //pmpType为PDB
            return getEcpm(ctr, launchOrClickPv, arpuOrAdCpc);
        }
        return adxBidReq.getPrice();
    }

    public static List<AdxBidReq> buildAdxBidReq(AdIdeaDo adIdeaDo, AdxFactorBaseDo factorBaseDo, AdxAppReqDo adxAppReqDo) {

        List<AdxBidReq> adxBidReqs = new ArrayList<>();
        List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos();

        for (IdeaUnitDo ideaUnitDo : ideaUnitDos) {
            AdxBidReq adxBidReq = new AdxBidReq();
            adxBidReq.setAdxFactorBaseDo(factorBaseDo);
            BeanUtils.copy(adxAppReqDo, adxBidReq);
            BeanUtils.copy(adIdeaDo, adxBidReq);
            BeanUtils.copy(ideaUnitDo, adxBidReq);
            adxBidReq.setArpuRectifyFactor(adxAppReqDo.getArpuRectifyFactor());

            adxBidReq.setPrice(adIdeaDo.getPrice());

            //pmpType类型：0-RTB，1-PD，2-PDB
            if (adxAppReqDo != null && adxAppReqDo.getPmpType() != null) {
                adxBidReq.setPmpType(adxAppReqDo.getPmpType());
                if (adxAppReqDo.getPmpType() != 0) {
                    //保价
                    adxBidReq.setPrice(DataUtil.toDouble(adxAppReqDo.getPmpPrice()));
                    adxBidReq.setPmpPrice(adxAppReqDo.getPmpPrice());
                }
            }

            if (ideaUnitDo.getAdxStatsDo() != null) {
                AdxStatsDo adxStatsDo = ideaUnitDo.getAdxStatsDo();
                AdxIndexStatDo adxIndexStatDo = adxStatsDo.getLast1DayStat();
                adxBidReq.setStatCtr(AdxIndexStatDo.getStatCtr(adxIndexStatDo));
                adxBidReq.setStatLaunchPv(AdxIndexStatDo.getStatLaunchPv(adxIndexStatDo));
                adxBidReq.setStatArpu(AdxIndexStatDo.getStatArpu(adxIndexStatDo));
                adxBidReq.setStatEcpm(AdxIndexStatDo.getStatEcpm(adxIndexStatDo));
                adxBidReq.setConfidence(AdxIndexStatDo.isCostConfidence(adxIndexStatDo));
            }


            adxBidReqs.add(adxBidReq);
        }

        return adxBidReqs;

    }


    public static AdxBidReq buildAdxBidReq(AdIdeaDo adIdeaDo, AdxFactorDo adxFactorDo, AdxAppReqDo adxAppReqDo) {

        AdxBidReq adxBidReq = new AdxBidReq();
        getFactorDo(adxBidReq, adIdeaDo, adxFactorDo);

        adxBidReq.setPreCtr(adIdeaDo.getPreCtr());
        adxBidReq.setPreLaunchPv(adIdeaDo.getPreLaunchPv());
        adxBidReq.setPreArpu(adIdeaDo.getPreArpu());
        adxBidReq.setPreClickPv(adIdeaDo.getPreClickPv());
        adxBidReq.setPreAdCpc(adIdeaDo.getPreAdCpc());

        adxBidReq.setIdeaId(adIdeaDo.getIdeaId());
        adxBidReq.setBidMode(adIdeaDo.getBidMode());
        adxBidReq.setRoi(adIdeaDo.getRoi());
        adxBidReq.setCpc(adIdeaDo.getCpc());
        adxBidReq.setDirectCpc(adIdeaDo.getDirectCpc());

        adxBidReq.setPriceType(adIdeaDo.getPriceType());
        adxBidReq.setBillType(adIdeaDo.getBillType());

        adxBidReq.setPrice(adIdeaDo.getPrice());

        // 首发券相关
        adxBidReq.setAdxLaunchType(adIdeaDo.getAdxLaunchType());
        adxBidReq.setFlcAdvertId(adIdeaDo.getFlcAdvertId());
        adxBidReq.setPreCvr(adIdeaDo.getPreCvr());
        adxBidReq.setCpa(adIdeaDo.getCpa());

        if (adxAppReqDo != null) {
            adxBidReq.setAppId(adxAppReqDo.getAppId());
            adxBidReq.setSlotId(adxAppReqDo.getSlotId());
            adxBidReq.setPmpType(adxAppReqDo.getPmpType());
            adxBidReq.setPmpPrice(adxAppReqDo.getPmpPrice());
            adxBidReq.setBasePrice(adxAppReqDo.getBasePrice());
            adxBidReq.setGroupTag(adxAppReqDo.getGroupTag());
            adxBidReq.setArpuRectifyFactor(adxAppReqDo.getArpuRectifyFactor());
        }

        AdxStatsDo adIdeaStatsDo = adIdeaDo.getAdxStatsDo();
        AdxIndexStatDo adIdeaIndexDo = adIdeaStatsDo.getLast1DayStat();
        adxBidReq.setStatCtr(AdxRcmdBase.getStatCtr(adIdeaIndexDo, adxBidReq.getStatCtr()));
        adxBidReq.setStatLaunchPv(AdxRcmdBase.getStatPvLaunch(adIdeaIndexDo, adxBidReq.getStatLaunchPv()));
        adxBidReq.setStatArpu(AdxRcmdBase.getStatArpu(adIdeaIndexDo, adxBidReq.getStatArpu()));
        adxBidReq.setStatEcpm(AdxRcmdBase.getStatEcpm(adIdeaIndexDo, adxBidReq.getStatEcpm()));
        adxBidReq.setCpm(AdxRcmdBase.getStatCpm(adIdeaIndexDo, adxBidReq.getCpm()));
        adxBidReq.setStatClickPv(AdxRcmdBase.getStatClickPv(adIdeaIndexDo, adxBidReq.getStatClickPv()));
        adxBidReq.setStatAdCpc(AdxRcmdBase.getStatAdCpc(adIdeaIndexDo, adxBidReq.getStatAdCpc()));
        adxBidReq.setConfidence(AdxRcmdBase.isConfident(adIdeaIndexDo));


        //首发券
        AdxStatsDo adxStatsDo = Optional.ofNullable(adIdeaDo.getAdxStatsDo()).orElse(new AdxStatsDo());
        AdxIndexStatDo adIdea2dStat = Optional.ofNullable(adxStatsDo.getLast2DayStat()).orElse(new AdxIndexStatDo());
        if (!AssertUtil.isAnyEmpty(adIdea2dStat.getAdvertConsume(), adIdea2dStat.getFlcFee())) {
            long flcConsume = adIdea2dStat.getAdvertConsume() - adIdea2dStat.getFlcFee();
            Double arpc = MathUtil.division(flcConsume, adIdea2dStat.getClick(), 5);
            Double arpm = MathUtil.division(flcConsume, adIdea2dStat.getExp(), 5);
            adxBidReq.setArpc(Optional.ofNullable(arpc).orElse(0d));
            adxBidReq.setArpm(Optional.ofNullable(arpm).orElse(0d));
        } else {
            adxBidReq.setArpm(0d);
            adxBidReq.setArpc(0d);
        }


        return adxBidReq;
    }

    public static void getFactorDo(AdxBidReq ret, AdIdeaDo adIdeaDo, AdxFactorDo adxFactorDo) {

        double factor = 1.0;
        Integer exploreType = 1;//投放状态：1=正常投放，2=广告位探量投放，3=计划冷启动探价

        AdxFactorBaseDo adFactorBaseDo = Optional.ofNullable(adxFactorDo.getAdFactorBaseDo()).orElse(new AdxFactorBaseDo());
        AdxFactorBaseDo tradeFactorBaseDo = Optional.ofNullable(adxFactorDo.getTradeFactorBaseDo()).orElse(new AdxFactorBaseDo());
        AdxFactorBaseDo appFactorBaseDo = Optional.ofNullable(adxFactorDo.getAppFactorBaseDo()).orElse(new AdxFactorBaseDo());

        factor = adFactorBaseDo.getFactor();
        if (appFactorBaseDo.conf) {
            factor = appFactorBaseDo.getFactor();
        } else if (tradeFactorBaseDo.conf) {
            factor = tradeFactorBaseDo.getFactor();
        }

        SlotFactorDo slotFactorDo = Optional.ofNullable(adxFactorDo.getSlotFactorDo()).orElse(new SlotFactorDo());
        boolean isSlotExplore = slotFactorDo.isExplore();
        double flowRatio = slotFactorDo.getFlowRatio();
        double slotFactor = slotFactorDo.getFactor();

        Boolean isColdStart = adIdeaDo.getIsColdStart();
        ColdStartFactorDo coldStartFactorDo = Optional.ofNullable(adxFactorDo.getColdStartFactorDo()).orElse(new ColdStartFactorDo());
        boolean isAdColdExplore = coldStartFactorDo.isExplore();
        double adColdFactor = coldStartFactorDo.getFactor();

//        double random = Math.random();
//        if (isSlotExplore && random < flowRatio) {
//            factor = Math.max(slotFactor, factor);
//            exploreType = 2;
//
//        } else if (isColdStart != null && isColdStart && isAdColdExplore) {
//            factor = Math.max(adColdFactor, factor);
//            exploreType = 3;
//        }


        //获取统计指标
        ret.setStatCtr(adFactorBaseDo.getStatCtr());
        ret.setStatLaunchPv(adFactorBaseDo.getLaunchPv());
        ret.setStatArpu(adFactorBaseDo.getArpu());
        ret.setStatEcpm(adFactorBaseDo.getStatEcpm());
        ret.setCpm(adFactorBaseDo.getCpm());
        ret.setStatClickPv(adFactorBaseDo.getStatClickPv());
        ret.setStatAdCpc(adFactorBaseDo.getStatAdCpc());
        if (appFactorBaseDo.dataConf) {
            ret.setStatCtr(appFactorBaseDo.getStatCtr());
            ret.setStatLaunchPv(appFactorBaseDo.getLaunchPv());
            ret.setStatArpu(appFactorBaseDo.getArpu());
            ret.setStatEcpm(appFactorBaseDo.getStatEcpm());
            ret.setCpm(appFactorBaseDo.getCpm());
            ret.setStatClickPv(appFactorBaseDo.getStatClickPv());
            ret.setStatAdCpc(appFactorBaseDo.getStatAdCpc());
        } else if (tradeFactorBaseDo.dataConf) {
            ret.setStatCtr(tradeFactorBaseDo.getStatCtr());
            ret.setStatLaunchPv(tradeFactorBaseDo.getLaunchPv());
            ret.setStatArpu(tradeFactorBaseDo.getArpu());
            ret.setStatEcpm(tradeFactorBaseDo.getStatEcpm());
            ret.setCpm(tradeFactorBaseDo.getCpm());
            ret.setStatClickPv(tradeFactorBaseDo.getStatClickPv());
            ret.setStatAdCpc(tradeFactorBaseDo.getStatAdCpc());
        }

        ret.setFactor(factor);
        ret.setExploreType(exploreType);
        ret.setIsColdStart(isColdStart);

    }

    public static String doubleMap(Map<String, Double> map, double rand) {

        // 参数检验
        if (AssertUtil.isEmpty(map)) {
            logger.warn("priceExploreExp mapSample param is invalid, params invalid");
            return null;
        }

        double w = 0.0;
        try {
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                w += entry.getValue();
                if (rand <= w) {
                    return entry.getKey();
                }
            }
        } catch (Exception e) {
            logger.error("priceExploreExp mapSample happened error: ", e);

        }
        return null;
    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag >= 2 && !expSwitch) {
            return ctr * cpc * exploreFactor * 1000 * 100;
        } else {
            return ctr * cpc * factor * 1000 * 100;
        }
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, double factor, Double roi, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag >= 2 && !expSwitch) {
            return DataUtil.division(ctr * algoCpcPrice * exploreFactor * 1000, roi, 3);
        } else {
            return DataUtil.division(ctr * algoCpcPrice * factor * 1000, roi, 3);
        }
    }

    public static Double getRoiPrice(Double ctr, double factor, Double launchPv, Double arpu, Double mixArpu, Double roi, Integer expTag, double exploreFactor, boolean expSwitch, Integer groupTag) {
        if (expTag >= 2 && !expSwitch) {
            if (groupTag == 1) {
                return ctr * launchPv * mixArpu * exploreFactor / roi * 1000;
            } else {
                return ctr * launchPv * arpu * exploreFactor / roi * 1000;
            }
        } else {
            if (groupTag == 1) {
                return ctr * launchPv * mixArpu * factor / roi * 1000;
            } else {
                return ctr * launchPv * arpu * factor / roi * 1000;
            }
        }
    }


    public static Double getEcpm(Double ctr, Double launchPv, Double arpu, Double mixArpu, Integer groupTag) {

        if (groupTag == 1) {
            return ctr * launchPv * mixArpu * 1000;
        } else {
            return ctr * launchPv * arpu * 1000;
        }

    }

    public static Double getEcpm(Double ctr, Double launchPv, Double arpu) {
        return ctr * launchPv * arpu * 1000;
    }

    public static Double getRoiPrice(Double ctr, Double launchPv, Double arpu, Double roi, double factor) {
        return ctr * launchPv * arpu * factor * 1000 / roi;
    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor) {
        return ctr * cpc * factor * 1000 * 100;
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, Double roi, double factor) {
        return ctr * algoCpcPrice * factor * 1000 / roi;
    }

    public static Double getDirectRoiPrice(Double algoCpcPrice, Double roi, double factor) {
        return algoCpcPrice * factor / roi;
    }

    public static Double getDirectCpcRoiPrice(Double algoCpcPrice, Double ctr, Double roi, double factor) {
        return algoCpcPrice * ctr * factor / roi;
    }

    /**
     * 检测入参是否异常
     *
     * @param adxBidReq
     * @return
     */
    public static boolean validReq(AdxBidReq adxBidReq) {
        boolean ret = true;
        if (Objects.equals(adxBidReq.getPriceType(), 1) && Objects.equals(adxBidReq.getAdxLaunchType(), 1)) {
            if (AssertUtil.isAnyEmpty(adxBidReq.getPreCtr(), adxBidReq.getPreCvr(), adxBidReq.getCpa())) {
                return false;
            }
        }
        return ret;
    }

    public static boolean valid(AdxBidReq adxBidReq) {
        boolean ret = true;

        if (AssertUtil.isAnyEmpty(adxBidReq, adxBidReq.getPreCtr(), adxBidReq.getPriceType())) {
            return false;
        }
        if (adxBidReq.getPriceType() == 1) {
            if (adxBidReq.getBidMode() == null) {
                return false;
            } else if (adxBidReq.getBidMode() == 1) {
                ret = adxBidReq.getRoi() != null; //&& adxBidReq.getPreLaunchPv() != null
            } else {
                ret = adxBidReq.getCpc() == null ? false : true;
            }
        } else if (adxBidReq.getPriceType() == 2) {
            ret = adxBidReq.getDirectCpc() != null && adxBidReq.getRoi() != null;
        }

        //不支持的pmpType,billType,priceType组合 - 20220118
        if (adxBidReq.getPmpType() == 0) {
            if (adxBidReq.getBillType() == 0) {
                if (adxBidReq.getPriceType() == 1) {
                    if (adxBidReq.getAdxLaunchType() == null && adxBidReq.getAdxLaunchType() != 1) {
                        //CPC计费方式&算法出价&非首发券
                        return false;
                    }

                }
            }
        } else if (adxBidReq.getPmpType() == 1) {
            if (adxBidReq.getBillType() == 0) {
                return false;
            } else if (adxBidReq.getBillType() == 1) {
                if (adxBidReq.getPriceType() == 2 || adxBidReq.getPriceType() == 3) {
                    return false;
                }
            }
        } else if (adxBidReq.getPmpType() == 2) {
            if (adxBidReq.getBillType() == 0) {
                return false;
            } else if (adxBidReq.getBillType() == 1) {
                if (adxBidReq.getPriceType() == 1 || adxBidReq.getPriceType() == 2 || adxBidReq.getPriceType() == 3) {
                    return false;
                }
            }
        }

        return ret;

    }

    public static void printBidReq(AdxBidReq adxBidReq) {

        if (Math.random() < 0.001) {
            logger.warn("bidRequestDo2 is not valid, groupId:{}, resourceId:{}, ideaId:{}, appId:{}, priceType:{}, bidMode:{}, preCtr:{}, roi:{}, preLaunchPv:{}, cpc:{}, directCpc:{}, pmpType:{}, billType:{}，cpa:{}", adxBidReq.getGroupId(), adxBidReq.getResId(), adxBidReq.getIdeaId(), adxBidReq.getAppId(), adxBidReq.getPriceType(), adxBidReq.getBidMode(), adxBidReq.getPreCtr(), adxBidReq.getRoi(), adxBidReq.getPreLaunchPv(), adxBidReq.getCpc(), adxBidReq.getDirectCpc(), adxBidReq.getPmpType(), adxBidReq.getBillType(), adxBidReq.getCpa());

        }


    }

    public static Double getRankScore(Double price, Double statEcpm, boolean isConfidence) {
        Double rankScore = null;
        if (AssertUtil.isNotEmpty(price)) {
            rankScore = (!isConfidence ? price * (1 + 2 * Math.random()) : price);
        }
        rankScore = MathUtil.mean(rankScore, statEcpm, 0.7);
        return rankScore;
    }

    public static Double getMixRankScore(Double price, Double statEcpm, boolean isConfidence) {
        Double rankScore = null;
        if (AssertUtil.isNotEmpty(price)) {
            rankScore = (!isConfidence ? price * (1 + 1 * Math.random()) : price);
        }
        rankScore = MathUtil.mean(rankScore, statEcpm, 0.8);
        return rankScore;
    }


    public static Integer getPdDecision(Double price, Double pmpPrice, boolean isConfidence) {

        double p = 0.0; //放弃概率
        if (AssertUtil.isAllNotEmpty(price, pmpPrice)) {

            if (price < pmpPrice * 0.5) {
                p = 0.8;
                if (isConfidence) {
                    p = 0.95;
                }

            } else if (price < pmpPrice * 0.7) {
                p = 0.7;
                if (isConfidence) {
                    p = 0.90;
                }

            } else if (price < pmpPrice) {
                p = 0.6;
                if (isConfidence) {
                    p = 0.85;
                }
            }
        }

        double random = Math.random();
        return random < p ? 1 : 0; // 0--不放弃；1--放弃

    }


    public static Double getMerge(Double pre, Double stat, double weight, double limitLow, double limitUp, double defaultValue) {

        Double ret = null;
        if (pre != null && stat != null) {
            pre = getLimit(pre, stat, limitLow, limitUp);
            ret = pre * weight + stat * (1 - weight);
        } else if (pre != null) {
            ret = getLimit(pre, defaultValue, limitLow, limitUp);
        } else {
            ret = stat;
        }

        ret = Optional.ofNullable(ret).orElse(defaultValue);
        return DataUtil.formatDouble(ret, 6);
    }

    public static Double getLimit(double value, double base, double limitLow, double limitUp) {
        Double ret = value;
        if (value > base * limitUp) {
            ret = base * limitUp;
        } else if (value < base * limitLow) {
            ret = base * limitLow;
        }
        return DataUtil.formatDouble(ret, 6);
    }


}
