package cn.com.duiba.nezha.alg.alg.material;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialDataParams1;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialIDselectDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialIDselectReturnDo;
import org.dmg.pmml.False;

import java.util.*;
import java.util.stream.Collectors;

public class MaterialIDSelectbug {   //新增两个素材优选的策略


    /**
     * 新增策略1
     *  // 新的统计：在同配置、同计划、同落地页、不同广告素材的情况下，统计近两周的实际ctrcvr，排序，取top1的素材(离线)；
     *  //如果是cpa，则执行，不是cpa则走nezha-servive的 ctrValue
     * @param
     * @param materialIDselect，redis存储对象; //MaterialIDselectDo
     * @param currentMaterialIds 当前流量素材列表；不为空
     *
     * @return  <推荐的素材id加标识符>  返回结果写进对象里面
     * @throws Exception
     *
     */
    public static MaterialIDselectReturnDo getStrategyOneResultNew(List<Long> currentMaterialIds, MaterialIDselectDo materialIDselect) {

        //20%的预估；80%的取top1；先生成一列随机数；命中前20%的走随机；否则走top

        //materialIDselect ；nezhe传过来的redis对象
        MaterialIDselectReturnDo materialreturn = new MaterialIDselectReturnDo();//推荐结果返回给nezhe的对象
        if (materialIDselect !=null){  //如果redis存储对象为空的话，100%的从当前流量素材列表里面随机抽一个
            try {
                List<Long> oneMaterialIds = materialIDselect.getOneMaterialIds();   //从redis的对象取出OneMaterialIds；策略1推荐列表
                if (oneMaterialIds != null) {
                    boolean same = Collections.disjoint(oneMaterialIds, currentMaterialIds);//是否存在交集//没有相同元素返回true。如果传入参数为 null 会引发空指针异常。
                    if (!(same)) { //判断redis历史素材id在不在这个当前流量素材列表 //OneMaterialIds in currentMaterialIds
                        //System.out.println("redis列表在当前流量素材列表里面");
                        int randomWeight = (int) (materialIDselect.getStrategyOneRandomWeight() * 100);
                        //double one = 1.0;
                        //double other = one - materialIDselect.getStrategyOneRandomWeight(); //为了判断比例是否合适

                        //在0到99之间产生不重复的0到99的随机数
                        Random r = new Random();
                        int randINT = r.nextInt(100)+1; //0-99+1
                        if (randINT <= randomWeight) {
                            goRandom2(currentMaterialIds, materialreturn);

                        } else {//走统计
                            Long recmaterialId = oneMaterialIds.get(0); //新的统计80%
                            materialreturn.setStrategyOneRecmaterialId(recmaterialId);//写进对象里面
                            materialreturn.setRandom1("1");//20%的随机
                        }

                    } else {//不在则从当前流量素材列表随机抽一个
                        //System.out.println("redis列表不在当前流量素材列表里面");
                        goRandom1(currentMaterialIds, materialreturn); //100%的从当前流量素材列表里面随机抽一个
                    }
                } else { //如果redis为空；则从当前流量素材列表里面随机选一个
                    //System.out.println("redis列表里面的策略1列表为空，需排查");
                    goRandom1(currentMaterialIds, materialreturn); //100%的从当前流量素材列表里面随机抽一个
                }
            }catch (

                    Exception e) {
                //System.out.println("redis列表里面的策略1列表为空，需排查,走随机");
                goRandom1(currentMaterialIds, materialreturn); //100%的从当前流量素材列表里面随机抽一个
                e.printStackTrace();}
             //finally {
                //System.gc();
            //}
        }
        else{
            //System.out.println("素材redis对象列表为空");
            goRandom1(currentMaterialIds, materialreturn); //100%的从当前流量素材列表里面随机抽一个
        }

        return materialreturn;
    }






    /**

     * @param
     * @param materialreturn，返回对象; //MaterialIDselectReturnDo
     * @param currentMaterialIds 当前流量素材列表；
     *
     * @return 无；直接写在了返回对象对象里面；策略1
     * @throws Exception
     *
     */
    public static void goRandom2(List<Long> currentMaterialIds, MaterialIDselectReturnDo materialreturn){
        //100%的从当前流量素材列表里面随机抽一个
        Random random = new Random();
        int n = random.nextInt(currentMaterialIds.size());
        Long materialId = currentMaterialIds.get(n);
        materialreturn.setStrategyOneRecmaterialId(materialId);//写进对象里面
        materialreturn.setRandom1("0");//"0"是20%的随机；'1是80%的统计{策略2是80%的统计+预估}'；'2'是100%的随机

    }


    /**

     * @param
     * @param materialreturn，返回对象; //MaterialIDselectReturnDo
     * @param currentMaterialIds 当前流量素材列表；不为空在传进来
     *
     * @return 无；直接写在了返回对象对象里面
     * @throws Exception
     *跟上面一样；只是为了添加个不一样的随机表示而已；策略1
     */
    public static void goRandom1(List<Long> currentMaterialIds, MaterialIDselectReturnDo materialreturn){
        //100%的从当前流量素材列表里面随机抽一个
        Random random = new Random();
        int n = random.nextInt(currentMaterialIds.size());
        Long materialId = currentMaterialIds.get(n);
        materialreturn.setStrategyOneRecmaterialId(materialId);//写进对象里面
        materialreturn.setRandom1("2");//"0"是20%的随机；'1是80%的统计{策略2是80%的统计+预估}'；'2'是100%的随机

    }



    /**
     * @param
     * @param materialreturn，返回对象; //MaterialIDselectReturnDo
     * @param currentMaterialIds 当前流量素材列表；
     *
     * @return 无；直接写在了返回对象对象里面；策略2
     * @throws Exception
     *
     */
    public static void goRandom3(List<Long> currentMaterialIds, MaterialIDselectReturnDo materialreturn){
        //100%的从当前流量素材列表里面随机抽一个
        Random random = new Random();
        int n = random.nextInt(currentMaterialIds.size());
        Long materialId = currentMaterialIds.get(n);
        materialreturn.setStrategyTwoRecmaterialId(materialId);//写进对象里面
        materialreturn.setRandom1("0");//"0"是20%的随机；'1是80%的统计{策略2是80%的统计+预估}'；'2'是100%的随机

    }


    /**
     * @param
     * @param materialreturn，返回对象; //MaterialIDselectReturnDo
     * @param currentMaterialIds 当前流量素材列表；
     *
     * @return 无；直接写在了返回对象对象里面
     * @throws Exception
     *跟上面一样；只是为了添加个不一样的随机表示而已；策略2
     */
    public static void goRandom4(List<Long> currentMaterialIds, MaterialIDselectReturnDo materialreturn){
        //100%的从当前流量素材列表里面随机抽一个
        Random random = new Random();
        int n = random.nextInt(currentMaterialIds.size());
        Long materialId = currentMaterialIds.get(n);
        materialreturn.setStrategyTwoRecmaterialId(materialId);//写进对象里面
        materialreturn.setRandom1("2");//"0"是20%的随机；'1是80%的统计{策略2是80%的统计+预估}'；'2'是100%的随机

    }




    /**
     * 新增策略2
     *  // 在同配置、同计划、同落地页、不同广告素材的情况下，统计近两周的实际ctrcvr，预估ctrcvr，根据实际ctrcvr30%+预估ctrcvr70%（预估是实时的），排序，取top1的素材(离线)；
     *   //如果是cpa，则执行，不是cpa则走nezha-servive的 ctrValue
     *
     * @param materialIDselect redis存储对象
     * @param currentMaterialIds 当前流量素材列表; 不为空
     * 需要两个入参 prectr 预估ctr(实时)，precvr 预估cvr(实时)，写在MaterialDataParams1这个对象里面
     *
     * @return <推荐的素材id加标识符> 返回结果写进对象里面
     * @throws Exception
     */
    public static MaterialIDselectReturnDo getStrategyTwoResultNew(List<Long> currentMaterialIds,
                                                                   MaterialIDselectDo materialIDselect) {

        MaterialIDselectReturnDo materialreturn = new MaterialIDselectReturnDo();//推荐结果返回给nezhe的对象
        if (materialIDselect !=null){ //如果redis存储对象为空的话，100%的从当前流量素材列表里面随机抽一个
            try {
                List<Long> twoMaterialIds = materialIDselect.getTwoMaterialIds();   //从redis的对象取出OneMaterialIds；策略1推荐列表

                // orientationId1.equals(orientationId)
                if (twoMaterialIds != null) {
                    boolean same = Collections.disjoint(twoMaterialIds, currentMaterialIds);//是否存在交集//没有相同元素返回true。如果传入参数为 null 会引发空指针异常。
                    if (!(same)) { //判断redis历史素材id在不在这个当前流量素材列表 //OneMaterialIds in currentMaterialIds
                        //System.out.println("redis列表在当前流量素材列表里面");
                        int randomWeight = (int) (materialIDselect.getStrategyTwoRandomWeight() * 100);
                        // double one = 1.0;
                        //double other = one - materialIDselect.getStrategyTwoRandomWeight(); //为了判断比例是否合适

                        //在0到99之间产生不重复的0到99的随机数
                        Random r = new Random();
                        int randINT = r.nextInt(100)+1; //0-99+1
                        if (randINT <= randomWeight) {
                            goRandom3(currentMaterialIds, materialreturn);
                        } else {//走统计+预估
                            returnpredictandstatics(materialIDselect,materialreturn);//走统计+预估计算
                        }

                    } else {//不在则从当前流量素材列表随机抽一个
                        //System.out.println("redis列表不在当前流量素材列表里面");
                        goRandom4(currentMaterialIds, materialreturn); //100%的从当前流量素材列表里面随机抽一个
                    }
                } else { //如果redis为空；则从当前流量素材列表里面随机选一个
                    //System.out.println("redis列表里面的策略1列表为空，需排查");
                    goRandom4(currentMaterialIds, materialreturn); //100%的从当前流量素材列表里面随机抽一个
                }
            }catch (

                    Exception e) {
                //System.out.println("redis列表里面的策略1列表为空，需排查,走随机");
                goRandom4(currentMaterialIds, materialreturn); //100%的从当前流量素材列表里面随机抽一个
                e.printStackTrace();}
//             finally {
//                System.gc();
//            }
        }
        else{
            //System.out.println("素材redis对象列表为空");
            goRandom4(currentMaterialIds, materialreturn); //100%的从当前流量素材列表里面随机抽一个
          }
        return materialreturn;
    }





    /**
     * @param
     * @param materialreturn，返回对象; //MaterialIDselectReturnDo
     * @param materialIDselect 当前流量素材列表；redis存储对象; //MaterialIDselectDo
     *   Double prectr,Double precvr,写在MaterialDataParams1这个对象里面
     * @return 无；直接写在了返回对象对象里面
     * @throws Exception
     *跟上面一样；只是为了添加个不一样的随机表示而已
     */


    public static void returnpredictandstatics( MaterialIDselectDo materialIDselect, MaterialIDselectReturnDo materialreturn){
        //100%的从当前流量素材列表里面随机抽一个
        try{
            Double strategyTwoPredictWeight = materialIDselect.getStrategyTwoPredictWeight() ; //新的统计值的权重 0.3 ture_ctrcvr；针对策略2
            Double strategyTwoStatisticWeight = materialIDselect.getStrategyTwoStatisticWeight(); //新的预估值权重 0.7 实时(prectr;recvr);针对策略2
            List<Long> twoMaterialIds = materialIDselect.getTwoMaterialIds();
            //List<Long> currentMaterialIds, MaterialIDselectReturnDo materialreturn
            List<MaterialDataParams1> ctrcvrlists=materialIDselect.getCtrcvrlists();

            List<Long> twoMaterialIdsSorted = ctrcvrlists.stream().filter(x -> twoMaterialIds.contains(x.getMaterialId())).sorted(new Comparator<MaterialDataParams1>() {//策略2
                @Override  //父类方法的重写
                public int compare(MaterialDataParams1 o1, MaterialDataParams1 o2) {
                    //System.out.println("开始遍历策略2的数据");
                    Double a1 = (o1.getPredictCtrOnline() == null ? 0.0D : o1.getPredictCtrOnline()) * (o1.getPredictCvrOnline() == null ? 0.0D : o1.getPredictCvrOnline());//prectrcvr；如果为空则为0
                    Double a2 = (o2.getPredictCtrOnline() == null ? 0.0D : o2.getPredictCtrOnline()) * (o2.getPredictCvrOnline() == null ? 0.0D : o2.getPredictCvrOnline());//prectrcvr

                    Double ctrcvr1 = (o1.getCtrcvr() == null ? 0.0D : o1.getCtrcvr());//ctrcvr
                    Double ctrcvr2 = (o2.getCtrcvr() == null ? 0.0D : o2.getCtrcvr());//ctrcvr

                    Double compare1 = (ctrcvr1 * strategyTwoStatisticWeight) + (a1 * strategyTwoPredictWeight);  // (ctrcvr1*0.3)+(a1*0.7);//新的统计0.3+预估ctrcvr*0.7
                    Double compare2 = (ctrcvr2 * strategyTwoStatisticWeight) + (a2 * strategyTwoPredictWeight);  // prectrcvr
                    //System.out.println("策略2排序计算完成");
                    return compare1.compareTo(compare2);

                }
            }.reversed()).map(x -> x.getMaterialId()).collect(Collectors.toList());

            Long recmaterialId = twoMaterialIdsSorted.get(0);
            materialreturn.setStrategyTwoRecmaterialId(recmaterialId); //写进对象里面
            materialreturn.setRandom1("1");//素材从哪个位置投出去的

        }catch (

                Exception e) {
            //System.out.println("策略2排序出错了");
            e.printStackTrace();
        }
         //finally {
            //System.gc();
        //}


    }



}