package cn.com.duiba.nezha.alg.alg.vo.adx.directly2;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class AdxExpStatDo {

    public Double ideaEcpm;

    public Map<String, Double> appEcpm = new HashMap<>();

    public static Double getAppEcpm(AdxExpStatDo adxExpStatDo, String appId) {
        Double ret = null;
        if(AssertUtil.isAnyEmpty(adxExpStatDo, appId)) {
            return ret;
        }
        if(adxExpStatDo.getAppEcpm() != null) {
            ret = adxExpStatDo.getAppEcpm().get(appId);
        }
        return ret;
    }

    public void putAppEcpm(String appId, Double ecpm) {
        if(AssertUtil.isAllNotEmpty(appId, ecpm)) {
            appEcpm.put(appId, ecpm);
        }
    }
}
