package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import lombok.Data;

import java.util.Map;

/**
 * 创意计划特征对象
 */
@Data
public class AdxIdeaAdFeatureDo {
    private Long groupId; //组
    private Long resourceId;//资源位
    private Long ideaId;//创意ID
    private Integer ideaType; //互动创意类型(0-普通静态创意，1-动态创意) f3010140

    /**
     * 首发券特征对象
     */
    private AdxFlcFeatureDo adxFlcFeatureDo;

    private String styleStandard; // 广告样式规格 f3010130

    //创意+分媒体行为特征
    private Long ideaAppExpCntDay; //创意+百度appId 当天曝光次数 f3060011
    private Long ideaAppClickCntDay; //创意+百度appId 当天点击次数 f3060012
    private Long ideaAppAdCostDay; //创意+百度appId 当天广告消耗	 f3060013

    //创意+活动特征
    private Long ideaActAccCntDay;   //创意 当天活动访问次数
    private Long ideaActJoinCntDay;   //创意 当天活动参与次数
    private Long ideaActAccCntWeek;   //创意 当天活动访问次数
    private Long ideaActJoinCntWeek;   //创意 当天活动参与次数

    //活动+创意行为数据
    private Map<Long, Long> actIdeaActAccCntDay;    //活动+创意 活动访问数据
    private Map<Long, Long> actIdeaActJoinCntDay;    //活动+创意 活动参与数据
    private Map<Long, Long> actIdeaActAccCntWeek;    //活动+创意 活动访问数据
    private Map<Long, Long> actIdeaActJoinCntWeek;    //活动+创意 活动参与数据
}
