package cn.com.duiba.nezha.alg.alg.vo.adx.rtb2;

import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;

@Data
public class AdxIdeaDo {

    /**
     * 计划ID
     */
    private Long ideaId;

    /**
     * 出价类型
     */
    private Integer bidMode;

    /**
     * 目标roi（百分比）
     */
    private Double roi;

    /**
     * 目标cpc（元/单次点击）
     */
    private Double cpc;

    /**
     * 冷启动探价预算/分
     */
    private Long coldStartFee;

    /**
     * 是否开启计划冷启动探价 0=关闭, 1-开启
     */
    private Boolean isColdStart;

    public Double getCpc2() {
        Double ret = null;
        if(cpc != null) {
            ret = cpc * 100;
        }
        return ret;
    }


    /**
     * 获取目标分成、cpc
     * @param adxIdeaDo
     * @return
     */
    public static Double getTarget(AdxIdeaDo adxIdeaDo) {

        Double ret = null;
        if(adxIdeaDo != null && adxIdeaDo.getBidMode() != null) {
            Integer bidMode = adxIdeaDo.getBidMode();
            Double roi = adxIdeaDo.getRoi();
            Double cpc = adxIdeaDo.getCpc2();

            ret = bidMode == 2 ? cpc : MathUtil.division(100., roi,3); //注意单位量级
        }

        return ret;
    }
}
