/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.LaunchPvFiltering3;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterCntDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchPvFiltering {
    private static final Logger logger = LoggerFactory.getLogger(LaunchPvFiltering3.class);

    public static FlowFilterResultDo getLaunchPvFiltering(FlowFilterRequestDo flowFilterRequestDo) {
        FlowFilterResultDo ret = new FlowFilterResultDo();
        try {
            Integer flowFilterLabel = 0;
            Integer filterType = 0;
            boolean isConfident = false;
            Double preWeight = 0.8;
            Double flowerLimit = 0.0;
            Double fUpperLimit = 4.0;
            Double defaultValue = 0.01;
            Double preLaunchPv = flowFilterRequestDo.getPreLaunchPv();
            AdxFlowInfoDo flowInfo = flowFilterRequestDo.getFlowInfo();
            if (AssertUtil.isNotEmpty((Object)flowInfo)) {
                AdxIndexStatDo ideaMinStats = flowInfo.getIdeaMinStats();
                AdxIndexStatsDo ideaMinComputes = AdxStatData.adxIndexCompute(ideaMinStats);
                AdxIndexStatDo ideaDayStats = flowInfo.getIdeaDayStats();
                AdxIndexStatsDo ideaDayComputes = AdxStatData.adxIndexCompute(ideaDayStats);
                isConfident = ideaMinComputes.getConfident() != false && ideaDayComputes.getConfident() != false;
                Map<Integer, AdxFilterCntDo> ideafilterDo = flowFilterRequestDo.getIdeafilterCntDo();
                Double minfilterRate = AdxStatData.getFilterRate(ideafilterDo, "20min", 2);
                Double dayfilterRate = AdxStatData.getFilterRate(ideafilterDo, "1day", 2);
                Double filterRate = Math.max(minfilterRate, dayfilterRate);
                Double statLaunchPv = AdxStatData.nullToDefault(ideaMinComputes.getLaunchPv(), ideaDayComputes.getLaunchPv());
                Double conLaunchPv = AdxStatData.getConValue(preLaunchPv, statLaunchPv, preWeight, flowerLimit, fUpperLimit, defaultValue);
                Double launchPvLimit = AdxStatData.nullToMinDefault(flowFilterRequestDo.getLaunchPvLimit(), 0.0);
                double random = Math.random();
                if (isConfident) {
                    if (conLaunchPv < launchPvLimit * 0.8) {
                        flowFilterLabel = random < 0.99 ? 1 : 0;
                    } else if (conLaunchPv < launchPvLimit * 0.9) {
                        flowFilterLabel = random < 0.95 ? 1 : 0;
                    } else if (conLaunchPv < launchPvLimit) {
                        flowFilterLabel = random < 0.9 ? 1 : 0;
                    }
                }
                double random2 = Math.random();
                if (flowFilterLabel.equals(1)) {
                    if (filterRate > 0.8) {
                        flowFilterLabel = random < 0.2 ? 1 : 0;
                    } else if (filterRate > 0.5) {
                        flowFilterLabel = random2 < 0.5 ? 1 : 0;
                    }
                }
            }
            filterType = flowFilterLabel == 1 ? 2 : 0;
            ret.setFlowFilterLabel(flowFilterLabel);
            ret.setFilterType(filterType);
        }
        catch (Exception e) {
            logger.error("LaunchPvFiltering.getLaunchPvFiltering error " + e);
        }
        return ret;
    }
}

