/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rta;

import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTAModel {
    private static final Logger logger = LoggerFactory.getLogger(RTAModel.class);
    private IModel RtaCoder;
    private LocalTFModelV2 RtaTFModel;

    public <T> Map<T, Double> predictRta(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            logger.info("featureMap{}, RtaTFModel{}", JSONObject.toJSON(featureMap), JSONObject.toJSON((Object)this.RtaTFModel));
            Map ret = this.RtaCoder.predictWithLocalTFV2(featureMap, this.RtaTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictRta error{}, RtaCoder{}, RtaTFModel{}", new Object[]{e, this.RtaCoder, this.RtaTFModel});
            return null;
        }
    }

    public IModel getRtaCoder() {
        return this.RtaCoder;
    }

    public LocalTFModelV2 getRtaTFModel() {
        return this.RtaTFModel;
    }

    public void setRtaCoder(IModel RtaCoder) {
        this.RtaCoder = RtaCoder;
    }

    public void setRtaTFModel(LocalTFModelV2 RtaTFModel) {
        this.RtaTFModel = RtaTFModel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RTAModel)) {
            return false;
        }
        RTAModel other = (RTAModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IModel this$RtaCoder = this.getRtaCoder();
        IModel other$RtaCoder = other.getRtaCoder();
        if (this$RtaCoder == null ? other$RtaCoder != null : !this$RtaCoder.equals(other$RtaCoder)) {
            return false;
        }
        LocalTFModelV2 this$RtaTFModel = this.getRtaTFModel();
        LocalTFModelV2 other$RtaTFModel = other.getRtaTFModel();
        return !(this$RtaTFModel == null ? other$RtaTFModel != null : !this$RtaTFModel.equals(other$RtaTFModel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RTAModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IModel $RtaCoder = this.getRtaCoder();
        result = result * 59 + ($RtaCoder == null ? 43 : $RtaCoder.hashCode());
        LocalTFModelV2 $RtaTFModel = this.getRtaTFModel();
        result = result * 59 + ($RtaTFModel == null ? 43 : $RtaTFModel.hashCode());
        return result;
    }

    public String toString() {
        return "RTAModel(RtaCoder=" + this.getRtaCoder() + ", RtaTFModel=" + this.getRtaTFModel() + ")";
    }
}

