package cn.com.duiba.nezha.alg.alg.alg;

import cn.com.duiba.nezha.alg.alg.budget.BudgetSmooth;
import cn.com.duiba.nezha.alg.alg.vo.BudgetInfo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;

import java.util.HashMap;
import java.util.Map;

public class BudgetSmoothAlg {
    /**
     * @param advertBudgetInfoMap 广告预算消耗对象Map
     * @return <广告，消耗速度>
     */
    public static <T> Map<T, BudgetSmoothDo> getBudgetRatio(Map<T, BudgetInfo> advertBudgetInfoMap) {

        return BudgetSmooth.getBudgetRatio(advertBudgetInfoMap);
    }


    /**
     * @param advertBudgetInfo 广告预算消耗对象Map
     * @return <广告，消耗速度>
     */
    public static BudgetSmoothDo getBudgetRatio(BudgetInfo advertBudgetInfo) {

        Map<Long, BudgetInfo> advertBudgetInfoMap = new HashMap<>();
        advertBudgetInfoMap.put(1L, advertBudgetInfo);
        Map<Long, BudgetSmoothDo> ret = BudgetSmooth.getBudgetRatio(advertBudgetInfoMap);
        return ret.get(1L);
    }
}
