package cn.com.duiba.nezha.alg.alg.alg;

import cn.com.duiba.nezha.alg.alg.adsupport.NewAdvertSupport;
import cn.com.duiba.nezha.alg.alg.vo.AdvertSupportInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.BiddingStatDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.SupportDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * 新广告扶持算法
 */
public class NewAdvertSupportAlg {

    /**
     * 广告位熔断
     */
    public static <T> Map<T, Double> circuitBreaker(Map<T, AdvertSupportInfoDo> supportAdvertMap) {

        Map<T, Double> ret = new HashMap<>();
        if (AssertUtil.isEmpty(supportAdvertMap)) {
            return ret;
        }
        return NewAdvertSupport.circuitBreaker(supportAdvertMap);

    }


    /**
     * 广告位熔断
     */
    public static Double circuitBreaker(AdvertSupportInfoDo supportAdvert) {

        return NewAdvertSupport.circuitBreaker(supportAdvert);
    }

    /**
     * 广告位熔断
     */
    public static <T> Map<T, SupportDo> circuitBreakerNew(Map<T, AdvertSupportInfoDo> supportAdvertMap) {

        Map<T, SupportDo> ret = new HashMap<>();
        if (AssertUtil.isEmpty(supportAdvertMap)) {
            return ret;
        }
        return NewAdvertSupport.circuitBreakerNew(supportAdvertMap);

    }


    /**
     * 广告位熔断、扶持置信加权因子
     * @param supportAdvert 扶持广告信息对象
     * @return
     */
    public static SupportDo circuitBreakerNew(AdvertSupportInfoDo supportAdvert) {


        return NewAdvertSupport.circuitBreakerNew(supportAdvert);
    }

    /**
     * 扶持权重因子
     */
    public static Double biddingFactor(Double supportAdvertCircuitBreaker,
                                       BudgetSmoothDo budgetSmoothFactor,
                                       Double statCVR,
                                       Double preCVR) {

        return NewAdvertSupport.biddingFactor(supportAdvertCircuitBreaker, budgetSmoothFactor, statCVR, preCVR);

    }


    /**
     * 扶持权重因子
     */
    public static <T> Map<T, Double> biddingFactor(Map<T, Double> supportAdvertCircuitBreakerMap,
                                                   Map<T, BudgetSmoothDo> budgetSmoothFactorMap,
                                                   Map<T, Double> statCVRMap,
                                                   Map<T, Double> preCVRMap) {

        Map<T, Double> ret = new HashMap<>();
        if (AssertUtil.isAnyEmpty(supportAdvertCircuitBreakerMap, statCVRMap, preCVRMap)) {
            return ret;
        }
        return NewAdvertSupport.biddingFactor(supportAdvertCircuitBreakerMap, budgetSmoothFactorMap, statCVRMap, preCVRMap);

    }

    /**
     * 扶持权重因子
     *
     * @param supportDo 扶持加权对象（熔断、置信）
     * @param budgetSmoothDo  预算消耗速度对象
     * @param biddingStatDo  竞价成功率对象
     * @return
     */
    public static Double biddingFactor(SupportDo supportDo,
                                       BudgetSmoothDo budgetSmoothDo,
                                       BiddingStatDo biddingStatDo) {

        return NewAdvertSupport.biddingFactor(supportDo, budgetSmoothDo, biddingStatDo);

    }


    /**
     * 扶持权重因子
     */
    public static <T> Map<T, Double> biddingFactor(Map<T, SupportDo> supportDoMap,
                                                   Map<T, BudgetSmoothDo> budgetSmoothDoMap,
                                                   Map<T, BiddingStatDo> biddingStatDoMap){

        Map<T, Double> ret = new HashMap<>();
        if (AssertUtil.isAnyEmpty(supportDoMap, budgetSmoothDoMap, biddingStatDoMap)) {
            return ret;
        }
        return NewAdvertSupport.biddingFactor(supportDoMap, budgetSmoothDoMap, biddingStatDoMap);

    }




}
