package cn.com.duiba.nezha.alg.alg.budget;

import cn.com.duiba.nezha.alg.alg.alg.BudgetSmoothAlg;
import cn.com.duiba.nezha.alg.alg.vo.BudgetDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetInfo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;

import javax.xml.bind.util.JAXBSource;
import java.time.LocalTime;


public class BudgetSmoothNew {

    /**
     * 【0，23】0~23小时
     */
    public static double[] reqDist = {
            3, 4.5, 5.5, 6.5, 7.5, 9.5,
            13, 17.5, 22, 27, 32, 37,
            43, 48.5, 53.5, 58.5, 63.5, 68.5,
            74, 79.5, 85.5, 91, 96, 100};


    public static Double retDistWeightSum = null;

    static {
        Double hourWeightSum = 0.0;
        for (int i = 0; i < reqDist.length; i++) {
            hourWeightSum += reqDist[i];
        }
        retDistWeightSum = hourWeightSum;
    }

    /**
     * @param advertBudgetInfo     历史累计
     * @param lastAdvertBudgetInfo 上次历史类型
     * @return
     */
    public static BudgetSmoothDo getRatio(BudgetInfo advertBudgetInfo, BudgetInfo lastAdvertBudgetInfo) {
        BudgetSmoothDo ret = null;


        /**
         * 选择 当次预算类型、平滑时段类型
         *
         * 条件：a)合法性校验
         * 条件：b)优先级：预算类型5、4、3、2、1
         * 条件：c)优先级：当前累计>上次类型
         *
         * 步骤：
         * 步骤1、选择，历史累计，合法数据及类型，类型选择：跟进优先级判断
         * 步骤2、选择，上次历史累计，合法数据及类型，类型选择：与步骤1中选择的类型保持一致
         * 步骤3、消耗速度计算（历史累计、实时）
         * 步骤4、判断预算平滑是否开启
         *
         */


        // 步骤1
        BudgetDo budgetDo = getBudgetType(advertBudgetInfo, null);


        // 步骤2
        BudgetDo lastBudgetDo = null;
        if (budgetDo != null) {
            lastBudgetDo = getBudgetType(lastAdvertBudgetInfo, budgetDo.getBudgetType());
            if (lastBudgetDo != null) {

                if (!equals(lastBudgetDo.getPeriodId(), budgetDo.getPeriodId())) {
                    lastBudgetDo = null;
                }
            }
        }

        System.out.println("budDo="+ JSON.toJSONString(budgetDo));
        System.out.println("lastDo="+ JSON.toJSONString(lastBudgetDo));

        return ret;
    }


    public static BudgetDo getBudgetType(BudgetInfo advertBudgetInfo, Long budgetType) {

        BudgetDo ret = null;

        if (advertBudgetInfo != null) {

            // 3 媒体优先
            if (isValid(advertBudgetInfo.getOrientationAndAppBudgetInfo(), budgetType)) {
                ret = advertBudgetInfo.getOrientationAndAppBudgetInfo();
                return ret;
            }
            // 1 2 4 5
            if (isValid(advertBudgetInfo.getOrientationBudgetInfo(), budgetType)) {
                ret = advertBudgetInfo.getOrientationBudgetInfo();
            }

        }

        return ret;
    }


    public static Boolean isValid(BudgetDo advertDo, Long budgetType) {
        Boolean ret = false;

        /**
         * 1、预算平滑类型为空，校验BudgetDo是否合法
         * 2、预算平滑类型不为空，校验BudgetDo是否一致，一致：校验BudgetDo是否合法，不一致：不合法
         */

        if (budgetType == null && advertDo != null) {

            ret = isValid(advertDo);
        }

        if (budgetType != null && advertDo != null) {

            Long reBudgetType = advertDo.getBudgetType();
            if (reBudgetType != null && reBudgetType.equals(budgetType)) {
                ret = isValid(advertDo);
            }
        }
        return ret;
    }

    public static Boolean isValid(BudgetDo advertDo) {
        Boolean ret = true;

        /**
         * 1、基础信息判断：对象不为空、对象（预算类型、预算、时间、平滑类型）不为空
         * 不合法，返回false
         */
        if (advertDo == null || AssertUtil.isAnyEmpty(
                advertDo.getBudgetType(),
                advertDo.getBudget(),
                advertDo.getTime(),
                advertDo.getTimeType()
        )) {
            return false;
        }

        /**
         * 2、预算：是否不限
         * 预算<20元，不合法，返回false
         */

        if (advertDo.getBudget() == null || advertDo.getBudget() < 2000L) {
            return false;
        }

        /**
         * 3、如果类型为4 or 5：时段信息不为空
         * 不合法，返回false
         */
        if (advertDo.getBudgetType().equals(4L) || advertDo.getBudgetType().equals(5L)) {
            if (AssertUtil.isAnyEmpty(advertDo.getStartTime(), advertDo.getEndTime())) {
                return false;
            }
        }

        /**
         * 4、如果时段类型为1，2，时段信息不为空
         * 不合法，返回 false
         *
         */

        if (advertDo.getTimeType().equals(1L) || advertDo.getTimeType().equals(2L)) {
            if (AssertUtil.isAnyEmpty(advertDo.getStartTime(), advertDo.getEndTime())) {
                return false;
            }
        }


        return ret;
    }


    /**
     * 预算平滑消耗速度对象
     *
     * @param budgetDo
     * @param lastBudgetDo
     * @return
     */
    public static BudgetSmoothDo getBudgetSmooth(BudgetDo budgetDo, BudgetDo lastBudgetDo) {
        BudgetSmoothDo ret = null;

        Long budgetType = null;

        Long timeType = null;

        Double ratio = null;

        Double timeRatio = null;

        Double budgetRatio = null;


        Double currentRatio = null;

        Double currentTimeRatio = null;

        Double currentBudgetRatio = null;

        Boolean isSmooth = false;


        if (budgetDo != null) {


            ret = new BudgetSmoothDo();
            budgetType = budgetDo.getBudgetType();
            timeType = budgetDo.getTimeType();

            if (timeType.equals(3L)) {
                timeRatio = getTimeRatio(budgetDo.getTime());

            } else {
                timeRatio = getTimeRatio(budgetDo.getTime(), budgetDo.getStartTime(), budgetDo.getEndTime());
            }

            budgetRatio = getBudgetRatio(budgetDo.getBudget(), budgetDo.getConsumeTotal());


            ratio = getRatio(budgetRatio, timeRatio);


            if (lastBudgetDo != null) {

                Double lastTimeRatio = getTimeRatio(lastBudgetDo.getTime(), lastBudgetDo.getStartTime(), lastBudgetDo.getEndTime());
                Double lastBudgetRatio = getBudgetRatio(lastBudgetDo.getBudget(), lastBudgetDo.getConsumeTotal());

                currentTimeRatio = DataUtil.addDouble(timeRatio, -1 * lastTimeRatio);

                currentBudgetRatio = DataUtil.addDouble(budgetRatio, -1 * lastBudgetRatio);

                currentRatio = getRatio(currentBudgetRatio, currentTimeRatio);

            }

            ret.setBudgetDo(budgetDo);
            ret.setBudgetRatio(budgetRatio);
            ret.setTimeRatio(timeRatio);

            ret.setLastBudgetDo(budgetDo);
            ret.setCurrentBudgetRatio(currentBudgetRatio);
            ret.setCurrentTimeRatio(currentTimeRatio);


            ret.setTimeType(timeType);
            ret.setBudgetType(budgetType);


            if (isTimeValid(budgetDo.getTime(), budgetDo.getStartTime(), budgetDo.getEndTime(), timeRatio, timeType)) {
                ret.setRatio(ratio);
                ret.setCurrentRatio(currentRatio);
                ret.setIsSmooth(true);
            } else {
                ret.setIsSmooth(false);
            }

        }


//        System.out.println(JSON.toJSONString(ret));
        return ret;
    }


    /**
     * 消耗速度
     */
    public static Double getRatio(Double budgetRatio, Double timeRatio) {
        Double ret = null;

        if (budgetRatio != null && timeRatio != null && timeRatio > 0 && budgetRatio > 0) {
            ret = DataUtil.division(budgetRatio, timeRatio, 5);
        }
        return ret;
    }

    /**
     * @return 预算速度
     */
    public static Double getBudgetRatio(Long budget, Long consumeTotal) {
        Double ret = null;
        if (budget != null && consumeTotal != null && budget > 10) {

            Long consume = Math.max(1, consumeTotal);
            ret = DataUtil.division(consume, budget, 5);
            ret = Math.min(ret, 1.0);
        }
        return ret;
    }

    /**
     * @param updateTime
     * @return 时间速度
     */
    public static Double getTimeRatio(String updateTime) {

        return getTimeRatio(updateTime, "00:00", "24:00");
    }


    /**
     * 时间消耗速度
     *
     * @param updateTime
     * @param startTime
     * @param endTime
     * @return
     */
    public static Double getTimeRatio(String updateTime, String startTime, String endTime) {
        Double ret = null;

        Double timeRatioS2E = getTimeRatio(startTime, endTime);
        Double timeRatioS2U = getTimeRatio(startTime, updateTime);

        if (timeRatioS2E != null && timeRatioS2U != null) {
            ret = DataUtil.division(timeRatioS2U, timeRatioS2E, 5);

            if (ret != null && ret > 1.01) {
                ret = null;
            }
        }


        return ret;
    }

    /**
     * 时间（流量）消耗速度
     *
     * @param startTime
     * @param endTime
     * @return
     */
    public static Double getTimeRatio(String startTime, String endTime) {
        Double ret = null;

        LocalTime startTimeLT = LocalDateUtil.getLocalTime(startTime, DateStyle.HH_MM.getValue());
        LocalTime endTimeLT = LocalDateUtil.getLocalTime(endTime, DateStyle.HH_MM.getValue());

        if (startTimeLT != null && endTimeLT != null && endTimeLT.isAfter(startTimeLT)) {

            Double startRatio = getTimeRatio(startTimeLT.getHour(), startTimeLT.getMinute());

            Double endRatio = getTimeRatio(endTimeLT.getHour(), endTimeLT.getMinute());

            ret = DataUtil.addDouble(endRatio, -1 * startRatio, 5);

        }
        return ret;
    }


    /**
     * 时间（流量）消耗速度-累计
     *
     * @param hour
     * @return
     */
    public static Double getTimeRatio(int hour, int minute) {
        Double ret = null;

        double hourWeight = 0.0;
        double minuteWeight = 0.0;
        for (int i = 0; i < hour; i++) {
            hourWeight += reqDist[i];
        }
        if (hour < 24) {
            minuteWeight = reqDist[hour] * (minute + 0.0) / 60;
        }
        ret = DataUtil.division(hourWeight + minuteWeight, retDistWeightSum);
        return DataUtil.formatDouble(ret, 5);
    }


    /**
     * @param updateTime
     * @return 时间速度
     */
    public static boolean isTimeValid(String updateTime, String startTime, String endTime, Double timeRatio, Long timeType) {
        boolean ret = true;
        LocalTime updateTimeLocal = LocalDateUtil.getLocalTime(updateTime, DateStyle.HH_MM.getValue());
        LocalTime startTimeLocal = LocalDateUtil.getLocalTime(startTime, DateStyle.HH_MM.getValue());
        LocalTime endTimeLocal = LocalDateUtil.getLocalTime(endTime, DateStyle.HH_MM.getValue());
        LocalTime currentTimeLocal = LocalTime.now();

        /**
         * 合法逻辑
         * a、值均有效
         *
         * a、当前时间在投放区间内
         *
         * b、时间（流量）消耗在90%内（时段），95%内（日）
         *
         * c、当前时间与更新时间差5分钟内
         */

        // a
        if (AssertUtil.isAnyEmpty(updateTimeLocal, startTimeLocal, endTimeLocal, timeType, timeRatio)) {
            ret = false;
        }

        if (currentTimeLocal.isAfter(endTimeLocal) || currentTimeLocal.isBefore(startTimeLocal)) {
            ret = false;
        }
        if (timeType.equals(3L) && timeRatio > 0.95) {
            ret = false;
        }
        if (timeType.equals(2L) && timeRatio > 0.9) {
            ret = false;
        }

        if (timeType.equals(1L) && timeRatio > 0.9) {
            ret = false;
        }

        return ret;
    }


    public static Boolean equals(Long a, Long b) {
        Boolean ret = false;
        if (AssertUtil.isAllEmpty(a, b)) {
            ret = true;
        } else if (AssertUtil.isAnyEmpty(a, b)) {
            ret = false;
        } else if (a.equals(b)) {
            ret = true;
        }

        return ret;
    }

    public static void main(String[] args) {
        BudgetInfo budget = new BudgetInfo();

////
        BudgetDo ad = new BudgetDo();
        ad.setBudget(200000L);
        ad.setConsumeTotal(109999L);
        ad.setPeriodId(null);
        ad.setStartTime("");
        ad.setEndTime("");
        ad.setBudgetType(1L);
        ad.setTimeType(3L);
        ad.setTime("08:46");
        budget.setOrientationBudgetInfo(ad);

        BudgetDo app = new BudgetDo();
        app.setBudget(200000L);
        app.setConsumeTotal(109999L);
        app.setPeriodId(null);
        app.setStartTime("");
        app.setEndTime(null);
        app.setBudgetType(3L);
        app.setTimeType(2L);
        app.setTime("09:46");
        budget.setOrientationAndAppBudgetInfo(app);


        System.out.println(BudgetSmoothAlg.getBudgetRatio(budget,null));


//
//        // 配置时段 3
//        BudgetDo at = new BudgetDo();
//        at.setBudget(10000L);
//        at.setConsumeTotal(60L);
//        at.setPeriodId(76497L);
//        at.setTime("2018-12-10 16:37:20");
//        at.setStartTime("16:00");
//        at.setEndTime("16:59");
//        budget.setOrientationAndTimeBudgetInfo(at);
//        BudgetSmoothDo ret = getRatio(budget);
//
////        for (int ii = 0; ii < 20; ii++) {
////            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS.getValue()));
////            for (int i = 0; i < 1000; i++) {
////                getRatio(budget);
////            }
////        }
//
//        System.out.println("ret = " + JSON.toJSONString(ret));
//
//
//        BudgetInfo budgetInfo = new BudgetInfo();
//        budgetInfo.setAdvertBudgetInfo(JSON.parseObject("{\"time\":\"2018-12-11 11:38:30\",\"type\":\"6\",\"advertId\":40037,\"budget\":200000,\"consumeTotal\":100375}", BudgetDo.class));
//
//        budgetInfo.setOrientationBudgetInfo(JSON.parseObject("{\"planId\":77214,\"time\":\"2018-12-11 11:38:30\",\"type\":\"5\",\"advertId\":40037,\"budget\":100000,\"consumeTotal\":9460}", BudgetDo.class));
//
//        budgetInfo.setOrientationAndTimeBudgetInfo(JSON.parseObject("{\"periodId\":201638,\"planId\":77214,\"startTime\":\"11:00\",\"time\":\"2018-12-11 11:36:16\",\"endTime\":\"11:59\",\"type\":\"3\",\"advertId\":40037,\"budget\":10000,\"consumeTotal\":1020}", BudgetDo.class));
//
//        System.out.println(BudgetSmoothAlg.getBudgetRatio(budgetInfo).getRatio());

    }
}
