/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.budget;

import cn.com.duiba.nezha.alg.alg.alg.BudgetSmoothAlg;
import cn.com.duiba.nezha.alg.alg.vo.BudgetDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.SmoothResultDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import java.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BudgetSmoothNew {
    private static final Logger logger = LoggerFactory.getLogger(BudgetSmoothNew.class);
    public static double[] reqDist = new double[]{108.0, 60.0, 40.0, 30.0, 40.0, 70.0, 140.0, 165.0, 175.0, 155.0, 170.0, 185.0, 205.0, 175.0, 155.0, 150.0, 165.0, 190.0, 2054.0, 230.0, 234.0, 197.0, 155.0, 100.0};
    public static Double retDistWeightSum = null;

    public static BudgetSmoothDo getRatio(BudgetDo budgetDo, BudgetSmoothDo lastBudgetSmoothDo) {
        BudgetSmoothDo ret = new BudgetSmoothDo();
        if (budgetDo != null && !BudgetSmoothNew.isValid(budgetDo).booleanValue()) {
            logger.warn("BudgetSmoothNew.getRatio(BudgetDo budgetDo, BudgetSmoothDo lastBudgetSmoothDo)  input invalid ,budgetDo=" + JSON.toJSONString((Object)budgetDo));
            budgetDo = null;
        }
        BudgetDo lastBudgetDo = null;
        if (lastBudgetSmoothDo != null) {
            lastBudgetDo = BudgetSmoothNew.getLastBudgetDo(budgetDo, lastBudgetSmoothDo.getBudgetDo());
        }
        try {
            ret = BudgetSmoothNew.getBudgetSmooth(budgetDo, lastBudgetDo);
        }
        catch (Exception e) {
            logger.warn("BudgetSmoothNew.getRatio  getBudgetSmooth happend error,lastBudgetSmoothDo={}", (Object)JSON.toJSONString((Object)lastBudgetSmoothDo), (Object)e);
        }
        BudgetSmoothNew.updateSmoothFactor2(ret);
        return ret;
    }

    public static BudgetDo getLastBudgetDo(BudgetDo budgetDo, BudgetDo lastBudgetDo) {
        BudgetDo ret = null;
        if (BudgetSmoothNew.lastResultValid(budgetDo, lastBudgetDo).booleanValue()) {
            ret = lastBudgetDo;
        }
        return ret;
    }

    public static Boolean lastResultValid(BudgetDo budgetDo, BudgetDo lastBudgetDo) {
        Boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{budgetDo, lastBudgetDo})) {
            return false;
        }
        if (!BudgetSmoothNew.isValid(lastBudgetDo).booleanValue()) {
            return false;
        }
        if (!budgetDo.getTimeType().equals(lastBudgetDo.getTimeType())) {
            return false;
        }
        if (!budgetDo.getBudgetType().equals(lastBudgetDo.getBudgetType())) {
            return false;
        }
        if (!budgetDo.getBudget().equals(lastBudgetDo.getBudget())) {
            return false;
        }
        if (!budgetDo.getTimeType().equals(3L)) {
            if (!budgetDo.getStartTime().equals(lastBudgetDo.getStartTime())) {
                return false;
            }
            if (!budgetDo.getEndTime().equals(lastBudgetDo.getEndTime())) {
                return false;
            }
        }
        return ret;
    }

    public static Boolean isValid(BudgetDo advertDo) {
        Boolean ret = true;
        if (advertDo == null || AssertUtil.isAnyEmpty((Object[])new Object[]{advertDo.getBudgetType(), advertDo.getBudget(), advertDo.getTime(), advertDo.getTimeType()})) {
            return false;
        }
        if (advertDo.getBudget() == null || advertDo.getBudget() < 2000L) {
            return false;
        }
        if (advertDo.getBudgetType().equals(4L) || advertDo.getBudgetType().equals(5L)) {
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertDo.getStartTime(), advertDo.getEndTime()})) {
                return false;
            }
            if (advertDo.getTimeType().equals(3L)) {
                return false;
            }
        }
        if (advertDo.getTimeType().equals(1L) || advertDo.getTimeType().equals(2L)) {
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertDo.getStartTime(), advertDo.getEndTime()})) {
                return false;
            }
            if (advertDo.getEndTime().equals("24:00")) {
                advertDo.setEndTime("23:59");
            }
            LocalTime updateTimeLocal = LocalDateUtil.getLocalTime((String)advertDo.getTime(), (String)DateStyle.HH_MM.getValue());
            LocalTime startTimeLocal = LocalDateUtil.getLocalTime((String)advertDo.getStartTime(), (String)DateStyle.HH_MM.getValue());
            LocalTime endTimeLocal = LocalDateUtil.getLocalTime((String)advertDo.getEndTime(), (String)DateStyle.HH_MM.getValue());
            LocalTime currentTimeLocal = LocalTime.now();
            if (updateTimeLocal.isAfter(endTimeLocal) || updateTimeLocal.isBefore(startTimeLocal)) {
                return false;
            }
            if (currentTimeLocal.isAfter(endTimeLocal) || currentTimeLocal.isBefore(startTimeLocal)) {
                return false;
            }
        }
        return ret;
    }

    public static BudgetSmoothDo getBudgetSmooth(BudgetDo budgetDo, BudgetDo lastBudgetDo) {
        BudgetSmoothDo ret = new BudgetSmoothDo();
        Long budgetType = null;
        Long timeType = null;
        Double ratio = null;
        Double timeRatio = null;
        Double budgetRatio = null;
        Double currentRatio = null;
        Double currentTimeRatio = null;
        Double currentBudgetRatio = null;
        Boolean currentValid = false;
        Boolean isSmooth = false;
        Boolean valid = false;
        if (budgetDo != null) {
            budgetType = budgetDo.getBudgetType();
            timeType = budgetDo.getTimeType();
            valid = true;
            timeRatio = timeType.equals(3L) ? BudgetSmoothNew.getTimeRatio(budgetDo.getTime()) : BudgetSmoothNew.getTimeRatio(budgetDo.getTime(), budgetDo.getStartTime(), budgetDo.getEndTime());
            budgetRatio = BudgetSmoothNew.getBudgetRatio(budgetDo.getBudget(), budgetDo.getConsumeTotal());
            ratio = BudgetSmoothNew.getRatio(budgetRatio, timeRatio);
            if (lastBudgetDo != null) {
                Double lastTimeRatio = null;
                lastTimeRatio = timeType.equals(3L) ? BudgetSmoothNew.getTimeRatio(lastBudgetDo.getTime()) : BudgetSmoothNew.getTimeRatio(lastBudgetDo.getTime(), lastBudgetDo.getStartTime(), lastBudgetDo.getEndTime());
                Double lastBudgetRatio = BudgetSmoothNew.getBudgetRatio(lastBudgetDo.getBudget(), lastBudgetDo.getConsumeTotal());
                currentTimeRatio = DataUtil.addDouble((Double)timeRatio, (Double)(-1.0 * lastTimeRatio), (int)7);
                currentBudgetRatio = DataUtil.addDouble((Double)budgetRatio, (Double)(-1.0 * lastBudgetRatio), (int)7);
                currentRatio = BudgetSmoothNew.getRatio(currentBudgetRatio, currentTimeRatio);
                if (currentTimeRatio > 0.0) {
                    currentValid = true;
                }
            }
            if (!BudgetSmoothNew.isTimeValid(budgetDo.getTime(), timeRatio, timeType)) {
                ratio = null;
                currentRatio = null;
                isSmooth = false;
            } else {
                isSmooth = true;
            }
        }
        ret.setBudgetDo(budgetDo);
        ret.setBudgetRatio(budgetRatio);
        ret.setTimeRatio(timeRatio);
        ret.setCurrentBudgetRatio(currentBudgetRatio);
        ret.setCurrentTimeRatio(currentTimeRatio);
        ret.setTimeType(timeType);
        ret.setBudgetType(budgetType);
        ret.setRatio(ratio);
        ret.setCurrentValid(currentValid);
        ret.setCurrentRatio(currentRatio);
        ret.setNeedSmooth(isSmooth);
        ret.setValid(valid);
        return ret;
    }

    public static Double getRatio(Double budgetRatio, Double timeRatio) {
        Double ret = null;
        if (budgetRatio != null && timeRatio != null && timeRatio > 0.0 && budgetRatio >= 0.0) {
            ret = DataUtil.division((Double)budgetRatio, (Double)timeRatio, (int)5);
        }
        return ret;
    }

    public static Double getBudgetRatio(Long budget, Long consumeTotal) {
        Double ret = null;
        if (budget != null && consumeTotal != null && budget > 10L) {
            Long consume = Math.max(1L, consumeTotal);
            ret = DataUtil.division((Long)consume, (Long)budget, (int)5);
            ret = Math.min(ret, 1.0);
        }
        return ret;
    }

    public static Double getTimeRatio(String updateTime) {
        return BudgetSmoothNew.getTimeRatio(updateTime, "00:00", "23:59");
    }

    public static Double getTimeRatio(String updateTime, String startTime, String endTime) {
        Double ret = null;
        if (endTime != null && endTime.equals("24:00")) {
            endTime = "23:59";
        }
        Double timeRatioS2E = BudgetSmoothNew.getTimeRatio(startTime, endTime);
        Double timeRatioS2U = BudgetSmoothNew.getTimeRatio(startTime, updateTime);
        if (timeRatioS2E != null && timeRatioS2U != null && timeRatioS2E >= timeRatioS2U) {
            ret = DataUtil.division((Double)timeRatioS2U, (Double)timeRatioS2E, (int)5);
        }
        return ret;
    }

    public static Double getTimeRatio(String startTime, String endTime) {
        Double ret = 0.0;
        LocalTime startTimeLT = LocalDateUtil.getLocalTime((String)startTime, (String)DateStyle.HH_MM.getValue());
        LocalTime endTimeLT = LocalDateUtil.getLocalTime((String)endTime, (String)DateStyle.HH_MM.getValue());
        if (startTimeLT != null && endTimeLT != null && endTimeLT.isAfter(startTimeLT)) {
            Double startRatio = BudgetSmoothNew.getTimeRatio(startTimeLT.getHour(), startTimeLT.getMinute());
            Double endRatio = BudgetSmoothNew.getTimeRatio(endTimeLT.getHour(), endTimeLT.getMinute());
            ret = DataUtil.addDouble((Double)endRatio, (Double)(-1.0 * startRatio), (int)5);
        }
        return ret;
    }

    public static Double getTimeRatio(int hour, int minute) {
        Double ret = null;
        double hourWeight = 0.0;
        double minuteWeight = 0.0;
        for (int i = 0; i < hour; ++i) {
            hourWeight += reqDist[i];
        }
        if (hour < 24) {
            minuteWeight = reqDist[hour] * ((double)minute + 0.0) / 60.0;
        }
        ret = DataUtil.division((Double)(hourWeight + minuteWeight), (Double)retDistWeightSum);
        return DataUtil.formatDouble((Double)ret, (int)5);
    }

    public static boolean isTimeValid(String updateTime, Double timeRatio, Long timeType) {
        boolean ret = true;
        LocalTime updateTimeLocal = LocalDateUtil.getLocalTime((String)updateTime, (String)DateStyle.HH_MM.getValue());
        LocalTime currentTimeLocal = LocalTime.now();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{timeType, timeRatio})) {
            return false;
        }
        if (timeType.equals(3L) && timeRatio > 0.95) {
            return false;
        }
        if (timeType.equals(2L) && timeRatio > 0.9) {
            return false;
        }
        if (timeType.equals(1L) && timeRatio > 0.9) {
            return false;
        }
        if (LocalDateUtil.getBetweenSeconds((LocalTime)updateTimeLocal, (LocalTime)currentTimeLocal) > 600L) {
            return false;
        }
        return ret;
    }

    public static Boolean equals(Long a, Long b) {
        Boolean ret = false;
        if (AssertUtil.isAllEmpty((Object[])new Object[]{a, b})) {
            ret = true;
        } else if (AssertUtil.isAnyEmpty((Object[])new Object[]{a, b})) {
            ret = false;
        } else if (a.equals(b)) {
            ret = true;
        }
        return ret;
    }

    public static void updateSmoothFactor2(BudgetSmoothDo budgetSmoothDo) {
        if (budgetSmoothDo == null) {
            return;
        }
        Double ret = 1.0;
        Double smoothFactor = budgetSmoothDo.getSmoothFactor();
        if (smoothFactor == null) {
            smoothFactor = 1.0;
        }
        if (budgetSmoothDo.getNeedSmooth().booleanValue() && budgetSmoothDo.getRatio() != null && budgetSmoothDo.getRatio() > 1.05) {
            Double totalFactor = 0.6 + 0.4 * (1.0 / BudgetSmoothNew.noiseSmoother(budgetSmoothDo.getRatio(), 0.1, 10.0));
            Double currentFactor = 1.0;
            if (budgetSmoothDo.getCurrentValid().booleanValue() && budgetSmoothDo.getCurrentRatio() != null) {
                currentFactor = 0.7 + 0.3 * (1.0 / BudgetSmoothNew.noiseSmoother(budgetSmoothDo.getCurrentRatio(), 0.1, 10.0));
            }
            ret = smoothFactor * BudgetSmoothNew.noiseSmoother(currentFactor, 0.1, 3.0) * BudgetSmoothNew.noiseSmoother(totalFactor, 0.2, 2.0);
            budgetSmoothDo.setTimes(budgetSmoothDo.getTimes() + 1L);
        } else {
            budgetSmoothDo.setTimes(0L);
        }
        ret = BudgetSmoothNew.noiseSmoother(ret, 0.1, 1.0);
        ret = DataUtil.formatDouble((Double)ret, (int)5);
        budgetSmoothDo.setSmoothFactor(ret);
    }

    public static Double updateSmoothFactor(BudgetSmoothDo budgetSmoothDo) {
        Double ret = 1.0;
        if (budgetSmoothDo == null) {
            return 1.0;
        }
        Double smoothFactor = budgetSmoothDo.getSmoothFactor();
        if (smoothFactor == null) {
            smoothFactor = 1.0;
        }
        if (budgetSmoothDo.getNeedSmooth().booleanValue() && budgetSmoothDo.getRatio() != null && budgetSmoothDo.getRatio() > 1.05) {
            Double totalFactor = 0.6 + 0.4 * (1.0 / BudgetSmoothNew.noiseSmoother(budgetSmoothDo.getRatio(), 0.1, 10.0));
            Double currentFactor = 1.0;
            if (budgetSmoothDo.getCurrentValid().booleanValue() && budgetSmoothDo.getCurrentRatio() != null) {
                currentFactor = 0.7 + 0.3 * (1.0 / BudgetSmoothNew.noiseSmoother(budgetSmoothDo.getCurrentRatio(), 0.1, 10.0));
            }
            smoothFactor = smoothFactor * BudgetSmoothNew.noiseSmoother(currentFactor, 0.1, 3.0) * BudgetSmoothNew.noiseSmoother(totalFactor, 0.2, 2.0);
        }
        smoothFactor = BudgetSmoothNew.noiseSmoother(smoothFactor, 0.1, 1.0);
        ret = DataUtil.formatDouble((Double)smoothFactor, (int)5);
        return ret;
    }

    public static Double noiseSmoother(Double point, Double lowerLimit, Double upperLimit) {
        Double ret = point;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{upperLimit, lowerLimit})) {
            return ret;
        }
        if (point != null) {
            ret = point > upperLimit ? upperLimit : (point < lowerLimit ? lowerLimit : point);
        }
        return ret;
    }

    public static SmoothResultDo getSmooth(BudgetSmoothDo budgetSmoothDo) {
        SmoothResultDo ret = new SmoothResultDo();
        ret.setGiveUp(false);
        if (AssertUtil.isNotEmpty((Object)budgetSmoothDo)) {
            Double smoothFactor = budgetSmoothDo.getSmoothFactor();
            if (smoothFactor != null && smoothFactor < 1.0 && budgetSmoothDo.getNeedSmooth() != null && budgetSmoothDo.getNeedSmooth().booleanValue() && Math.random() > smoothFactor) {
                ret.setGiveUp(true);
            }
            if (budgetSmoothDo.getBudgetDo() != null) {
                ret.setAdvertId(budgetSmoothDo.getBudgetDo().getAdvertId());
                ret.setPlanId(budgetSmoothDo.getBudgetDo().getPlanId());
            }
            ret.setNeedSmooth(budgetSmoothDo.getNeedSmooth());
            ret.setSmoothFactor(smoothFactor);
            ret.setBudgetType(budgetSmoothDo.getBudgetType());
            ret.setTimeType(budgetSmoothDo.getTimeType());
            ret.setRatio(budgetSmoothDo.getRatio());
            ret.setBudgetRatio(budgetSmoothDo.getBudgetRatio());
            ret.setTimeRatio(budgetSmoothDo.getTimeRatio());
            ret.setValid(budgetSmoothDo.getValid());
        }
        return ret;
    }

    public static void main(String[] args) {
        String adStr = "{\"advertId\":40017,\"budget\":400000,\"budgetType\":5,\"consumeTotal\":304900,\"endTime\":\"17:59\",\"periodId\":252497,\"planId\":77093,\"startTime\":\"10:00\",\"time\":\"14:33\",\"timeType\":2}";
        BudgetDo ad = (BudgetDo)JSON.parseObject((String)adStr, BudgetDo.class);
        BudgetSmoothDo budgetSmoothDo = BudgetSmoothAlg.getBudgetRatio(ad, null);
        System.out.println("1" + JSON.toJSONString((Object)budgetSmoothDo));
        BudgetDo ad1 = (BudgetDo)JSON.parseObject((String)adStr, BudgetDo.class);
        ad1.setTime("15:53");
        ad1.setConsumeTotal(ad1.getConsumeTotal() + 10000L);
        budgetSmoothDo = BudgetSmoothAlg.getBudgetRatio(ad1, budgetSmoothDo);
        System.out.println("2" + JSON.toJSONString((Object)budgetSmoothDo));
        BudgetDo ad2 = (BudgetDo)JSON.parseObject((String)adStr, BudgetDo.class);
        ad2.setTime("15:54");
        ad2.setConsumeTotal(ad2.getConsumeTotal() + 20000L);
        budgetSmoothDo = BudgetSmoothAlg.getBudgetRatio(ad2, budgetSmoothDo);
        System.out.println("3" + JSON.toJSONString((Object)budgetSmoothDo));
        BudgetDo ad3 = (BudgetDo)JSON.parseObject((String)adStr, BudgetDo.class);
        ad3.setTime("15:55");
        ad3.setConsumeTotal(ad3.getConsumeTotal() + 30000L);
        budgetSmoothDo = BudgetSmoothAlg.getBudgetRatio(ad3, budgetSmoothDo);
        System.out.println("4" + JSON.toJSONString((Object)budgetSmoothDo));
        SmoothResultDo ret = BudgetSmoothAlg.getSmoothRatio(budgetSmoothDo, new BudgetSmoothDo());
        System.out.println(JSON.toJSONString((Object)ret));
    }

    static {
        Double hourWeightSum = 0.0;
        for (int i = 0; i < reqDist.length; ++i) {
            hourWeightSum = hourWeightSum + reqDist[i];
        }
        retDistWeightSum = hourWeightSum;
    }
}

