/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.vo.AdxDo;

public class AdxBidding {
    public static Long getAdxParPrice(AdxDo adxDoInfo) {
        Double preCtr;
        Long parPrice = null;
        Double currentPreValue = adxDoInfo.getCurrentPreValue();
        Double statCtr = adxDoInfo.getStatCtr();
        Double statClickValue = adxDoInfo.getStatClickValue();
        Double minRoi = adxDoInfo.getMinRoi();
        Double adxBiddingRoiFactor = 1.1;
        if (statClickValue == null || statClickValue <= 0.0) {
            statClickValue = 8.0;
        }
        if (minRoi == null || minRoi < 1.0) {
            minRoi = 1.0;
        }
        if ((preCtr = AdxBidding.getPreCTR(currentPreValue, statCtr)) != null && preCtr > 0.0) {
            parPrice = Math.round(Math.floor(preCtr * statClickValue * 1000.0 / (minRoi * adxBiddingRoiFactor)));
        }
        return parPrice;
    }

    public static Double getPreCTR(Double modelPreValue, Double statValue) {
        Double ret = null;
        Double preCtrFactor = 0.0;
        Double vUpperLimit = 0.9999;
        Double vLowerLimit = 0.0;
        Double fUpperLimit = 3.0;
        Double fLowerLimit = 0.2;
        if (statValue == null) {
            statValue = 0.1;
        } else if (statValue < vLowerLimit || statValue > vUpperLimit) {
            statValue = 0.1;
        }
        ret = modelPreValue == null ? statValue : (modelPreValue / statValue > fLowerLimit && modelPreValue / statValue < fUpperLimit ? Double.valueOf(preCtrFactor * modelPreValue + (1.0 - preCtrFactor) * statValue) : statValue);
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxDo adxDoInfo = new AdxDo();
            adxDoInfo.setCurrentPreValue(0.02);
            adxDoInfo.setStatCtr(0.12);
            adxDoInfo.setStatClickValue(0.0);
            adxDoInfo.setMinRoi(0.9);
            Long testParPrice = AdxBidding.getAdxParPrice(adxDoInfo);
            System.out.println("testGetAdxParPrice:" + testParPrice);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

