/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.title;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.title.ActTitleStatModel;
import cn.com.duiba.nezha.alg.alg.vo.title.ActTitleRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.title.ActTitleStatDo;
import cn.com.duiba.nezha.alg.alg.vo.title.RecallActTitleDo;
import cn.com.duiba.nezha.alg.alg.vo.title.RecallActTitleInfoDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.ActTitleFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.ActTitleFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActTitleDQNRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActTitleDQNRcmder.class);
    private static long ADX_MULTIPLIER = 10000000L;
    private static int MAP_DF_SIZE = 8;
    static double[] pCpmBucket = new double[]{0.5, 0.8, 0.9, 0.95, 0.98, 1.0};
    static double[] pCpmWeight = new double[]{0.1, 1.0, 2.0, 10.0, 20.0, 100.0};

    public static Map<String, String> featureParse(ActTitleFeatureDo actFeatureDo) {
        Map staticFeatureMap = ActTitleFeatureParse.generateFeatureMapStatic((ActTitleFeatureDo)actFeatureDo);
        Map dynamicFeatureMap = ActTitleFeatureParse.generateFeatureMapDynamic((ActTitleFeatureDo)actFeatureDo, (ActTitleFeatureDo)actFeatureDo);
        dynamicFeatureMap.putAll(staticFeatureMap);
        return dynamicFeatureMap;
    }

    /*
     * WARNING - void declaration
     */
    public static ActTitleRcmdDo rcmd2(CODER coderModel, LocalTFModel ltfModel, RecallActTitleDo recallActTitleDo, List<ActTitleStatDo> actTitleStatDoList, List<ActTitleStatDo> actSubTitleStatDoList, List<ActTitleStatDo> actSlotTitleStatDoList, List<ActTitleStatDo> actSlotSubTitleStatDoList, ActTitleFeatureDo actTitleFeatureDo, boolean hasSubTitle) throws Exception {
        ActTitleRcmdDo ret = null;
        if (ActTitleDQNRcmder.valid(recallActTitleDo, actTitleFeatureDo).booleanValue()) {
            HashMap<String, Map> featureMap = new HashMap<String, Map>();
            ArrayList<ActTitleRcmdDo> actTitleRcmdDoList = new ArrayList<ActTitleRcmdDo>();
            Map staticFeatureMap = ActTitleFeatureParse.generateFeatureMapStatic((ActTitleFeatureDo)actTitleFeatureDo);
            HashMap<Long, ActTitleStatDo> actSlotTitleStatDoMap = new HashMap<Long, ActTitleStatDo>();
            if (AssertUtil.isNotEmpty(actSlotTitleStatDoList)) {
                for (ActTitleStatDo actTitleStatDo : actSlotTitleStatDoList) {
                    if (actTitleStatDo == null) continue;
                    actSlotTitleStatDoMap.put(actTitleStatDo.getTitleId(), actTitleStatDo);
                }
            }
            HashMap<Long, ActTitleStatDo> actSlotSubTitleStatDoMap = new HashMap<Long, ActTitleStatDo>();
            if (AssertUtil.isNotEmpty(actSlotSubTitleStatDoList)) {
                for (ActTitleStatDo actTitleStatDo : actSlotSubTitleStatDoList) {
                    if (actTitleStatDo == null) continue;
                    actSlotSubTitleStatDoMap.put(actTitleStatDo.getTitleId(), actTitleStatDo);
                }
            }
            for (RecallActTitleInfoDo recallActTitleInfoDo : recallActTitleDo.getRecallActTitleInfoDo()) {
                recallActTitleInfoDo.setKey();
                String key = recallActTitleInfoDo.getKey();
                Long activityTitleId = recallActTitleInfoDo.getActivityTitleId();
                Long activitySubTitleId = recallActTitleInfoDo.getActivitySubTitleId();
                ActTitleRcmdDo actTitleRcmdDo = new ActTitleRcmdDo();
                actTitleRcmdDo.setKey(key);
                actTitleRcmdDo.setActivityTitleId(activityTitleId);
                actTitleRcmdDo.setActivitySubTitleId(activitySubTitleId);
                actTitleRcmdDo.setScore1(recallActTitleInfoDo.getScore1());
                actTitleRcmdDo.setRank1(recallActTitleInfoDo.getRank1());
                actTitleRcmdDo.setScore2(recallActTitleInfoDo.getScore2());
                actTitleRcmdDo.setRank2(recallActTitleInfoDo.getRank2());
                actTitleRcmdDo.setScore3(recallActTitleInfoDo.getScore3());
                actTitleRcmdDo.setRank3(recallActTitleInfoDo.getRank3());
                actTitleRcmdDo.setHasType(recallActTitleInfoDo.getHasType());
                ActTitleStatDo actTitleStatDo = (ActTitleStatDo)actSlotTitleStatDoMap.get(activityTitleId);
                actTitleRcmdDo.setsRpm(ActTitleStatModel.getRpm(actTitleStatDo));
                actTitleRcmdDo.setJpv(ActTitleStatModel.getJpv(actTitleStatDo));
                actTitleRcmdDo.setCpv(ActTitleStatModel.getCpv(actTitleStatDo));
                actTitleRcmdDo.setApv(ActTitleStatModel.getApv(actTitleStatDo));
                ActTitleStatDo actTitleSubStatDo = (ActTitleStatDo)actSlotTitleStatDoMap.get(activitySubTitleId);
                actTitleRcmdDo.setSubSRpm(ActTitleStatModel.getRpm(actTitleSubStatDo));
                actTitleRcmdDo.setSubJpv(ActTitleStatModel.getJpv(actTitleSubStatDo));
                actTitleRcmdDo.setSubCpv(ActTitleStatModel.getCpv(actTitleSubStatDo));
                actTitleRcmdDo.setSubApv(ActTitleStatModel.getApv(actTitleSubStatDo));
                actTitleRcmdDoList.add(actTitleRcmdDo);
                ActTitleFeatureDo dynamicDo = new ActTitleFeatureDo();
                dynamicDo.setActivityTitleId(recallActTitleInfoDo.getActivityTitleId());
                dynamicDo.setActivitySubTitleId(recallActTitleInfoDo.getActivitySubTitleId());
                dynamicDo.setActivityTitleTagId(recallActTitleInfoDo.getActivityTitleTagId());
                dynamicDo.setActivitySubTitleTagId(recallActTitleInfoDo.getActivitySubTitleTagId());
                dynamicDo.setActivityTitleName(recallActTitleInfoDo.getActivityTitleName());
                dynamicDo.setActivitySubTitleName(recallActTitleInfoDo.getActivitySubTitleName());
                Map dynamicFeatureMap = ActTitleFeatureParse.generateFeatureMapDynamic((ActTitleFeatureDo)dynamicDo, (ActTitleFeatureDo)actTitleFeatureDo);
                dynamicFeatureMap.putAll(staticFeatureMap);
                featureMap.put(key, dynamicFeatureMap);
            }
            HashMap hashMap = new HashMap();
            if (ActTitleDQNRcmder.validModel(coderModel, ltfModel).booleanValue()) {
                Map map = coderModel.predictWithLocalTF(featureMap, ltfModel);
            }
            for (ActTitleRcmdDo actTitleRcmdDo : actTitleRcmdDoList) {
                void var15_21;
                String key = actTitleRcmdDo.getKey();
                Double pRpm = (Double)var15_21.get(key);
                actTitleRcmdDo.setpRpm(pRpm);
                Double mergeRpm = ActTitleDQNRcmder.getMergeRpm(actTitleRcmdDo);
                actTitleRcmdDo.setMergeRpm(mergeRpm);
            }
            ret = ActTitleDQNRcmder.rcmd(actTitleRcmdDoList);
        }
        return ret;
    }

    public static ActTitleRcmdDo rcmd(List<ActTitleRcmdDo> rcmdList) {
        Double weight;
        ActTitleRcmdDo ret = null;
        if (AssertUtil.isEmpty(rcmdList)) {
            return ret;
        }
        long size = rcmdList.size();
        Double bestRpm = null;
        String bestRpmKey = null;
        Object baseRpm = null;
        if (size == 1L) {
            return rcmdList.get(0);
        }
        int i = 0;
        while ((long)i < size) {
            ActTitleRcmdDo plugDo = rcmdList.get(i);
            Double rpm = plugDo.getMergeRpm();
            if (rpm != null && (bestRpm == null || bestRpm < rpm)) {
                bestRpm = rpm;
                bestRpmKey = plugDo.getKey();
            }
            ++i;
        }
        HashMap<ActTitleRcmdDo, Double> weightMap = new HashMap<ActTitleRcmdDo, Double>(MAP_DF_SIZE);
        Double weightSum = 0.0;
        int i2 = 0;
        while ((long)i2 < size) {
            ActTitleRcmdDo rcmdDo = rcmdList.get(i2);
            Double rpm = rcmdDo.getMergeRpm();
            weight = ActTitleDQNRcmder.getRpmWeight(rpm, bestRpm);
            if (rcmdDo.getsRpm() == null || rcmdDo.getSubSRpm() == null) {
                weight = MathBase.noiseSmoother(weight, 0.1, 2.0);
            }
            if (rcmdDo.getHasType() != null && !rcmdDo.getHasType().booleanValue()) {
                if (rcmdDo.getIsNew() != null && rcmdDo.getIsNew().equals(1)) {
                    weight = MathBase.noiseSmoother(weight, 0.1, 1.0);
                }
                if (rcmdDo.getSubIsNew() != null && rcmdDo.getSubIsNew().equals(1)) {
                    weight = MathBase.noiseSmoother(weight, 0.1, 1.0);
                }
            }
            if (weight == null) {
                weight = 1.0;
            }
            weightSum = weightSum + weight;
            weightMap.put(rcmdDo, weight);
            ++i2;
        }
        for (Map.Entry entry : weightMap.entrySet()) {
            ActTitleRcmdDo rcmdDo = (ActTitleRcmdDo)entry.getKey();
            weight = (Double)entry.getValue();
            if (bestRpmKey == null || !bestRpmKey.equals(rcmdDo.getKey()) || !(weight < weightSum * 0.5)) continue;
            Double weightOther = weightSum - weight;
            weight = weightOther * 0.5 / 0.5;
            weightSum = weightOther + weight;
        }
        ret = (ActTitleRcmdDo)Roulette.doubleMap(weightMap);
        return ret;
    }

    private static Double getMergeRpm(ActTitleRcmdDo actTitleRcmdDo) {
        Double ret = null;
        if (actTitleRcmdDo != null) {
            Double actSRpm = actTitleRcmdDo.getCpv();
            Double actSubSRpm = actTitleRcmdDo.getSubCpv();
            Double pRpm = actTitleRcmdDo.getpRpm();
            if (pRpm == null) {
                return ret;
            }
            ret = pRpm;
            if (actSRpm == null) {
                actSRpm = pRpm;
            }
            if (actSubSRpm == null) {
                actSubSRpm = actSRpm;
            }
            ret = 0.5 * pRpm + 0.3 * actSRpm + 0.2 * actSubSRpm;
        }
        return ret;
    }

    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;
        if (rpm != null && bestRpm != null) {
            Double ratio = DataUtil.division((Double)rpm, (Double)bestRpm, (int)3);
            if (bestRpm >= 0.0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }
        }
        return ret;
    }

    private static Boolean valid(RecallActTitleDo recallActTitleDo, ActTitleFeatureDo actFeatureDo) {
        Boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{recallActTitleDo, actFeatureDo})) {
            logger.error("ActTitleDQNRcmder.rcmd() input valid ,params plugList or adxFeatureDo is null");
            ret = false;
        }
        if (recallActTitleDo != null && AssertUtil.isEmpty(recallActTitleDo.getActivitySubTitleIdList())) {
            logger.error("ActTitleDQNRcmder.rcmd() input valid ,params plugList or adxFeatureDo is null");
            ret = false;
        }
        return ret;
    }

    private static Boolean validModel(CODER coderModel, LocalTFModel ltfModel) {
        Boolean ret = true;
        if (ltfModel == null || coderModel == null) {
            logger.error("ActTitleDQNRcmder.rcmd() input valid ,params ltfModel is null");
            ret = false;
        }
        return ret;
    }
}

