package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowFilterDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public class AdxFlowFiltering {

    /**
     * 算法接口1-流量预过滤
     *
     * @param flowInfo adx流量信息
     * @param filterInfo adx流量过滤-定时任务结果
     * @return
     */

    private static final Logger logger = LoggerFactory.getLogger(AdxFlowFiltering.class);

    public static AdxFlowFilterDo getFlowFiltering(AdxFlowInfoDo flowInfo,
                                                   AdxFilterInfoDo filterInfo) {

        AdxFlowFilterDo ret = new AdxFlowFilterDo();

        try {

            Integer flowFilterLabel = 0;  //流量过滤标记(0：不过滤；1：过滤)
            Integer preInterval = null;   //ctr预估区间
            Integer filterIndex = 1;      //abtest分流标记(1：对比组；2：测试组)

            Double filterRate = 0.0;      //过滤比例
            Double testRate = 0.5;        //abtest分流-测试组切流


            if (AssertUtil.isAllNotEmpty(flowInfo, filterInfo)) {



                //获取ctr预估区间preInterval
                Double preValue = flowInfo.getCurrentPreValue(); //模型CTR预估值

                preInterval = AdxStatData.getPreInterval(preValue);
                Map<Integer, Double> filterMap = filterInfo.getFilterMap();

                if (AssertUtil.isAllNotEmpty(preInterval, filterMap)) {
                    filterRate = AdxStatData.nullToDefault(filterMap.get(preInterval),0.0);
                }


                double random = Math.random();
                if (random > testRate) {
                    filterIndex = 2;

                    double random2 = Math.random();
                    if (random2 < filterRate) {
                        flowFilterLabel = 1;
                    }
                }

            }

            ret.setFlowFilterLabel(flowFilterLabel);
            ret.setPreInterval(preInterval);
            ret.setFilterIndex(filterIndex);


        } catch (Exception e) {
            logger.error("AdxFlowFiltering.getFlowFiltering error:" + e);

        }

        return ret;

    }
}

