package cn.com.duiba.nezha.alg.alg.title;

import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.title.*;
import cn.com.duiba.nezha.alg.feature.vo.ActTitleFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public class ActTitleRcmdAlg {

    private static final Logger logger = LoggerFactory.getLogger(ActTitleRcmdAlg.class);


    /**
     * 推荐
     *
     * @param coderModel
     * @param ltfModel
     * @param recallActTitleDo
     * @param actTitleStatDoList
     * @param actSubTitleStatDoList
     * @param actSlotTitleStatDoList
     * @param actSlotSubTitleStatDoList
     * @param actTitleFeatureDo
     * @return
     */
    public static ActTitleRcmdDo rcmd2(CODER coderModel,
                                       LocalTFModel ltfModel,
                                       RecallActTitleDo recallActTitleDo,
                                       List<ActTitleStatDo> actTitleStatDoList,
                                       List<ActTitleStatDo> actSubTitleStatDoList,
                                       List<ActTitleStatDo> actSlotTitleStatDoList,
                                       List<ActTitleStatDo> actSlotSubTitleStatDoList,
                                       ActTitleFeatureDo actTitleFeatureDo,
                                       boolean hasSubTitle) {
        ActTitleRcmdDo ret = null;
        try {
            ret = ActTitleDQNRcmder.rcmd2(coderModel,
                    ltfModel,
                    recallActTitleDo,
                    actTitleStatDoList,
                    actSubTitleStatDoList,
                    actSlotTitleStatDoList,
                    actSlotSubTitleStatDoList,
                    actTitleFeatureDo,hasSubTitle);
        } catch (Exception e) {
            logger.error("ActTitleRcmdDo.rcmd2 error", e);
        }
        return ret;
    }


    /**
     * 召回
     *
     * @param filterActTitleDoList
     * @param preSelectActTitleDoList
     * @return
     */

    public static RecallActTitleDo recall(List<FilterActTitleDo> filterActTitleDoList,
                                          List<PreSelectActTitleDo> preSelectActTitleDoList,
                                          boolean hasSubTitle) {
        RecallActTitleDo ret = null;
        try {
            ret = ActTitleRecaller.recall(filterActTitleDoList, preSelectActTitleDoList,hasSubTitle);
        } catch (Exception e) {
            logger.error("ActPlugInRcmdAlg.rcmd error", e);
        }
        return ret;

    }


    /**
     * 特征解析
     *
     * @param
     * @return
     */
    public static Map<String, String> feaureParse(ActTitleFeatureDo actTitileFeatureDo) {
        //1 静态特征解析
        return ActTitleDQNRcmder.featureParse(actTitileFeatureDo);
    }


}
