package cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter;

import java.util.Map;


/**
 * adx流量过滤-定时任务对象
 */

public class AdxFilterInfoDo {

    /**
     * 流量过滤比例({分preInterval：小数})
     */
    private Map<Integer, Double> filterMap;

    /**
     * 上一次流量过滤比例({分preInterval：小数})
     */
    private Map<Integer, Double> lastFilterMap;

    /**
     * 实际ctr-近1h({分preInterval：小数})
     */
    private Map<Integer, Double> ctrByHour;

    /**
     * 实际ctr-当天({分preInterval：小数})
     */
    private Map<Integer, Double> ctrByDay;

    /**
     * 实际roi-近1h({分preInterval：小数})
     */
    private Map<Integer, Double> roiByHour;

    /**
     * 实际roi-当天({分preInterval：小数})
     */
    private Map<Integer, Double> roiByDay;

    /**
     * 创意实时ROI
     */
    private Double roiHour;

    /**
     * 创意实时ctr
     */
    private Double ctrHour;

    /**
     * 数据是否置信({分preInterval：0/1})
     */
    private Map<Integer, Boolean> isConfidence;


    public Map<Integer, Double> getFilterMap() {
        return filterMap;
    }

    public void setFilterMap(Map<Integer, Double> filterMap) {
        this.filterMap = filterMap;
    }

    public Map<Integer, Double> getLastFilterMap() {
        return lastFilterMap;
    }

    public void setLastFilterMap(Map<Integer, Double> lastFilterMap) {
        this.lastFilterMap = lastFilterMap;
    }

    public Map<Integer, Double> getCtrByHour() {
        return ctrByHour;
    }

    public void setCtrByHour(Map<Integer, Double> ctrByHour) {
        this.ctrByHour = ctrByHour;
    }

    public Map<Integer, Double> getCtrByDay() {
        return ctrByDay;
    }

    public void setCtrByDay(Map<Integer, Double> ctrByDay) {
        this.ctrByDay = ctrByDay;
    }

    public Map<Integer, Double> getRoiByHour() {
        return roiByHour;
    }

    public void setRoiByHour(Map<Integer, Double> roiByHour) {
        this.roiByHour = roiByHour;
    }

    public Map<Integer, Double> getRoiByDay() {
        return roiByDay;
    }

    public void setRoiByDay(Map<Integer, Double> roiByDay) {
        this.roiByDay = roiByDay;
    }

    public Double getRoiHour() {
        return roiHour;
    }

    public void setRoiHour(Double roiHour) {
        this.roiHour = roiHour;
    }

    public Double getCtrHour() {
        return ctrHour;
    }

    public void setCtrHour(Double ctrHour) {
        this.ctrHour = ctrHour;
    }

    public Map<Integer, Boolean> getIsConfidence() {
        return isConfidence;
    }

    public void setIsConfidence(Map<Integer, Boolean> isConfidence) {
        this.isConfidence = isConfidence;
    }
}
