package cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter;

import java.util.Map;


/**
 * adx流量信息对象
 */

public class AdxFlowInfoDo {

    /**
     * 推广组ID
     */
    private Long groupId;

    /**
     * 资源位ID
     */
    private Long resourceId;

    /**
     * 创意ID
     */
    private Long ideaId;

    /**
     * 最低ROI(小数，如1.50)
     */
    private Double minRoi;

    /**
     * 模型CTR预估值--(定时任务不需要)
     */
    private Double currentPreValue;

    /**
     * 创意维度 统计数据--近1h
     */
    private AdxIndexStatDo ideaHourStats;

    /**
     * 创意维度 统计数据--当天
     */
    private AdxIndexStatDo ideaDayStats;

    /**
     * 创意分preInterval维度 统计数据--近1h
     */
    private Map<Integer, AdxIndexStatDo> preIntervalHourStats;

    /**
     * 创意分preInterval维度 统计数据--当天
     */
    private Map<Integer, AdxIndexStatDo> preIntervalDayStats;


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public Long getIdeaId() {
        return ideaId;
    }

    public void setIdeaId(Long ideaId) {
        this.ideaId = ideaId;
    }

    public Double getMinRoi() {
        return minRoi;
    }

    public void setMinRoi(Double minRoi) {
        this.minRoi = minRoi;
    }

    public Double getCurrentPreValue() {
        return currentPreValue;
    }

    public void setCurrentPreValue(Double currentPreValue) {
        this.currentPreValue = currentPreValue;
    }

    public AdxIndexStatDo getIdeaHourStats() {
        return ideaHourStats;
    }

    public void setIdeaHourStats(AdxIndexStatDo ideaHourStats) {
        this.ideaHourStats = ideaHourStats;
    }

    public AdxIndexStatDo getIdeaDayStats() {
        return ideaDayStats;
    }

    public void setIdeaDayStats(AdxIndexStatDo ideaDayStats) {
        this.ideaDayStats = ideaDayStats;
    }

    public Map<Integer, AdxIndexStatDo> getPreIntervalHourStats() {
        return preIntervalHourStats;
    }

    public void setPreIntervalHourStats(Map<Integer, AdxIndexStatDo> preIntervalHourStats) {
        this.preIntervalHourStats = preIntervalHourStats;
    }

    public Map<Integer, AdxIndexStatDo> getPreIntervalDayStats() {
        return preIntervalDayStats;
    }

    public void setPreIntervalDayStats(Map<Integer, AdxIndexStatDo> preIntervalDayStats) {
        this.preIntervalDayStats = preIntervalDayStats;
    }
}

