/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.dpa;

import cn.com.duiba.nezha.alg.alg.vo.dpa.PackageIdDo;
import cn.com.duiba.nezha.alg.alg.vo.dpa.PackageInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.dpa.PackageRecallDo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.WilsonInterval;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageRecall {
    private static final Logger logger = LoggerFactory.getLogger(PackageRecall.class);
    private static Comparator<PackageRecallDo> iComparator = new Comparator<PackageRecallDo>(){

        @Override
        public int compare(PackageRecallDo o1, PackageRecallDo o2) {
            return o2.getMatchScore() > o1.getMatchScore() ? 1 : -1;
        }
    };

    public static List<PackageRecallDo> matchSkin(List<PackageInfoDo> pks) {
        return PackageRecall.ucbPackage(pks, 1, 0);
    }

    public static List<PackageRecallDo> matchPrize(List<PackageInfoDo> pks) {
        return PackageRecall.ucbPackage(pks, 100, 2, 1);
    }

    public static List<PackageRecallDo> matchTitle(List<PackageInfoDo> pks) {
        return PackageRecall.ucbPackage(pks, 20, 4, 3);
    }

    public static List<PackageRecallDo> matchSubTitle(List<PackageInfoDo> pks) {
        return PackageRecall.ucbPackage(pks, 6, 5);
    }

    public static List<PackageRecallDo> matchPackageAct(List<PackageInfoDo> pks) {
        return PackageRecall.ucbPackage(pks, 100, 7);
    }

    public static List<PackageRecallDo> matchPackage(List<PackageInfoDo> pks, int topN, int topK, int recallType) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{pks})) {
            logger.error("PackageRecall matchTitle input params is null");
            return null;
        }
        ArrayList<PackageRecallDo> result = new ArrayList<PackageRecallDo>();
        PriorityQueue<PackageRecallDo> pkrs = new PriorityQueue<PackageRecallDo>(pks.size(), iComparator);
        HashSet<PackageIdDo> ids = new HashSet<PackageIdDo>();
        int supportIdLen = 0;
        for (PackageInfoDo pk : pks) {
            PackageRecallDo pkrd = new PackageRecallDo();
            pkrd.setPackageInfoDo(pk);
            if (pk.getReuqest() < 10.0 && System.currentTimeMillis() - pk.getPackageIdDo().getCreateTime() < 25920000L) {
                if (!(Math.random() < 0.1) || supportIdLen >= topK) continue;
                result.add(pkrd);
                ids.add(pk.getPackageIdDo());
                ++supportIdLen;
                continue;
            }
            double matchScore = WilsonInterval.wilsonCalc((double)(pk.getCost().doubleValue() / 100.0), (double)pk.getReuqest().doubleValue()).lowerBound;
            pkrd.setMatchScore(matchScore);
            pkrd.setMatchType(recallType);
            pkrs.add(pkrd);
        }
        for (int i = 0; i < pkrs.size(); ++i) {
            PackageRecallDo pr = (PackageRecallDo)pkrs.poll();
            if (result.size() >= topN || ids.contains(pr.getPackageInfoDo().getPackageIdDo())) continue;
            result.add(pr);
        }
        return result;
    }

    public static List<PackageRecallDo> ucbPackage(List<PackageInfoDo> pks, int ... args) {
        ArrayList<PackageRecallDo> result;
        block7: {
            result = new ArrayList<PackageRecallDo>();
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{pks})) {
                logger.error("PackageRecall matchTitle input params is null");
                return null;
            }
            if (args.length < 2) break block7;
            int topN = args[0];
            int recallType = args[1];
            int globalRecallType = args.length >= 3 ? args[2] : 0;
            PriorityQueue<PackageRecallDo> gpkrs = new PriorityQueue<PackageRecallDo>(pks.size(), iComparator);
            PriorityQueue<PackageRecallDo> spkrs = new PriorityQueue<PackageRecallDo>(pks.size(), iComparator);
            HashSet<PackageIdDo> ids = new HashSet<PackageIdDo>();
            int sNum = 0;
            double gtotal = 0.0;
            double gbMax = 0.0;
            double gbMin = 0.0;
            double stotal = 0.0;
            double bMax = 0.0;
            double bMin = 0.0;
            for (PackageInfoDo pk : pks) {
                gtotal += pk.getGlobalCost().doubleValue();
                stotal += pk.getCost().doubleValue();
                double guvCost = pk.getGlobalReuqest() > 0.0 ? pk.getGlobalCost() / pk.getGlobalReuqest() : 0.0;
                gbMax = Math.max(guvCost, gbMax);
                gbMin = Math.min(guvCost, gbMin);
                double suvCost = pk.getReuqest() > 0.0 ? pk.getCost() / pk.getReuqest() : 0.0;
                bMax = Math.max(suvCost, bMax);
                bMin = Math.min(suvCost, bMin);
                if (!(pk.getCost() > 0.0)) continue;
                ++sNum;
            }
            double rate = sNum / pks.size();
            int slotTopN = (int)(rate * (double)topN);
            for (PackageInfoDo pk : pks) {
                PackageRecallDo pkrd = new PackageRecallDo();
                pkrd.setPackageInfoDo(pk);
                double globalProbTemp = pk.getGlobalCost() > 0.0 ? pk.getGlobalCost() / pk.getGlobalReuqest() : 0.0;
                double globalProb = (globalProbTemp - gbMin) / (gbMax - gbMin);
                double globalBonus = pk.getGlobalCost() > 0.0 ? Math.sqrt(2.0 * Math.log(gtotal) / pk.getGlobalReuqest()) : 0.0;
                double globalMatchScore = globalProb + globalBonus;
                pkrd.setMatchScore(globalMatchScore);
                pkrd.setMatchType(globalRecallType);
                gpkrs.add(pkrd);
                if (!(pk.getCost() > 0.0)) continue;
                double slotProbTemp = pk.getCost() > 0.0 ? pk.getCost() / pk.getReuqest() : 0.0;
                double prob = (slotProbTemp - bMin) / (bMax - bMin);
                double bonus = pk.getCost() > 0.0 ? Math.sqrt(2.0 * Math.log(stotal) / pk.getReuqest()) : 0.0;
                double matchScore = prob + bonus;
                pkrd.setMatchScore(matchScore);
                pkrd.setMatchType(recallType);
                spkrs.add(pkrd);
            }
            if (slotTopN > 0 && Math.random() < 0.9) {
                for (int i = 0; i < spkrs.size() && i < slotTopN; ++i) {
                    PackageRecallDo pkrd = (PackageRecallDo)spkrs.poll();
                    if (ids.contains(pkrd.getPackageInfoDo().getPackageIdDo())) continue;
                    result.add(pkrd);
                    ids.add(pkrd.getPackageInfoDo().getPackageIdDo());
                }
            } else {
                for (int i = 0; i < gpkrs.size() && result.size() < topN; ++i) {
                    PackageRecallDo pkrd = (PackageRecallDo)gpkrs.poll();
                    if (ids.contains(pkrd.getPackageInfoDo().getPackageIdDo())) continue;
                    result.add(pkrd);
                    ids.add(pkrd.getPackageInfoDo().getPackageIdDo());
                }
            }
        }
        return result;
    }
}

