package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.FM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class AdxFlowFiltering {

    private static final Logger logger = LoggerFactory.getLogger(AdxFlowFiltering.class);
    private static double[] PRE_CTR_BUCKET = {0.002, 0.003, 0.005, 0.007, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.10};  // 预估ctr区间划分


    /**
     * 流量预过滤
     *
     * @param flowFilterRequestDo
     * @return
     */

    public static FlowFilterResultDo getFlowFiltering(FlowFilterRequestDo flowFilterRequestDo) {

        FlowFilterResultDo ret = new FlowFilterResultDo();

        /**
         *
         * 步骤：
         * 步骤0、预估ctr
         * 步骤1、获取测试分流标记
         * 步骤2、获取ctr预估区间
         * 步骤3、获取过滤比例
         * 步骤4、获取统计数据
         * 步骤5、判断流量过滤
         *
         */

        try {

            Integer flowFilterLabel = 0;        //流量过滤标记(0：不过滤；1：过滤)
            Integer preInterval = null;         //ctr预估区间
            Integer filterIndex = 1;            //abtest分流标记(1:对比组，2:测试组1.0, 3:测试组2.0)
            Double filterRate = 0.0;            //过滤比例
            boolean isConfident = false;        //统计指标是否置信
            Integer filterType = 0;             //算法过滤原因(0-不过滤，1-流量预过滤，2-每pv发券过滤)


            //0.预估ctr
            Double preCtr = flowFilterRequestDo.getPreCtr();
            if(AssertUtil.isNotEmpty(flowFilterRequestDo) && AssertUtil.isNotEmpty(flowFilterRequestDo.getCtrFmModel())) {
                FM ctrFmModel = flowFilterRequestDo.getCtrFmModel();
                AdxFeatureDo adxFeatureDo = flowFilterRequestDo.getAdxFeatureDo();
                Map<String, String> staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo);
                Map<String, String> dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic(adxFeatureDo, adxFeatureDo);
                Map<String, String> featureMap = new HashMap<>();
                if (AssertUtil.isNotEmpty(staticFeatureMap)) { featureMap.putAll(staticFeatureMap); }
                if (AssertUtil.isNotEmpty(dynamicFeatureMap)) { featureMap.putAll(dynamicFeatureMap); }
                preCtr = ctrFmModel.predict(featureMap);
            }


            AdxFlowInfoDo flowInfo = flowFilterRequestDo.getFlowInfo();
            AdxFilterInfoDo filterInfo1 = flowFilterRequestDo.getFilterInfo1();
            AdxFilterInfoDo filterInfo2 = flowFilterRequestDo.getFilterInfo2();
            if (AssertUtil.isNotEmpty(flowInfo)) {

                //1.获取测试分流标记
                Map<Integer, Long> testRateMap = flowInfo.getTestRate();//测试组切流(百分数)
                filterIndex = getFilterIndex(testRateMap);


                //2.获取ctr预估区间preInterval
                //Double preValue = flowInfo.getCurrentPreValue(); //模型CTR预估值
                preInterval = AdxStatData.bucket(preCtr, PRE_CTR_BUCKET);


                //3.获取过滤比例
                AdxFilterInfoDo filterInfo = filterIndex < 2 ? null : (filterIndex < 3 ? filterInfo1 : filterInfo2);
                if (AssertUtil.isNotEmpty(filterInfo)) {
                    Map<Integer, Double> filterMap = filterInfo.getFilterMap();
                    if (AssertUtil.isAllNotEmpty(preInterval, filterMap)) {
                        filterRate = AdxStatData.nullToDefault(filterMap.get(preInterval),0.0);
                    }
                }


                //4.获取统计数据
                AdxIndexStatDo ideaDayStats = flowInfo.getIdeaDayStats();
                AdxIndexStatsDo ideaDayComputes = AdxStatData.adxIndexCompute(ideaDayStats);
                isConfident = ideaDayComputes.getConfident();


                //5.判断流量过滤（前提：数据置信）
                double random = Math.random();
                if (isConfident) {

                    if (filterIndex.equals(2)) {
                        flowFilterLabel = random < filterRate ? 1 : 0;

                    } else if (filterIndex.equals(3)) {

                        //filterIndex=3：测试组2.0，优先过滤 多次曝光无点击 的流量
                        Long imeiExp = AdxStatData.nullToDefault(flowInfo.getHistoryImeiExp(),0L);
                        Long imeiClick = AdxStatData.nullToDefault(flowInfo.getHistoryImeiClick(), 0L);

                        if (imeiExp > 20 && imeiClick < 1) {
                            flowFilterLabel = random < 0.99 ? 1 : 0;

                        } else if (imeiExp > 10 && imeiClick < 1) {
                            flowFilterLabel = random < filterRate ? 1 : 0;

                        } else if (imeiExp < 1 && imeiClick < 1) {
                            flowFilterLabel = random < filterRate * 0.7 ? 1 : 0;

                        } else {
                            flowFilterLabel = random < filterRate * 0.9 ? 1 : 0;
                        }
                    }

                }

            }

            //算法过滤原因(0-不过滤，1-流量预过滤，2-每pv发券过滤)
            filterType = flowFilterLabel == 1 ? 1 : 0;

            ret.setFlowFilterLabel(flowFilterLabel);
            ret.setPreInterval(preInterval);
            ret.setFilterIndex(filterIndex);
            //ret.setPreCtr(preCtr);
            ret.setFilterType(filterType);


        } catch (Exception e) {
            logger.error("AdxFlowFiltering.getFlowFiltering error:" + e);

        }

        return ret;
    }




    /**
     * abtest分流
     *
     * @param testRateMap
     * @return
     */
    public static Integer getFilterIndex(Map<Integer, Long> testRateMap) {

        Integer ret = 1;

        if (AssertUtil.isNotEmpty(testRateMap)) {

            List<Integer> keyList = new ArrayList<>(testRateMap.keySet());
            List<Long> valueList = new ArrayList<>(testRateMap.values());

            Integer retIndex = AdxStatData.getFlowSplit(valueList);
            ret = keyList.get(retIndex);
        }

        return ret;
    }


    /**
     * 校验基础信息是否合法
     *
     * @param flowFilterRequestDo
     * @return
     */
    private static Boolean valid(FlowFilterRequestDo flowFilterRequestDo) {

        Boolean ret = true;

        if (flowFilterRequestDo == null) {
            logger.error("AdxFlowFiltering.getFlowFiltering() input params valid , params flowFilterRequestDo is null");
            return false;
        }

        if (flowFilterRequestDo.getPreCtr() == null) {
            logger.warn("AdxFlowFiltering.getFlowFiltering() input params valid , params preCtr is null");
            return false;
        }

        return ret;
    }
}

