package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.params.AdxIdeaRcmdParam;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class IdeaRcmdAlg {

    private static final Logger logger = LoggerFactory.getLogger(IdeaRcmdAlg.class);

    static double[] weight = {100, 20, 10, 5, 2, 1, 0.5};


    /**
     * 创意推荐
     *
     * @param rcmdRequestDo
     * @return
     */
    public static AdxIdeaRcmdResultDo getIdeaRcmd(AdxIdeaRcmdRequestDo rcmdRequestDo) {

        AdxIdeaRcmdResultDo ret = new AdxIdeaRcmdResultDo();

        /**
         *
         * 步骤：
         * 步骤1、预估创意CTR，点击价值
         * 步骤2、统计创意CTR，点击价值
         * 步骤3、创意挑选
         *
         * 备注：putType = 0依次, 1比例, 2算法1.0, 3算法2.0
         *
         */

        try {

            Map<Long, FeatureMapDo> featureMap = new HashMap<>();
            Map<Long, Double> preExpValueMap = new HashMap<>();
            Map<Long, Double> preCtrMap = new HashMap<>(), statCtrMap = new HashMap<>(), statDayCtrMap = new HashMap<>();
            Map<Long, Double> preClickValueMap = new HashMap<>(), statClickValueMap = new HashMap<>(), statDayClickValueMap = new HashMap<>();
            Double statCtrResource = null, statClickValueResource = null;
            Double mergeRpm = null, pRpm = null, sRpm = null;


            //判断异常原因
            Long giveUpType = getGiveUpType(rcmdRequestDo);
            rcmdRequestDo = Optional.ofNullable(rcmdRequestDo).orElse(new AdxIdeaRcmdRequestDo());
            Integer putType = Optional.ofNullable(rcmdRequestDo.getPutType()).orElse(3);



            /* 步骤1、预估创意CTR，点击价值 */
            if (AssertUtil.isEmpty(giveUpType)) {

                //1.1 非创意特征：静态特征解析
                AdxFeatureDo adxFeatureDo = rcmdRequestDo.getAdxFeatureDo();
                Map<String, String> staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo);

                //1.2 创意特征：动态特征解析
                List<AdxIdeaFeatureDo> ideaList = rcmdRequestDo.getIdeaFeatureList();
                for (AdxIdeaFeatureDo ideaDo : ideaList) {
                    Long ideaId = ideaDo.getIdeaId();
                    AdxFeatureDo dynamicDo = new AdxFeatureDo();
                    dynamicDo.setIdeaId(ideaId);
                    dynamicDo.setButtonText(ideaDo.getButtonText()); // 按钮文字 f3010020
                    dynamicDo.setIconH(ideaDo.getIconH()); // 创意图标高 f3010030
                    dynamicDo.setIconW(ideaDo.getIconW()); // 创意图标宽 f3010040
                    dynamicDo.setMjPicType(ideaDo.getMjPicType()); // 规格类型 f3010050
                    dynamicDo.setIdeaPicH1(ideaDo.getIdeaPicH1()); // 创意图片高1 f3010060
                    dynamicDo.setIdeaPicW1(ideaDo.getIdeaPicW1()); // 创意图片宽1 f3010070
                    dynamicDo.setIdeaPicH2(ideaDo.getIdeaPicH2()); // 创意图片高2 f3010080
                    dynamicDo.setIdeaPicW2(ideaDo.getIdeaPicW2()); // 创意图片宽2 f3010090
                    dynamicDo.setIdeaPicH3(ideaDo.getIdeaPicH3()); // 创意图片高3 f3010100
                    dynamicDo.setIdeaPicW3(ideaDo.getIdeaPicW3()); // 创意图片宽3 f3010110
                    dynamicDo.setIdeaPicNum(ideaDo.getIdeaPicNum()); // 创意图片个数 f3010120
                    dynamicDo.setStyleStandard(ideaDo.getStyleStandard()); // 广告样式规格 f3010130
                    dynamicDo.setPictureMaterialDo(ideaDo.getPictureMaterialDo()); //创意图片素材特征
                    dynamicDo.setVideoMaterialDo(ideaDo.getVideoMaterialDo()); //创意视频素材特征
                    Map<String, String> dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic(dynamicDo, adxFeatureDo);

                    // 封装创意特征集合
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
                    featureMapDo.setStaticFeatureMap(staticFeatureMap);
                    featureMap.put(ideaId, featureMapDo);
                }

                //1.3 预估创意ctr
                FM fmModel = rcmdRequestDo.getFmModel();
                preCtrMap = fmModel.predictsNew(featureMap);

                //1.4 预估创意点击价值(创意推荐1.0)
                if (putType.equals(2)) {
                    CODER2 coderModel = rcmdRequestDo.getCoderModel();
                    LocalTFModel ltfModel = rcmdRequestDo.getLtfModel();
                    if (AssertUtil.isAllNotEmpty(coderModel, ltfModel)) {
                        preClickValueMap = coderModel.predictWithLocalTFNew(featureMap, ltfModel);
                    }
                }

            }



            /* 步骤2、统计创意CTR，点击价值 */
            //2.1 资源位维度
            AdxStatsDo resoStats = Optional.ofNullable(rcmdRequestDo.getResoStats()).orElse(new AdxStatsDo());
            AdxIndexStatDo resoLast20MinStat = resoStats.getLast20MinStat();
            AdxIndexStatsDo resoStatsMin = AdxStatData.adxIndexCompute(resoLast20MinStat);
            statCtrResource = resoStatsMin.getCtr();
            statClickValueResource = resoStatsMin.getClickValue();

            //2.2 创意维度
            Map<Long, AdxStatsDo> ideaStatsList = rcmdRequestDo.getIdeaStatsList();
            if (AssertUtil.isNotEmpty(ideaStatsList)) {
                Iterator<Map.Entry<Long, AdxStatsDo>> it = ideaStatsList.entrySet().iterator();

                while (it.hasNext()) {
                    Map.Entry<Long, AdxStatsDo> entry = it.next();
                    Long ideaId = entry.getKey();
                    AdxStatsDo ideaStats = Optional.ofNullable(entry.getValue()).orElse(new AdxStatsDo());

                    AdxIndexStatDo ideaLast20MinStat = ideaStats.getLast20MinStat();
                    AdxIndexStatDo ideaLast1DayStat = ideaStats.getLast1DayStat();
                    AdxIndexStatsDo ideaStatsMin = AdxStatData.adxIndexCompute(ideaLast20MinStat);
                    AdxIndexStatsDo ideaStatsDay = AdxStatData.adxIndexCompute(ideaLast1DayStat);
                    statCtrMap.put(ideaId, ideaStatsMin.getCtr());
                    statClickValueMap.put(ideaId, ideaStatsMin.getClickValue());
                    statDayCtrMap.put(ideaId, ideaStatsDay.getCtr());
                    statDayClickValueMap.put(ideaId, ideaStatsDay.getClickValue());
                }
            }



            /* 步骤3、创意挑选 */
            Long bestIdeaId = null;
            if (putType.equals(0) || putType.equals(1)) {
                bestIdeaId = rcmdRequestDo.getManualIdeaId();


            } else if (putType.equals(3)) {

                AdxIdeaRcmdParam adxIdeaRcmdParam = new AdxIdeaRcmdParam();
                adxIdeaRcmdParam.setIdeaFeatureList(rcmdRequestDo.getIdeaFeatureList());
                adxIdeaRcmdParam.setAdxFeatureDo(rcmdRequestDo.getAdxFeatureDo());
                adxIdeaRcmdParam.setAdxResourceRcmdDo(rcmdRequestDo.getAdxResourceRcmdDo());
                AdxIdeaFeatureDo result = AdxIdeaRcmdAlg.ideaRcmd(adxIdeaRcmdParam);
                if (AssertUtil.isNotEmpty(result)) {
                    bestIdeaId = result.getIdeaId();
                    mergeRpm = result.getMergeRpm(); pRpm = result.getPRpm(); sRpm = result.getSRpm();
                    if (AssertUtil.isAllEmpty(giveUpType, bestIdeaId)) {giveUpType = 7L;}
                }


            } else if (putType.equals(2)) {

                Double preCtrWeight = 0.8, preCvaWeight = 0.2; //模型预估权重
                List<AdxIdeaFeatureDo> ideaList = rcmdRequestDo.getIdeaFeatureList();
                if (AssertUtil.isNotEmpty(ideaList)) {

                    for (AdxIdeaFeatureDo ideaDo : ideaList) {
                        Long ideaId = ideaDo.getIdeaId();

                        Double pCtr = preCtrMap.get(ideaId);
                        Double sCtr = AdxStatData.nullToDefault(AdxStatData.nullToDefault(statCtrMap.get(ideaId), statDayCtrMap.get(ideaId)), statCtrResource);
                        Double conCtr = AdxStatData.getConCtr(pCtr, sCtr, preCtrWeight, 0.0, 4.0, 0.01);

                        Double pClickValue = preClickValueMap.get(ideaId);
                        Double sClickValue = AdxStatData.nullToDefault(AdxStatData.nullToDefault(statClickValueMap.get(ideaId), statDayClickValueMap.get(ideaId)), statClickValueResource);
                        Double conClickValue = AdxStatData.getConValue(pClickValue, sClickValue, preCvaWeight, 0.0, 2.0, 1.0);

                        //预估创意曝光价值
                        Double preExpValue = AdxStatData.nullToMinDefault(conCtr * conClickValue, 0.0);
                        preExpValueMap.put(ideaId, DataUtil.formatDouble(preExpValue,6));
                    }

                    //挑选最优创意
                    bestIdeaId = getBestIdeaId(ideaList, preExpValueMap);

                }
            }


            //组装推荐结果相关信息
            Map<String, String> combineFeatureMap = new HashMap<String, String>();
            FeatureMapDo bestFeatureMap = featureMap.get(bestIdeaId);
            if (AssertUtil.isNotEmpty(bestFeatureMap)
                    && AssertUtil.isNotEmpty(bestFeatureMap.getStaticFeatureMap())
                    && AssertUtil.isNotEmpty(bestFeatureMap.getDynamicFeatureMap())) {

                combineFeatureMap.putAll(bestFeatureMap.getStaticFeatureMap());
                combineFeatureMap.putAll(bestFeatureMap.getDynamicFeatureMap());
            }

            ret.setIdeaId(bestIdeaId);
            ret.setGiveUpType(giveUpType);
            ret.setIdeaFeatureMap(combineFeatureMap);
            ret.setPreCtr(preCtrMap.get(bestIdeaId));
            ret.setStatCtr(statCtrMap.get(bestIdeaId));
            ret.setStatCtrResource(statCtrResource);
            ret.setPreClickValue(preClickValueMap.get(bestIdeaId));
            ret.setStatClickValue(statClickValueMap.get(bestIdeaId));
            ret.setStatClickValueResource(statClickValueResource);
            ret.setMergeRpm(mergeRpm);
            ret.setPRpm(pRpm);
            ret.setSRpm(sRpm);
            ret.setIdeaScoreMap(JSONObject.toJSONString(preExpValueMap));


        } catch (Exception e) {

            logger.error("IdeaRcmdAlg.getIdeaRcmd error", e);
        }
        return ret;
    }


    /**
     * 校验基础信息是否合法
     *
     * @param rcmdRequestDo
     * @return
     */
    private static Long getGiveUpType(AdxIdeaRcmdRequestDo rcmdRequestDo) {

        Long ret = null;

        if (rcmdRequestDo == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params adxIdeaRcmdRequestDo is null");
            return 1L;
        }

        if (rcmdRequestDo.getPutType() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is null");
            return 1L;
        }

        if (rcmdRequestDo.getFmModel() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params fmModel is null");
            return 2L;
        }

        if (rcmdRequestDo.getPutType() == 2 && rcmdRequestDo.getCoderModel() == null) {
            logger.warn("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is 2, params coderModel is null");
            return null;
        }

        if (rcmdRequestDo.getPutType() == 2 && rcmdRequestDo.getLtfModel() == null) {
            logger.warn("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is 2, params ltfModel is null");
            return null;
        }

        if (AssertUtil.isEmpty(rcmdRequestDo.getIdeaFeatureList())) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params ideaFeatureList is empty");
            return 5L;
        }

        if (rcmdRequestDo.getAdxFeatureDo() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params adxFeatureDo is null");
            return 6L;
        }

        return ret;
    }


    /**
     * 选择最优创意
     *
     * @param valueMap
     * @return
     */
    public static Long getBestIdeaId(List<AdxIdeaFeatureDo> ideaList, Map<Long, Double> valueMap) {

        Long ret = null;
        if (AssertUtil.isNotEmpty(ideaList)) {
            int size = ideaList.size();

            if (size == 1) {
                AdxIdeaFeatureDo bestIdeaDo = ideaList.get(0);
                ret = bestIdeaDo.getIdeaId();

            } else {

                List<Double> flowRateList = new ArrayList<>(size);
                if (AssertUtil.isNotEmpty(valueMap) && !valueMap.isEmpty()) {

                    //按降序排列
                    Map<Long, Double> sortedMap = AdxStatData.sortMapByValueDescend(valueMap);
                    //List<Map.Entry<Long, Double>> sortedList = new ArrayList<>(sortedMap.entrySet());
                    List<Long> sortedKeyList = new ArrayList<>(sortedMap.keySet());
                    List<Double> sortedValueList = new ArrayList<>(sortedMap.values());

                    Double maxExpValue = sortedValueList.get(0);
                    Double minExpValue = sortedValueList.get(size - 1);
                    for (int ind = 0; ind < size; ind++) {

                        if (maxExpValue.equals(minExpValue)) {
                            flowRateList.add(weight[0]);

                        } else {

                            if (ind < weight.length) {
                                flowRateList.add(weight[ind]);
                            } else {
                                flowRateList.add(weight[weight.length - 1]);
                            }

                            if (ind >= 1 && sortedValueList.get(ind).equals(sortedValueList.get(ind - 1))) {
                                flowRateList.set(ind, flowRateList.get(ind - 1));
                            }

                        }
                    }

                    Integer retIndex = AdxStatData.flowSplit(flowRateList);
                    ret = sortedKeyList.get(retIndex);
                }
            }
        }

        return ret;
    }

}
