package cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter;

import lombok.Data;

import java.io.Serializable;

/**
 * adx流量过滤出参对象
 */

@Data
public class FlowFilterResultDo implements Serializable {

    private static final long serialVersionUID = -931978272746105493L;

    /**
     * 流量过滤标记（0：不过滤；1：过滤）
     */
    private Integer flowFilterLabel;

    /**
     * ctr预估区间
     */
    private Integer preInterval;

    /**
     * abtest分流标记（1：对比组；2：测试组）
     */
    private Integer filterIndex;

    /**
     * 每pv发券-预估
     */
    private Double preLaunchPv;

    /**
     * 算法过滤原因(0-不过滤，1-流量预过滤-roi&ctr过滤，2-每pv发券过滤，3-每pv点券过滤)
     */
    private Integer filterType;

    /**
     * 每pv点券预估值
     */
    private Double preChargePv;

}
