package cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter;

import java.io.Serializable;
import java.util.Map;


/**
 * adx流量过滤-定时任务对象
 */

public class AdxFilterInfoDo implements Serializable{

    private static final long serialVersionUID = -2977436449621649823L;

    /**
     * 流量过滤比例({分preInterval：小数})
     */
    private Map<Integer, Double> filterMap;

    /**
     * 上一次流量过滤比例({分preInterval：小数})
     */
    private Map<Integer, Double> lastFilterMap;

    /**
     * 实际ctr-近1h({分preInterval：小数})
     */
    private Map<Integer, Double> ctrHourInterval;

    /**
     * 实际ctr-当天({分preInterval：小数})
     */
    private Map<Integer, Double> ctrDayInterval;

    /**
     * 实际roi-近1h({分preInterval：小数})
     */
    private Map<Integer, Double> roiHourInterval;

    /**
     * 实际roi-当天({分preInterval：小数})
     */
    private Map<Integer, Double> roiDayInterval;

    /**
     * 创意实时ROI
     */
    private Double roiHour;

    /**
     * 创意当天ROI
     */
    private Double roiDay;

    /**
     * 创意实时ctr
     */
    private Double ctrHour;

    /**
     * 创意当天ctr
     */
    private Double ctrDay;

    /**
     * 当天创意统计指标是否置信
     */
    private Boolean dayConfident;

    /**
     * 当前ROI-(小数，如1.50)
     */
    private Double currentMinRoi;


    public Map<Integer, Double> getFilterMap() {
        return filterMap;
    }

    public void setFilterMap(Map<Integer, Double> filterMap) {
        this.filterMap = filterMap;
    }

    public Map<Integer, Double> getLastFilterMap() {
        return lastFilterMap;
    }

    public void setLastFilterMap(Map<Integer, Double> lastFilterMap) {
        this.lastFilterMap = lastFilterMap;
    }

    public Map<Integer, Double> getCtrHourInterval() { return ctrHourInterval; }

    public void setCtrHourInterval(Map<Integer, Double> ctrHourInterval) { this.ctrHourInterval = ctrHourInterval; }

    public Map<Integer, Double> getCtrDayInterval() { return ctrDayInterval; }

    public void setCtrDayInterval(Map<Integer, Double> ctrDayInterval) { this.ctrDayInterval = ctrDayInterval; }

    public Map<Integer, Double> getRoiHourInterval() { return roiHourInterval; }

    public void setRoiHourInterval(Map<Integer, Double> roiHourInterval) { this.roiHourInterval = roiHourInterval; }

    public Map<Integer, Double> getRoiDayInterval() { return roiDayInterval; }

    public void setRoiDayInterval(Map<Integer, Double> roiDayInterval) { this.roiDayInterval = roiDayInterval; }

    public Double getRoiHour() { return roiHour; }

    public void setRoiHour(Double roiHour) { this.roiHour = roiHour; }

    public Double getRoiDay() { return roiDay; }

    public void setRoiDay(Double roiDay) { this.roiDay = roiDay; }

    public Double getCtrHour() { return ctrHour; }

    public void setCtrHour(Double ctrHour) { this.ctrHour = ctrHour; }

    public Double getCtrDay() { return ctrDay; }

    public void setCtrDay(Double ctrDay) { this.ctrDay = ctrDay; }

    public Boolean getDayConfident() { return dayConfident; }

    public void setDayConfident(Boolean dayConfident) { this.dayConfident = dayConfident; }

    public Double getCurrentMinRoi() { return currentMinRoi; }

    public void setCurrentMinRoi(Double currentMinRoi) { this.currentMinRoi = currentMinRoi; }
}
