/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxMaterialRecallDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxMaterialRecallReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxMaterialStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxMaterialTagStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxMaterialTopTagDo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxMaterialRecallAlg {
    private static final Logger logger = LoggerFactory.getLogger(AdxMaterialRecallAlg.class);

    public static AdxMaterialRecallDo adxMaterialRecall(AdxMaterialRecallReqDo recallRequestDo) {
        Integer tagRecallSize = 10;
        Integer recallSize = 30;
        Integer multiRecallSize = 50;
        AdxMaterialRecallDo ret = new AdxMaterialRecallDo();
        if (!AdxMaterialRecallAlg.valid(recallRequestDo).booleanValue()) {
            return ret;
        }
        List<Long> materialList = recallRequestDo.getMaterialList();
        if (materialList.size() <= recallSize) {
            ret.setRecallList(new HashSet<Long>(materialList));
            ret.setMaterialSize(materialList.size());
            return ret;
        }
        ArrayList<AdxMaterialStatDo> materialStatsList = new ArrayList<AdxMaterialStatDo>();
        Map resoMaterialStatInfo = Optional.ofNullable(recallRequestDo.getResoMaterialStatInfo()).orElse(new HashMap());
        materialList.forEach(materialId -> {
            AdxStatsDo materialInfo = Optional.ofNullable(resoMaterialStatInfo.get(materialId)).orElse(new AdxStatsDo());
            AdxMaterialStatDo materialStats = AdxMaterialRecallAlg.getMergeStats(materialId, materialInfo);
            materialStatsList.add(materialStats);
        });
        List<Long> ctrFilterList = materialStatsList.stream().sorted(Comparator.comparing(AdxMaterialStatDo::getWilsonCtr).reversed()).limit(recallSize.intValue()).map(k -> k.getMaterialId()).collect(Collectors.toList());
        List<Long> rpmFilterList = materialStatsList.stream().sorted(Comparator.comparing(AdxMaterialStatDo::getRpm).reversed()).limit(recallSize.intValue()).map(k -> k.getMaterialId()).collect(Collectors.toList());
        ArrayList tagStatsList = new ArrayList();
        Map resoTagStatInfo = Optional.ofNullable(recallRequestDo.getResoTagStatInfo()).orElse(new HashMap());
        resoTagStatInfo.forEach((k, v) -> {
            AdxIndexStatsDo last7DayInfo = AdxStatData.getAdxTimeIndex(v, "7day");
            Double wilsonCtr = AdxStatData.getWilsonScore(last7DayInfo.getClickCnt(), last7DayInfo.getExpCnt());
            AdxMaterialTagStatDo tagStats = new AdxMaterialTagStatDo((Long)k, last7DayInfo.getExpCnt(), last7DayInfo.getClickCnt(), wilsonCtr);
            tagStatsList.add(tagStats);
        });
        List<AdxMaterialTagStatDo> topTagInfo = tagStatsList.stream().sorted(Comparator.comparing(AdxMaterialTagStatDo::getWilsonCtr).reversed()).limit(tagRecallSize.intValue()).collect(Collectors.toList());
        List topTagList = topTagInfo.stream().map(AdxMaterialTagStatDo::getTagId).collect(Collectors.toList());
        ArrayList hitTagInfo = new ArrayList();
        Map materialTagList = Optional.ofNullable(recallRequestDo.getMaterialTagList()).orElse(new HashMap());
        materialList.forEach(materialId -> {
            List tagList = Optional.ofNullable(materialTagList.get(materialId)).orElse(new ArrayList());
            List<Long> intersection = tagList.stream().filter(tag -> topTagList.contains(tag)).collect(Collectors.toList());
            AdxMaterialTopTagDo hitTagDo = new AdxMaterialTopTagDo((Long)materialId, intersection.size(), intersection);
            hitTagInfo.add(hitTagDo);
        });
        List<AdxMaterialTopTagDo> tagFilterList = hitTagInfo.stream().sorted(Comparator.comparing(AdxMaterialTopTagDo::getHitTagCnt).reversed()).limit(recallSize.intValue()).collect(Collectors.toList());
        Set<Long> recallList = AdxMaterialRecallAlg.mergeMultiRecallList(multiRecallSize, ctrFilterList, rpmFilterList, tagFilterList);
        Set<Long> rawList = AdxMaterialRecallAlg.getRawList(materialList, resoMaterialStatInfo);
        ret.setRecallList(recallList);
        ret.setRawList(rawList);
        ret.setMaterialSize(materialList.size());
        ret.setMaterialStatsList(materialStatsList);
        ret.setCtrFilterList(ctrFilterList);
        ret.setRpmFilterList(rpmFilterList);
        ret.setTagFilterList(tagFilterList);
        ret.setTopTagList(topTagInfo);
        return ret;
    }

    private static Boolean valid(AdxMaterialRecallReqDo recallRequestDo) {
        Boolean ret = true;
        if (recallRequestDo == null) {
            logger.warn("AdxMaterialRecallAlg.adxMaterialRecall() input params valid, params recallRequestDo is null");
            return false;
        }
        if (CollectionUtils.isEmpty(recallRequestDo.getMaterialList())) {
            logger.warn("AdxMaterialRecallAlg.adxMaterialRecall() input params valid, params materialList is null, params resourceId is %s, params adxRatioType is %s, params pictureType is %s", new Object[]{recallRequestDo.getResourceId(), recallRequestDo.getAdxRatioType(), recallRequestDo.getPictureType()});
            return false;
        }
        return ret;
    }

    private static AdxMaterialStatDo getMergeStats(Long materialId, AdxStatsDo materialInfo) {
        Double r1 = 0.7;
        Double r2 = 0.2;
        Double r3 = 0.1;
        AdxIndexStatsDo last1HourInfo = AdxStatData.getAdxTimeIndex(materialInfo, "1hour");
        AdxIndexStatsDo last1DayInfo = AdxStatData.getAdxTimeIndex(materialInfo, "1day");
        AdxIndexStatsDo last3DayInfo = AdxStatData.getAdxTimeIndex(materialInfo, "3day");
        Long exp = DataUtil.double2Long((Double)(r1 * (double)last1HourInfo.getExpCnt().longValue() + r2 * (double)last1DayInfo.getExpCnt().longValue() + r3 * (double)last3DayInfo.getExpCnt().longValue()));
        Long click = DataUtil.double2Long((Double)(r1 * (double)last1HourInfo.getClickCnt().longValue() + r2 * (double)last1DayInfo.getClickCnt().longValue() + r3 * (double)last3DayInfo.getClickCnt().longValue()));
        Double wilsonCtr = AdxStatData.getWilsonScore(click, exp);
        Long bid = DataUtil.double2Long((Double)(r1 * (double)last1HourInfo.getBidCnt().longValue() + r2 * (double)last1DayInfo.getBidCnt().longValue() + r3 * (double)last3DayInfo.getBidCnt().longValue()));
        Long adxConsume = DataUtil.double2Long((Double)(r1 * (double)last1HourInfo.getAdxConsume().longValue() + r2 * (double)last1DayInfo.getAdxConsume().longValue() + r3 * (double)last3DayInfo.getAdxConsume().longValue()));
        Long advertConsume = DataUtil.double2Long((Double)(r1 * (double)last1HourInfo.getAdvertConsume().longValue() + r2 * (double)last1DayInfo.getAdvertConsume().longValue() + r3 * (double)last3DayInfo.getAdvertConsume().longValue()));
        Double rpm = AdxStatData.getRpm(bid, adxConsume, advertConsume);
        AdxMaterialStatDo ret = new AdxMaterialStatDo(materialId, exp, click, wilsonCtr, bid, adxConsume, advertConsume, rpm);
        return ret;
    }

    private static Set<Long> mergeMultiRecallList(Integer multiRecallSize, List<Long> ctrFilterList, List<Long> rpmFilterList, List<AdxMaterialTopTagDo> tagFilterList) {
        ArrayList mergeList = new ArrayList();
        ctrFilterList.forEach(material -> mergeList.add(material));
        rpmFilterList.forEach(material -> mergeList.add(material));
        tagFilterList.forEach(materialDo -> mergeList.add(materialDo.getMaterialId()));
        Set<Long> ret = mergeList.stream().distinct().limit(multiRecallSize.intValue()).collect(Collectors.toSet());
        return ret;
    }

    public static Set<Long> getRawList(List<Long> materialList, Map<Long, AdxStatsDo> resoMaterialStatInfo) {
        long expLimit = 200L;
        ArrayList rawList = new ArrayList();
        materialList.forEach(materialId -> {
            AdxStatsDo materialInfo = Optional.ofNullable(resoMaterialStatInfo.get(materialId)).orElse(new AdxStatsDo());
            AdxIndexStatsDo last3DayInfo = AdxStatData.getAdxTimeIndex(materialInfo, "3day");
            if (last3DayInfo.getExpCnt() < expLimit) {
                rawList.add(materialId);
            }
        });
        Set<Long> ret = rawList.stream().collect(Collectors.toSet());
        return ret;
    }
}

